/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.store;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;

public class SqlTypeInterface {
    public static int getSqlType(Class<?> clazz) {
        if (Boolean.class.isAssignableFrom(clazz)) {
            return -7;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return -6;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return 5;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return -5;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 91;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 92;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (Locale.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (Currency.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return -4;
        }
        if (DoubleWritable.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (FloatWritable.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (IntWritable.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (LongWritable.class.isAssignableFrom(clazz)) {
            return -5;
        }
        if (Text.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (VIntWritable.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (VLongWritable.class.isAssignableFrom(clazz)) {
            return -5;
        }
        if (Writable.class.isAssignableFrom(clazz)) {
            return -4;
        }
        if (Utf8.class.isAssignableFrom(clazz)) {
            return 12;
        }
        return 1111;
    }

    public static JdbcType getJdbcType(Schema schema, int length, int scale) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case MAP: {
                return JdbcType.BLOB;
            }
            case ARRAY: {
                return JdbcType.BLOB;
            }
            case BOOLEAN: {
                return JdbcType.BIT;
            }
            case BYTES: {
                return JdbcType.BLOB;
            }
            case DOUBLE: {
                return JdbcType.DOUBLE;
            }
            case ENUM: {
                return JdbcType.VARCHAR;
            }
            case FIXED: {
                return JdbcType.BINARY;
            }
            case FLOAT: {
                return JdbcType.FLOAT;
            }
            case INT: {
                return JdbcType.INTEGER;
            }
            case LONG: {
                return JdbcType.BIGINT;
            }
            case NULL: {
                break;
            }
            case RECORD: {
                return JdbcType.BLOB;
            }
            case STRING: {
                return JdbcType.VARCHAR;
            }
            case UNION: {
                throw new IOException("Union is not supported yet");
            }
        }
        return null;
    }

    public static JdbcType getJdbcType(Class<?> clazz, int length, int scale) throws IOException {
        if (clazz.equals(Enum.class)) {
            return JdbcType.VARCHAR;
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return JdbcType.BLOB;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return JdbcType.BIT;
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return JdbcType.INTEGER;
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return JdbcType.INTEGER;
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return JdbcType.BIGINT;
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return JdbcType.FLOAT;
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return JdbcType.FLOAT;
        }
        if (clazz.equals(String.class)) {
            return JdbcType.VARCHAR;
        }
        throw new RuntimeException("Can't parse data as class: " + clazz);
    }

    public static JdbcType stringToJdbcType(String type) {
        try {
            return JdbcType.valueOf(type);
        }
        catch (IllegalArgumentException ex) {
            return JdbcType.OTHER;
        }
    }

    public static enum JdbcType {
        ARRAY(2003),
        BIT(-7),
        BIGINT(-5),
        BINARY(-2),
        BLOB(2004),
        BOOLEAN(16),
        CHAR(1),
        CLOB(2005),
        DATALINK(70),
        DATE(91),
        DECIMAL(3),
        DISTINCT(2001),
        DOUBLE(8),
        FLOAT(6),
        INTEGER(4),
        LONGNVARCHAR(-16),
        LONGVARBINARY(-4),
        LONGVARCHAR(-1),
        NCHAR(-15),
        NCLOB(2011),
        NULL(0),
        NUMERIC(2),
        NVARCHAR(-9),
        OTHER(1111),
        REAL(7),
        REF(2006),
        ROWID(-8),
        SMALLINT(5),
        SQLXML(2009, "XML"),
        STRUCT(2002),
        TIME(92),
        TIMESTAMP(93),
        TINYINT(-6),
        VARBINARY(-3),
        VARCHAR(12);

        private int order;
        private String sqlType;
        private static HashMap<Integer, JdbcType> map;

        private JdbcType(int order) {
            this.order = order;
        }

        private JdbcType(int order, String sqlType) {
            this.order = order;
            this.sqlType = sqlType;
        }

        public String getSqlType() {
            return this.sqlType == null ? this.toString() : this.sqlType;
        }

        public int getOrder() {
            return this.order;
        }

        public static final JdbcType get(int order) {
            return map.get(order);
        }

        static {
            map = new HashMap();
            for (JdbcType type : JdbcType.values()) {
                map.put(type.order, type);
            }
        }
    }
}

