/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.store;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.ipc.ByteBufferInputStream;
import org.apache.avro.ipc.ByteBufferOutputStream;
import org.apache.avro.specific.SpecificFixed;
import org.apache.avro.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.avro.PersistentDatumReader;
import org.apache.gora.avro.PersistentDatumWriter;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.StateManager;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.sql.query.SqlQuery;
import org.apache.gora.sql.query.SqlResult;
import org.apache.gora.sql.statement.Delete;
import org.apache.gora.sql.statement.InsertUpdateStatement;
import org.apache.gora.sql.statement.InsertUpdateStatementFactory;
import org.apache.gora.sql.statement.SelectStatement;
import org.apache.gora.sql.statement.Where;
import org.apache.gora.sql.store.Column;
import org.apache.gora.sql.store.SqlMapping;
import org.apache.gora.sql.store.SqlTypeInterface;
import org.apache.gora.sql.util.SqlUtils;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;
import org.apache.gora.util.IOUtils;
import org.apache.gora.util.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SqlStore<K, T extends Persistent>
extends DataStoreBase<K, T> {
    private static final Log log = LogFactory.getLog(SqlStore.class);
    protected static final String DRIVER_CLASS_PROPERTY = "jdbc.driver";
    protected static final String URL_PROPERTY = "jdbc.url";
    protected static final String USERNAME_PROPERTY = "jdbc.user";
    protected static final String PASSWORD_PROPERTY = "jdbc.password";
    protected static final String DEFAULT_MAPPING_FILE = "gora-sql-mapping.xml";
    private String jdbcDriverClass;
    private String jdbcUrl;
    private String jdbcUsername;
    private String jdbcPassword;
    private SqlMapping mapping;
    private Connection connection;
    private DatabaseMetaData metadata;
    private boolean dbMixedCaseIdentifiers;
    private boolean dbLowerCaseIdentifiers;
    private boolean dbUpperCaseIdentifiers;
    private HashMap<String, SqlTypeInterface.JdbcType> dbTypeMap;
    private HashSet<PreparedStatement> writeCache;
    private int keySqlType;
    private DbTable sqlTable;
    private Column primaryColumn;
    private String dbProductName;
    private DBVendor dbVendor;

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) throws IOException {
        super.initialize(keyClass, persistentClass, properties);
        this.jdbcDriverClass = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)DRIVER_CLASS_PROPERTY, null);
        this.jdbcUrl = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)URL_PROPERTY, null);
        this.jdbcUsername = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)USERNAME_PROPERTY, null);
        this.jdbcPassword = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)PASSWORD_PROPERTY, null);
        String mappingFile = DataStoreFactory.getMappingFile((Properties)properties, (DataStore)this, (String)DEFAULT_MAPPING_FILE);
        this.connection = this.getConnection();
        this.initDbMetadata();
        this.mapping = this.readMapping(mappingFile);
        this.sqlTable = this.createSqlTable(this.mapping);
        this.writeCache = new HashSet();
        this.keySqlType = SqlTypeInterface.getSqlType(keyClass);
        if (this.autoCreateSchema) {
            this.createSchema();
        }
        this.conf = this.getOrCreateConf();
    }

    public String getSchemaName() {
        return this.mapping.getTableName();
    }

    public void close() throws IOException {
        block4: {
            this.flush();
            if (this.connection != null) {
                try {
                    this.connection.commit();
                    if (this.dbVendor == DBVendor.HSQL && this.jdbcUrl.contains(":file:")) {
                        this.connection.prepareStatement("SHUTDOWN").executeUpdate();
                    }
                    this.connection.close();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("closed")) break block4;
                    throw new IOException(ex);
                }
            }
        }
    }

    private void setColumnConstraintForQuery(CreateTableQuery query, Column column) {
        CreateTableQuery.ColumnConstraint constraint = this.getColumnConstraint(column);
        if (constraint != null) {
            query.setColumnConstraint((com.healthmarketscience.sqlbuilder.dbspec.Column)this.sqlTable.findColumn(column.getName()), constraint);
        }
    }

    public void createSchema() throws IOException {
        if (!this.schemaExists()) {
            log.info((Object)("creating schema: " + this.sqlTable.getAbsoluteName()));
            CreateTableQuery query = new CreateTableQuery((Table)this.sqlTable, true);
            this.setColumnConstraintForQuery(query, this.primaryColumn);
            for (Column column : this.mapping.getFields().values()) {
                this.setColumnConstraintForQuery(query, column);
            }
            PreparedStatement statement = null;
            try {
                statement = this.connection.prepareStatement(((CreateTableQuery)query.validate()).toString());
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    throw new IOException(ex);
                }
                catch (Throwable throwable) {
                    SqlUtils.close(statement);
                    throw throwable;
                }
            }
            SqlUtils.close(statement);
        }
    }

    private CreateTableQuery.ColumnConstraint getColumnConstraint(Column column) {
        if (column.isPrimaryKey()) {
            return CreateTableQuery.ColumnConstraint.PRIMARY_KEY;
        }
        return null;
    }

    public void deleteSchema() throws IOException {
        this.flush();
        if (this.schemaExists()) {
            PreparedStatement statement = null;
            try {
                log.info((Object)("dropping schema:" + this.sqlTable.getAbsoluteName()));
                statement = this.connection.prepareStatement("DROP TABLE " + this.sqlTable.getAbsoluteName());
                statement.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException ex) {
                try {
                    throw new IOException(ex);
                }
                catch (Throwable throwable) {
                    SqlUtils.close(statement);
                    throw throwable;
                }
            }
            SqlUtils.close(statement);
        }
    }

    public boolean schemaExists() throws IOException {
        ResultSet resultSet;
        block4: {
            boolean bl;
            resultSet = null;
            try {
                DatabaseMetaData metadata = this.connection.getMetaData();
                String tableName = this.mapping.getTableName();
                resultSet = metadata.getTables(null, null, tableName, null);
                if (!resultSet.next()) break block4;
                bl = true;
            }
            catch (Exception ex) {
                try {
                    throw new IOException(ex);
                }
                catch (Throwable throwable) {
                    SqlUtils.close(resultSet);
                    throw throwable;
                }
            }
            SqlUtils.close(resultSet);
            return bl;
        }
        SqlUtils.close(resultSet);
        return false;
    }

    public boolean delete(K key) throws IOException {
        boolean bl;
        Delete delete = new Delete();
        delete.from(this.sqlTable.getName()).where().equals(this.primaryColumn.getName(), "?");
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(delete.toString());
            this.setObject(statement, 1, key, this.keySqlType, this.primaryColumn);
            int ret = statement.executeUpdate();
            bl = ret > 0;
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                SqlUtils.close(statement);
                throw throwable;
            }
        }
        SqlUtils.close(statement);
        return bl;
    }

    public long deleteByQuery(Query<K, T> query) throws IOException {
        long l;
        Delete delete = new Delete().from(this.sqlTable.getName());
        delete.where(this.constructWhereClause(query));
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(delete.toString());
            this.setParametersForPreparedStatement(statement, query);
            l = statement.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                SqlUtils.close(statement);
                throw throwable;
            }
        }
        SqlUtils.close(statement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        SQLException deferred = null;
        HashSet<PreparedStatement> hashSet = this.writeCache;
        synchronized (hashSet) {
            for (PreparedStatement stmt : this.writeCache) {
                try {
                    stmt.executeBatch();
                }
                catch (SQLException ex) {
                    deferred = ex;
                    break;
                }
            }
            for (PreparedStatement stmt : this.writeCache) {
                SqlUtils.close(stmt);
            }
            this.writeCache.clear();
        }
        if (deferred != null) {
            throw new IOException(deferred);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public T get(K key, String[] requestFields) throws IOException {
        Persistent persistent;
        PreparedStatement statement;
        ResultSet resultSet;
        block6: {
            requestFields = this.getFieldsToQuery(requestFields);
            resultSet = null;
            statement = null;
            Where where = new Where();
            SelectStatement select = new SelectStatement(this.mapping.getTableName());
            select.setWhere(where);
            for (int i = 0; i < requestFields.length; ++i) {
                Column column = this.mapping.getColumn(requestFields[i]);
                select.addToSelectList(column.getName());
            }
            where.equals(this.primaryColumn.getName(), "?");
            statement = this.getConnection().prepareStatement(select.toString());
            this.setObject(statement, 1, key, this.keySqlType, this.primaryColumn);
            resultSet = statement.executeQuery();
            if (resultSet.next()) break block6;
            T t = null;
            SqlUtils.close(resultSet);
            SqlUtils.close(statement);
            return t;
        }
        try {
            persistent = this.readObject(resultSet, this.newPersistent(), requestFields);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                SqlUtils.close(resultSet);
                SqlUtils.close(statement);
                throw throwable;
            }
        }
        SqlUtils.close(resultSet);
        SqlUtils.close(statement);
        return (T)persistent;
    }

    public Result<K, T> execute(Query<K, T> query) throws IOException {
        query.setFields(this.getFieldsToQuery(query.getFields()));
        String[] requestFields = query.getFields();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            Where where = this.constructWhereClause(query);
            SelectStatement select = new SelectStatement(this.mapping.getTableName());
            select.setWhere(where);
            select.addToSelectList(this.primaryColumn.getName());
            for (int i = 0; i < requestFields.length; ++i) {
                Column column = this.mapping.getColumn(requestFields[i]);
                select.addToSelectList(column.getName());
            }
            if (query.getLimit() > 0L) {
                select.setLimit(query.getLimit());
            }
            statement = this.getConnection().prepareStatement(select.toString());
            this.setParametersForPreparedStatement(statement, query);
            resultSet = statement.executeQuery();
            return new SqlResult<K, T>(this, query, resultSet, statement);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    private Where constructWhereClause(Query<K, T> query) {
        Where where = new Where();
        if (query.getKey() != null) {
            where.equals(this.primaryColumn.getName(), "?");
        } else {
            if (query.getStartKey() != null) {
                where.greaterThanEq(this.primaryColumn.getName(), "?");
            }
            if (query.getEndKey() != null) {
                where.lessThanEq(this.primaryColumn.getName(), "?");
            }
        }
        return where;
    }

    private void setParametersForPreparedStatement(PreparedStatement statement, Query<K, T> query) throws SQLException, IOException {
        int offset = 1;
        if (query.getKey() != null) {
            this.setObject(statement, offset++, query.getKey(), this.keySqlType, this.primaryColumn);
        } else {
            if (query.getStartKey() != null) {
                this.setObject(statement, offset++, query.getStartKey(), this.keySqlType, this.primaryColumn);
            }
            if (query.getEndKey() != null) {
                this.setObject(statement, offset++, query.getEndKey(), this.keySqlType, this.primaryColumn);
            }
        }
    }

    public K readPrimaryKey(ResultSet resultSet) throws SQLException {
        return (K)resultSet.getObject(this.primaryColumn.getName());
    }

    public T readObject(ResultSet rs, T persistent, String[] requestFields) throws SQLException, IOException {
        if (rs == null) {
            return null;
        }
        for (int i = 0; i < requestFields.length; ++i) {
            String f = requestFields[i];
            Schema.Field field = (Schema.Field)this.fieldMap.get(f);
            Schema fieldSchema = field.schema();
            Schema.Type type = fieldSchema.getType();
            Column column = this.mapping.getColumn(field.name());
            String columnName = column.getName();
            int columnIndex = rs.findColumn(columnName);
            if (rs.getObject(columnIndex) == null) continue;
            switch (type) {
                case MAP: {
                    this.readField(rs, columnIndex, persistent.get(field.pos()), fieldSchema, column);
                    break;
                }
                case ARRAY: {
                    this.readField(rs, columnIndex, persistent.get(field.pos()), fieldSchema, column);
                    break;
                }
                case BOOLEAN: {
                    persistent.put(field.pos(), (Object)rs.getBoolean(columnIndex));
                    break;
                }
                case BYTES: {
                    persistent.put(field.pos(), (Object)ByteBuffer.wrap(this.getBytes(rs, columnIndex, fieldSchema, column)));
                    break;
                }
                case DOUBLE: {
                    persistent.put(field.pos(), (Object)rs.getDouble(columnIndex));
                    break;
                }
                case ENUM: {
                    Object val = AvroUtils.getEnumValue((Schema)fieldSchema, (String)rs.getString(columnIndex));
                    persistent.put(field.pos(), val);
                    break;
                }
                case FIXED: {
                    ((SpecificFixed)persistent.get(i)).bytes(this.getBytes(rs, columnIndex, fieldSchema, column));
                    break;
                }
                case FLOAT: {
                    persistent.put(field.pos(), (Object)Float.valueOf(rs.getFloat(columnIndex)));
                    break;
                }
                case INT: {
                    persistent.put(field.pos(), (Object)rs.getInt(columnIndex));
                    break;
                }
                case LONG: {
                    persistent.put(field.pos(), (Object)rs.getLong(columnIndex));
                    break;
                }
                case NULL: {
                    break;
                }
                case RECORD: {
                    Object o = this.readField(rs, columnIndex, persistent.get(field.pos()), fieldSchema, column);
                    persistent.put(field.pos(), o);
                    break;
                }
                case STRING: {
                    persistent.put(field.pos(), (Object)new Utf8(rs.getString(columnIndex)));
                    break;
                }
                case UNION: {
                    throw new IOException("Union is not supported yet");
                }
            }
            persistent.setDirty(field.pos());
        }
        persistent.clearDirty();
        return persistent;
    }

    protected byte[] getBytes(ResultSet resultSet, int columnIndex, Schema schema, Column column) throws SQLException, IOException {
        switch (column.getJdbcType()) {
            case BLOB: {
                Blob blob = resultSet.getBlob(columnIndex);
                return IOUtils.readFully((InputStream)blob.getBinaryStream());
            }
            case BINARY: 
            case VARBINARY: {
                return resultSet.getBytes(columnIndex);
            }
            case LONGVARBINARY: {
                return IOUtils.readFully((InputStream)resultSet.getBinaryStream(columnIndex));
            }
        }
        return null;
    }

    protected Object readField(ResultSet resultSet, int columnIndex, Object field, Schema schema, Column column) throws SQLException, IOException {
        InputStream is = null;
        byte[] bytes = null;
        SqlTypeInterface.JdbcType type = SqlTypeInterface.JdbcType.get(resultSet.getMetaData().getColumnType(columnIndex));
        switch (type) {
            case BLOB: {
                Blob blob = resultSet.getBlob(columnIndex);
                if (blob == null) break;
                is = blob.getBinaryStream();
                break;
            }
            case BINARY: 
            case VARBINARY: {
                bytes = resultSet.getBytes(columnIndex);
                break;
            }
            case LONGVARBINARY: {
                is = resultSet.getBinaryStream(columnIndex);
            }
        }
        if (bytes != null) {
            return IOUtils.deserialize((byte[])bytes, (PersistentDatumReader)this.datumReader, (Schema)schema, (Object)field);
        }
        if (is != null) {
            return IOUtils.deserialize((InputStream)is, (PersistentDatumReader)this.datumReader, (Schema)schema, (Object)field);
        }
        return field;
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        ArrayList<PartitionQuery<K, T>> partitions = new ArrayList<PartitionQuery<K, T>>();
        partitions.add((PartitionQuery<K, T>)new PartitionQueryImpl(query, new String[0]));
        return partitions;
    }

    public Query<K, T> newQuery() {
        return new SqlQuery(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T persistent) throws IOException {
        boolean hasDirty = false;
        try {
            Schema schema = persistent.getSchema();
            StateManager stateManager = persistent.getStateManager();
            List fields = schema.getFields();
            InsertUpdateStatement insertStatement = InsertUpdateStatementFactory.createStatement(this, this.mapping, this.dbVendor);
            insertStatement.setObject(key, null, this.mapping.getPrimaryColumn());
            for (int i = 0; i < fields.size(); ++i) {
                Schema.Field field = (Schema.Field)fields.get(i);
                if (!stateManager.isDirty(persistent, i)) continue;
                hasDirty = true;
                Column column = this.mapping.getColumn(field.name());
                insertStatement.setObject(persistent.get(i), field.schema(), column);
            }
            if (!hasDirty) {
                return;
            }
            PreparedStatement insert = insertStatement.toStatement(this.connection);
            insert.addBatch();
            HashSet<PreparedStatement> hashSet = this.writeCache;
            synchronized (hashSet) {
                this.writeCache.add(insert);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public void setObject(PreparedStatement statement, int index, Object object, Schema schema, Column column) throws SQLException, IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case MAP: {
                this.setField(statement, column, schema, index, object);
                break;
            }
            case ARRAY: {
                this.setField(statement, column, schema, index, object);
                break;
            }
            case BOOLEAN: {
                statement.setBoolean(index, (Boolean)object);
                break;
            }
            case BYTES: {
                this.setBytes(statement, column, index, ((ByteBuffer)object).array());
                break;
            }
            case DOUBLE: {
                statement.setDouble(index, (Double)object);
                break;
            }
            case ENUM: {
                statement.setString(index, ((Enum)object).name());
                break;
            }
            case FIXED: {
                this.setBytes(statement, column, index, ((GenericFixed)object).bytes());
                break;
            }
            case FLOAT: {
                statement.setFloat(index, ((Float)object).floatValue());
                break;
            }
            case INT: {
                statement.setInt(index, (Integer)object);
                break;
            }
            case LONG: {
                statement.setLong(index, (Long)object);
                break;
            }
            case NULL: {
                break;
            }
            case RECORD: {
                this.setField(statement, column, schema, index, object);
                break;
            }
            case STRING: {
                statement.setString(index, ((Utf8)object).toString());
                break;
            }
            case UNION: {
                throw new IOException("Union is not supported yet");
            }
        }
    }

    protected <V> void setObject(PreparedStatement statement, int index, V object, int objectType, Column column) throws SQLException, IOException {
        statement.setObject(index, object, objectType, column.getScaleOrLength());
    }

    protected void setBytes(PreparedStatement statement, Column column, int index, byte[] value) throws SQLException {
        switch (column.getJdbcType()) {
            case BLOB: {
                statement.setBlob(index, new ByteArrayInputStream(value), value.length);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                statement.setBytes(index, value);
                break;
            }
            case LONGVARBINARY: {
                statement.setBinaryStream(index, new ByteArrayInputStream(value));
            }
        }
    }

    protected void setField(PreparedStatement statement, Column column, Schema schema, int index, Object object) throws IOException, SQLException {
        Object os = null;
        Blob blob = null;
        SqlTypeInterface.JdbcType type = column.getJdbcType();
        switch (type) {
            case BLOB: {
                blob = this.connection.createBlob();
                os = blob.setBinaryStream(1L);
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                os = new ByteBufferOutputStream();
            }
        }
        IOUtils.serialize((OutputStream)os, (PersistentDatumWriter)this.datumWriter, (Schema)schema, (Object)object);
        os.close();
        switch (type) {
            case BLOB: {
                statement.setBlob(index, blob);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                statement.setBytes(index, IOUtils.getAsBytes((List)os.getBufferList()));
                break;
            }
            case LONGVARBINARY: {
                statement.setBinaryStream(index, (InputStream)new ByteBufferInputStream(os.getBufferList()));
            }
        }
    }

    protected Connection getConnection() throws IOException {
        try {
            Connection connection = null;
            Class.forName(this.jdbcDriverClass);
            connection = this.jdbcUsername == null || this.jdbcUsername.length() == 0 ? DriverManager.getConnection(this.jdbcUrl) : DriverManager.getConnection(this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    protected void initDbMetadata() throws IOException {
        try {
            this.metadata = this.connection.getMetaData();
            this.dbMixedCaseIdentifiers = this.metadata.storesMixedCaseIdentifiers();
            this.dbLowerCaseIdentifiers = this.metadata.storesLowerCaseIdentifiers();
            this.dbUpperCaseIdentifiers = this.metadata.storesUpperCaseIdentifiers();
            this.dbProductName = this.metadata.getDatabaseProductName();
            this.dbVendor = DBVendor.getVendor(this.dbProductName);
            ResultSet rs = this.metadata.getTypeInfo();
            this.dbTypeMap = new HashMap();
            while (rs.next()) {
                SqlTypeInterface.JdbcType type = SqlTypeInterface.JdbcType.get(rs.getInt("DATA_TYPE"));
                this.dbTypeMap.put(rs.getString("TYPE_NAME"), type);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new IOException();
        }
    }

    protected String getIdentifier(String identifier) {
        if (identifier == null) {
            return identifier;
        }
        if (!this.dbMixedCaseIdentifiers) {
            if (this.dbLowerCaseIdentifiers) {
                return identifier.toLowerCase();
            }
            if (this.dbUpperCaseIdentifiers) {
                return identifier.toUpperCase();
            }
        }
        return identifier;
    }

    private void addColumn(DbTable table, Column column) {
        Integer length = column.getScaleOrLength();
        length = length > 0 ? length : null;
        table.addColumn(column.getName(), column.getSqlType(), length);
    }

    protected DbTable createSqlTable(SqlMapping mapping) {
        DbSpec spec = new DbSpec();
        DbSchema schema = spec.addDefaultSchema();
        DbTable table = schema.addTable(mapping.getTableName());
        this.addColumn(table, this.primaryColumn);
        for (Map.Entry<String, Column> entry : mapping.getFields().entrySet()) {
            this.addColumn(table, entry.getValue());
        }
        return table;
    }

    private void addField(SqlMapping mapping, String fieldName, Element ele) throws IOException {
        SqlTypeInterface.JdbcType jdbcType;
        String columnName = ele.getAttributeValue("column");
        String jdbcTypeStr = ele.getAttributeValue("jdbc-type");
        int length = StringUtils.parseInt((String)ele.getAttributeValue("length"), (int)-1);
        int scale = StringUtils.parseInt((String)ele.getAttributeValue("scale"), (int)-1);
        if (jdbcTypeStr != null) {
            jdbcType = this.dbTypeMap.get(jdbcTypeStr);
            if (jdbcType == null) {
                jdbcType = SqlTypeInterface.stringToJdbcType(jdbcTypeStr);
            }
        } else if (fieldName == null) {
            jdbcType = SqlTypeInterface.getJdbcType(this.keyClass, length, scale);
            mapping.setPrimaryKey(columnName, jdbcType, length, scale);
        } else {
            Schema fieldSchema = this.schema.getField(fieldName).schema();
            jdbcType = SqlTypeInterface.getJdbcType(fieldSchema, length, scale);
            mapping.addField(fieldName, columnName, jdbcType, jdbcTypeStr, length, scale);
        }
        if (fieldName == null) {
            mapping.setPrimaryKey(columnName, jdbcType, length, scale);
        } else {
            mapping.addField(fieldName, columnName, jdbcType, jdbcTypeStr, length, scale);
        }
    }

    protected SqlMapping readMapping(String filename) throws IOException {
        SqlMapping mapping = new SqlMapping();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename));
            List classes = doc.getRootElement().getChildren("class");
            for (Element classElement : classes) {
                if (!classElement.getAttributeValue("keyClass").equals(this.keyClass.getCanonicalName()) || !classElement.getAttributeValue("name").equals(this.persistentClass.getCanonicalName())) continue;
                String tableName = this.getIdentifier(this.getSchemaName(classElement.getAttributeValue("table"), this.persistentClass));
                mapping.setTableName(tableName);
                Element primaryKeyEl = classElement.getChild("primarykey");
                this.addField(mapping, null, primaryKeyEl);
                List fields = classElement.getChildren("field");
                for (Element field : fields) {
                    String fieldName = field.getAttributeValue("name");
                    this.addField(mapping, fieldName, field);
                }
            }
            this.primaryColumn = mapping.getPrimaryColumn();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return mapping;
    }

    public static enum DBVendor {
        MYSQL,
        HSQL,
        GENERIC;


        static DBVendor getVendor(String dbProductName) {
            String name = dbProductName.toLowerCase();
            if (name.contains("mysql")) {
                return MYSQL;
            }
            if (name.contains("hsql")) {
                return HSQL;
            }
            return GENERIC;
        }
    }
}

