/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.statement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.gora.sql.store.SqlMapping;
import org.apache.gora.util.StringUtils;

public class InsertStatement {
    private SqlMapping mapping;
    private String tableName;
    private List<String> columnNames;

    public InsertStatement(SqlMapping mapping, String tableName) {
        this.mapping = mapping;
        this.tableName = tableName;
        this.columnNames = new ArrayList<String>();
    }

    public InsertStatement(SqlMapping mapping, String tableName, String ... columnNames) {
        this.mapping = mapping;
        this.tableName = tableName;
        this.columnNames = Arrays.asList(columnNames);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        builder.append(this.tableName);
        StringUtils.join((StringBuilder)builder.append(" ("), this.columnNames).append(" )");
        builder.append("VALUES (");
        for (i = 0; i < this.columnNames.size(); ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("?");
        }
        builder.append(") ON DUPLICATE KEY UPDATE ");
        this.columnNames.remove(this.mapping.getPrimaryColumnName());
        for (i = 0; i < this.columnNames.size(); ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(this.columnNames.get(i));
            builder.append("=");
            builder.append("?");
        }
        builder.append(";");
        return builder.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String ... columnNames) {
        this.columnNames = Arrays.asList(columnNames);
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public void clear() {
        this.columnNames.clear();
    }
}

