/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.solr.query;

import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.solr.store.SolrMapping;
import org.apache.gora.solr.store.SolrStore;
import org.apache.gora.store.DataStore;

public class SolrQuery<K, T extends PersistentBase>
extends QueryBase<K, T> {
    SolrStore<K, T> store;

    public SolrQuery() {
        super(null);
        this.store = null;
    }

    public SolrQuery(DataStore<K, T> dataStore) {
        super(dataStore);
        this.store = (SolrStore)dataStore;
    }

    public String toSolrQuery() {
        String q;
        SolrMapping mapping = this.store.getMapping();
        String fld = mapping.getPrimaryKey();
        if (this.getKey() != null) {
            q = fld + ":" + SolrStore.escapeQueryKey(this.getKey().toString());
        } else {
            q = fld + ":[";
            q = this.getStartKey() != null ? q + SolrStore.escapeQueryKey(this.getStartKey().toString()) : q + "*";
            q = q + " TO ";
            q = this.getEndKey() != null ? q + SolrStore.escapeQueryKey(this.getEndKey().toString()) : q + "*";
            q = q + "]";
        }
        return q;
    }
}

