/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.solr.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.solr.query.SolrQuery;
import org.apache.gora.solr.store.SolrStore;
import org.apache.gora.store.DataStore;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrResult<K, T extends PersistentBase>
extends ResultBase<K, T> {
    SolrDocumentList list = null;
    SolrStore<K, T> store;
    String[] fields;
    int pos = 0;

    public SolrResult(DataStore<K, T> dataStore, Query<K, T> query, SolrServer server, int resultsSize) throws IOException {
        super(dataStore, query);
        this.store = (SolrStore)dataStore;
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (query instanceof PartitionQueryImpl) {
            query = ((PartitionQueryImpl)query).getBaseQuery();
        }
        String q = ((SolrQuery)query).toSolrQuery();
        params.set("q", new String[]{q});
        this.fields = query.getFields();
        if (this.fields == null) {
            params.set("fl", new String[]{"*"});
        } else {
            HashSet<String> uniqFields = new HashSet<String>(Arrays.asList(this.fields));
            String keyFld = ((SolrStore)dataStore).getMapping().getPrimaryKey();
            uniqFields.add(keyFld);
            StringBuilder sb = new StringBuilder();
            for (String f : uniqFields) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(f);
            }
            params.set("fl", new String[]{sb.toString()});
        }
        params.set("rows", resultsSize);
        try {
            QueryResponse rsp = server.query((SolrParams)params);
            this.list = rsp.getResults();
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    protected boolean nextInner() throws IOException {
        if (this.list == null || this.pos >= this.list.size()) {
            return false;
        }
        SolrDocument doc = (SolrDocument)this.list.get(this.pos++);
        this.key = doc.get((Object)this.store.getMapping().getPrimaryKey());
        this.persistent = this.store.newInstance(doc, this.fields);
        return true;
    }

    public void close() throws IOException {
        if (this.list != null) {
            this.list.clear();
        }
    }

    public float getProgress() throws IOException {
        if (this.list != null && this.list.size() > 0) {
            return (float)this.pos / (float)this.list.size();
        }
        return 0.0f;
    }
}

