/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.solr;

import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.gora.GoraTestDriver;
import org.apache.gora.solr.store.SolrStore;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;

public class GoraSolrTestDriver
extends GoraTestDriver {
    JettySolrRunner solr;

    public GoraSolrTestDriver() {
        super(SolrStore.class);
    }

    public void setUpClass() throws Exception {
        super.setUpClass();
        this.solr = new JettySolrRunner("src/test/conf/solr", "/solr", 9876);
        this.solr.start();
    }

    public void tearDownClass() throws Exception {
        super.tearDownClass();
        if (this.solr != null) {
            this.solr.stop();
            this.solr = null;
        }
        this.cleanupDirectoriesFailover();
    }

    private void cleanupDirectoriesFailover() {
        int tries = 3;
        while (tries-- > 0) {
            try {
                this.cleanupDirectories();
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void cleanupDirectories() throws Exception {
        File employeeDirFile = new File("src/test/conf/solr/Employee/data");
        File webpageDirFile = new File("src/test/conf/solr/WebPage/data");
        if (employeeDirFile.exists()) {
            FileUtils.deleteDirectory((File)employeeDirFile);
        }
        if (webpageDirFile.exists()) {
            FileUtils.deleteDirectory((File)webpageDirFile);
        }
    }

    protected void setProperties(Properties properties) {
        super.setProperties(properties);
    }
}

