/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.solr.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.solr.query.SolrQuery;
import org.apache.gora.solr.query.SolrResult;
import org.apache.gora.solr.store.SolrMapping;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;
import org.apache.gora.util.IOUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrStore<K, T extends PersistentBase>
extends DataStoreBase<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(SolrStore.class);
    protected static final String DEFAULT_MAPPING_FILE = "gora-solr-mapping.xml";
    protected static final String SOLR_URL_PROPERTY = "solr.url";
    protected static final String SOLR_CONFIG_PROPERTY = "solr.config";
    protected static final String SOLR_SCHEMA_PROPERTY = "solr.schema";
    protected static final String SOLR_BATCH_SIZE_PROPERTY = "solr.batchSize";
    protected static final String SOLR_COMMIT_WITHIN_PROPERTY = "solr.commitWithin";
    protected static final String SOLR_RESULTS_SIZE_PROPERTY = "solr.resultsSize";
    protected static final int DEFAULT_BATCH_SIZE = 100;
    protected static final int DEFAULT_COMMIT_WITHIN = 1000;
    protected static final int DEFAULT_RESULTS_SIZE = 100;
    private SolrMapping mapping;
    private String solrServerUrl;
    private String solrConfig;
    private String solrSchema;
    private SolrServer server;
    private SolrServer adminServer;
    private ArrayList<SolrInputDocument> batch;
    private int batchSize = 100;
    private int commitWithin = 1000;
    private int resultsSize = 100;
    public static int DEFAULT_UNION_SCHEMA = 0;
    public static final ConcurrentHashMap<String, SpecificDatumReader<?>> readerMap = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, SpecificDatumWriter<?>> writerMap = new ConcurrentHashMap();

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        String resultsSizeString;
        String batchSizeString;
        super.initialize(keyClass, persistentClass, properties);
        try {
            String mappingFile = DataStoreFactory.getMappingFile((Properties)properties, (DataStore)this, (String)DEFAULT_MAPPING_FILE);
            this.mapping = this.readMapping(mappingFile);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
        this.solrServerUrl = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)SOLR_URL_PROPERTY, null);
        this.solrConfig = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)SOLR_CONFIG_PROPERTY, null);
        this.solrSchema = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)SOLR_SCHEMA_PROPERTY, null);
        LOG.info("Using Solr server at " + this.solrServerUrl);
        this.adminServer = new HttpSolrServer(this.solrServerUrl);
        this.server = new HttpSolrServer(this.solrServerUrl + "/" + this.mapping.getCoreName());
        if (this.autoCreateSchema) {
            this.createSchema();
        }
        if ((batchSizeString = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)SOLR_BATCH_SIZE_PROPERTY, null)) != null) {
            try {
                this.batchSize = Integer.parseInt(batchSizeString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Invalid batch size '" + batchSizeString + "', using default " + 100);
            }
        }
        this.batch = new ArrayList(this.batchSize);
        String commitWithinString = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)SOLR_COMMIT_WITHIN_PROPERTY, null);
        if (commitWithinString != null) {
            try {
                this.commitWithin = Integer.parseInt(commitWithinString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Invalid commit within '" + commitWithinString + "', using default " + 1000);
            }
        }
        if ((resultsSizeString = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)SOLR_RESULTS_SIZE_PROPERTY, null)) != null) {
            try {
                this.resultsSize = Integer.parseInt(resultsSizeString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Invalid results size '" + resultsSizeString + "', using default " + 100);
            }
        }
    }

    private SolrMapping readMapping(String filename) throws IOException {
        SolrMapping map = new SolrMapping();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename));
            List classes = doc.getRootElement().getChildren("class");
            for (Element classElement : classes) {
                if (!classElement.getAttributeValue("keyClass").equals(this.keyClass.getCanonicalName()) || !classElement.getAttributeValue("name").equals(this.persistentClass.getCanonicalName())) continue;
                String tableName = this.getSchemaName(classElement.getAttributeValue("table"), this.persistentClass);
                map.setCoreName(tableName);
                Element primaryKeyEl = classElement.getChild("primarykey");
                map.setPrimaryKey(primaryKeyEl.getAttributeValue("column"));
                List fields = classElement.getChildren("field");
                for (Element field : fields) {
                    String fieldName = field.getAttributeValue("name");
                    String columnName = field.getAttributeValue("column");
                    map.addField(fieldName, columnName);
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return map;
    }

    public SolrMapping getMapping() {
        return this.mapping;
    }

    public String getSchemaName() {
        return this.mapping.getCoreName();
    }

    public void createSchema() {
        try {
            if (!this.schemaExists()) {
                CoreAdminRequest.createCore((String)this.mapping.getCoreName(), (String)this.mapping.getCoreName(), (SolrServer)this.adminServer, (String)this.solrConfig, (String)this.solrSchema);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
        }
    }

    public void truncateSchema() {
        try {
            this.server.deleteByQuery("*:*");
            this.server.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
        }
    }

    public void deleteSchema() {
        try {
            this.server.deleteByQuery("*:*");
            this.server.commit();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CoreAdminRequest.unloadCore((String)this.mapping.getCoreName(), (SolrServer)this.adminServer);
        }
        catch (Exception e) {
            if (e.getMessage().contains("No such core")) {
                return;
            }
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
        }
    }

    public boolean schemaExists() {
        boolean exists = false;
        try {
            CoreAdminResponse rsp = CoreAdminRequest.getStatus((String)this.mapping.getCoreName(), (SolrServer)this.adminServer);
            exists = rsp.getUptime(this.mapping.getCoreName()) != null;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
        }
        return exists;
    }

    private static final String toDelimitedString(String[] arr, String sep) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String escapeQueryKey(String key) {
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            switch (c) {
                case '*': 
                case ':': {
                    sb.append("\\" + c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public T get(K key, String[] fields) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/get"});
        params.set("fl", new String[]{SolrStore.toDelimitedString(fields, ",")});
        params.set("id", new String[]{key.toString()});
        try {
            QueryResponse rsp = this.server.query((SolrParams)params);
            Object o = rsp.getResponse().get("doc");
            if (o == null) {
                return null;
            }
            return this.newInstance((SolrDocument)o, fields);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
            return null;
        }
    }

    public T newInstance(SolrDocument doc, String[] fields) throws IOException {
        PersistentBase persistent = this.newPersistent();
        if (fields == null) {
            fields = this.fieldMap.keySet().toArray(new String[this.fieldMap.size()]);
        }
        String pk = this.mapping.getPrimaryKey();
        for (String f : fields) {
            Schema.Field field = (Schema.Field)this.fieldMap.get(f);
            Schema fieldSchema = field.schema();
            String sf = null;
            sf = pk.equals(f) ? f : this.mapping.getSolrField(f);
            Object sv = doc.get((Object)sf);
            if (sv == null) continue;
            Object v = this.deserializeFieldValue(field, fieldSchema, sv, persistent);
            persistent.put(field.pos(), v);
            persistent.setDirty(field.pos());
        }
        persistent.clearDirty();
        return (T)persistent;
    }

    private SpecificDatumReader getDatumReader(String schemaId, Schema fieldSchema) {
        SpecificDatumReader reader = readerMap.get(schemaId);
        if (reader == null) {
            reader = new SpecificDatumReader(fieldSchema);
            SpecificDatumReader localReader = null;
            localReader = readerMap.putIfAbsent(schemaId, reader);
            if (localReader != null) {
                reader = localReader;
            }
        }
        return reader;
    }

    private SpecificDatumWriter getDatumWriter(String schemaId, Schema fieldSchema) {
        SpecificDatumWriter writer = writerMap.get(schemaId);
        if (writer == null) {
            writer = new SpecificDatumWriter(fieldSchema);
            writerMap.put(schemaId, writer);
        }
        return writer;
    }

    private Object deserializeFieldValue(Schema.Field field, Schema fieldSchema, Object solrValue, T persistent) throws IOException {
        Object fieldValue = null;
        switch (fieldSchema.getType()) {
            case MAP: 
            case ARRAY: 
            case RECORD: {
                SpecificDatumReader reader = this.getDatumReader(fieldSchema.getFullName(), fieldSchema);
                fieldValue = IOUtils.deserialize((byte[])((byte[])solrValue), (SpecificDatumReader)reader, (Schema)fieldSchema, (Object)persistent.get(field.pos()));
                break;
            }
            case ENUM: {
                fieldValue = AvroUtils.getEnumValue((Schema)fieldSchema, (String)((String)solrValue));
                break;
            }
            case FIXED: {
                throw new IOException("???");
            }
            case BYTES: {
                fieldValue = ByteBuffer.wrap((byte[])solrValue);
                break;
            }
            case STRING: {
                fieldValue = new Utf8(solrValue.toString());
                break;
            }
            case UNION: {
                if (fieldSchema.getTypes().size() == 2 && this.isNullable(fieldSchema)) {
                    Schema.Type type1;
                    Schema.Type type0 = ((Schema)fieldSchema.getTypes().get(0)).getType();
                    fieldSchema = !type0.equals((Object)(type1 = ((Schema)fieldSchema.getTypes().get(1)).getType())) ? (type0.equals((Object)Schema.Type.NULL) ? (Schema)fieldSchema.getTypes().get(1) : (Schema)fieldSchema.getTypes().get(0)) : (Schema)fieldSchema.getTypes().get(0);
                    fieldValue = this.deserializeFieldValue(field, fieldSchema, solrValue, persistent);
                    break;
                }
                SpecificDatumReader unionReader = this.getDatumReader(String.valueOf(fieldSchema.hashCode()), fieldSchema);
                fieldValue = IOUtils.deserialize((byte[])((byte[])solrValue), (SpecificDatumReader)unionReader, (Schema)fieldSchema, (Object)persistent.get(field.pos()));
                break;
            }
            default: {
                fieldValue = solrValue;
            }
        }
        return fieldValue;
    }

    public void put(K key, T persistent) {
        Schema schema = persistent.getSchema();
        if (!persistent.isDirty()) {
            return;
        }
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(this.mapping.getPrimaryKey(), key);
        List fields = schema.getFields();
        for (Schema.Field field : fields) {
            String sf = this.mapping.getSolrField(field.name());
            if (sf == null) continue;
            Schema fieldSchema = field.schema();
            Object v = persistent.get(field.pos());
            if (v == null) continue;
            v = this.serializeFieldValue(fieldSchema, v);
            doc.addField(sf, v);
        }
        LOG.info("DOCUMENT: " + doc);
        this.batch.add(doc);
        if (this.batch.size() >= this.batchSize) {
            try {
                this.add(this.batch, this.commitWithin);
                this.batch.clear();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
            }
        }
    }

    private Object serializeFieldValue(Schema fieldSchema, Object fieldValue) {
        switch (fieldSchema.getType()) {
            case MAP: 
            case ARRAY: 
            case RECORD: {
                byte[] data = null;
                try {
                    SpecificDatumWriter writer = this.getDatumWriter(fieldSchema.getFullName(), fieldSchema);
                    data = IOUtils.serialize((SpecificDatumWriter)writer, (Schema)fieldSchema, (Object)fieldValue);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
                }
                fieldValue = data;
                break;
            }
            case BYTES: {
                fieldValue = ((ByteBuffer)fieldValue).array();
                break;
            }
            case ENUM: 
            case STRING: {
                fieldValue = fieldValue.toString();
                break;
            }
            case UNION: {
                if (fieldSchema.getTypes().size() == 2 && this.isNullable(fieldSchema)) {
                    int schemaPos = this.getUnionSchema(fieldValue, fieldSchema);
                    Schema unionSchema = (Schema)fieldSchema.getTypes().get(schemaPos);
                    fieldValue = this.serializeFieldValue(unionSchema, fieldValue);
                    break;
                }
                byte[] serilazeData = null;
                try {
                    SpecificDatumWriter writer = this.getDatumWriter(String.valueOf(fieldSchema.hashCode()), fieldSchema);
                    serilazeData = IOUtils.serialize((SpecificDatumWriter)writer, (Schema)fieldSchema, (Object)fieldValue);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
                }
                fieldValue = serilazeData;
                break;
            }
        }
        return fieldValue;
    }

    private boolean isNullable(Schema unionSchema) {
        for (Schema innerSchema : unionSchema.getTypes()) {
            if (!innerSchema.getType().equals((Object)Schema.Type.NULL)) continue;
            return true;
        }
        return false;
    }

    private int getUnionSchema(Object pValue, Schema pUnionSchema) {
        int unionSchemaPos = 0;
        Iterator it = pUnionSchema.getTypes().iterator();
        while (it.hasNext()) {
            Schema.Type schemaType = ((Schema)it.next()).getType();
            if (pValue instanceof Utf8 && schemaType.equals((Object)Schema.Type.STRING)) {
                return unionSchemaPos;
            }
            if (pValue instanceof ByteBuffer && schemaType.equals((Object)Schema.Type.BYTES)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Integer && schemaType.equals((Object)Schema.Type.INT)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Long && schemaType.equals((Object)Schema.Type.LONG)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Double && schemaType.equals((Object)Schema.Type.DOUBLE)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Float && schemaType.equals((Object)Schema.Type.FLOAT)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Boolean && schemaType.equals((Object)Schema.Type.BOOLEAN)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Map && schemaType.equals((Object)Schema.Type.MAP)) {
                return unionSchemaPos;
            }
            if (pValue instanceof List && schemaType.equals((Object)Schema.Type.ARRAY)) {
                return unionSchemaPos;
            }
            if (pValue instanceof Persistent && schemaType.equals((Object)Schema.Type.RECORD)) {
                return unionSchemaPos;
            }
            ++unionSchemaPos;
        }
        return DEFAULT_UNION_SCHEMA;
    }

    public boolean delete(K key) {
        String keyField = this.mapping.getPrimaryKey();
        try {
            UpdateResponse rsp = this.server.deleteByQuery(keyField + ":" + SolrStore.escapeQueryKey(key.toString()));
            this.server.commit();
            LOG.info(rsp.toString());
            return true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
            return false;
        }
    }

    public long deleteByQuery(Query<K, T> query) {
        String q = ((SolrQuery)query).toSolrQuery();
        try {
            UpdateResponse rsp = this.server.deleteByQuery(q);
            this.server.commit();
            LOG.info(rsp.toString());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
        }
        return 0L;
    }

    public Result<K, T> execute(Query<K, T> query) {
        try {
            return new SolrResult<K, T>(this, query, this.server, this.resultsSize);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Object)e.getStackTrace().toString());
            return null;
        }
    }

    public Query<K, T> newQuery() {
        return new SolrQuery(this);
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        ArrayList<PartitionQuery<K, T>> partitions = new ArrayList<PartitionQuery<K, T>>();
        PartitionQueryImpl pqi = new PartitionQueryImpl(query, new String[0]);
        pqi.setConf(this.getConf());
        partitions.add((PartitionQuery<K, T>)pqi);
        return partitions;
    }

    public void flush() {
        try {
            if (this.batch.size() > 0) {
                this.add(this.batch, this.commitWithin);
                this.batch.clear();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Object[])e.getStackTrace());
        }
    }

    public void close() {
    }

    private void add(ArrayList<SolrInputDocument> batch, int commitWithin) throws SolrServerException, IOException {
        if (commitWithin == 0) {
            this.server.add(batch);
            this.server.commit(false, true, true);
        } else {
            this.server.add(batch, commitWithin);
        }
    }
}

