/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.jcache.store;

import javax.cache.configuration.Factory;
import org.apache.gora.jcache.store.JCacheCacheWriter;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheCacheWriterFactory<K, T extends PersistentBase>
implements Factory<JCacheCacheWriter<K, T>> {
    public static final long serialVersionUID = 201205101621L;
    private static final Logger LOG = LoggerFactory.getLogger(JCacheCacheWriterFactory.class);
    private transient JCacheCacheWriter<K, T> instance;
    private Class<K> keyClass;
    private Class<T> persistentClass;

    public JCacheCacheWriterFactory(JCacheCacheWriter<K, T> instance, Class<K> keyClass, Class<T> persistentClass) {
        this.keyClass = keyClass;
        this.persistentClass = persistentClass;
        LOG.info("JCache cache writer factory initialized successfully.");
        this.instance = instance;
    }

    public JCacheCacheWriter<K, T> create() {
        if (this.instance != null) {
            return this.instance;
        }
        try {
            this.instance = new JCacheCacheWriter(DataStoreFactory.getDataStore(this.keyClass, this.persistentClass, (Configuration)new Configuration()));
        }
        catch (GoraException ex) {
            LOG.error("Couldn't initialize persistent dataStore for cache writer.", (Throwable)ex);
            return null;
        }
        return this.instance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other != null && this.getClass() == other.getClass();
    }

    public int hashCode() {
        return this.hashCode();
    }
}

