/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.jcache.store;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.spi.CachingProvider;
import org.apache.avro.Schema;
import org.apache.gora.jcache.query.JCacheQuery;
import org.apache.gora.jcache.query.JCacheResult;
import org.apache.gora.jcache.store.JCacheCacheEntryListener;
import org.apache.gora.jcache.store.JCacheCacheFactoryBuilder;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheStore<K, T extends PersistentBase>
extends DataStoreBase<K, T> {
    private static final String GORA_DEFAULT_JCACHE_NAMESPACE = "gora.jcache.namespace";
    private static final String GORA_DEFAULT_JCACHE_PROVIDER_KEY = "gora.datastore.jcache.provider";
    private static final String GORA_DEFAULT_JCACHE_HAZELCAST_CONFIG_KEY = "gora.datastore.jcache.hazelcast.config";
    private static final String JCACHE_READ_THROUGH_PROPERTY_KEY = "jcache.read.through.enable";
    private static final String JCACHE_WRITE_THROUGH_PROPERTY_KEY = "jcache.write.through.enable";
    private static final String JCACHE_STORE_BY_VALUE_PROPERTY_KEY = "jcache.store.by.value.enable";
    private static final String JCACHE_STATISTICS_PROPERTY_KEY = "jcache.statistics.enable";
    private static final String JCACHE_MANAGEMENT_PROPERTY_KEY = "jcache.management.enable";
    private static final String JCACHE_CACHE_NAMESPACE_PROPERTY_KEY = "jcache.cache.namespace";
    private static final String JCACHE_EVICTION_POLICY_PROPERTY_KEY = "jcache.eviction.policy";
    private static final String JCACHE_EVICTION_MAX_SIZE_POLICY_PROPERTY_KEY = "jcache.eviction.max.size.policy";
    private static final String JCACHE_EVICTION_SIZE_PROPERTY_KEY = "jcache.eviction.size";
    private static final String JCACHE_EXPIRE_POLICY_PROPERTY_KEY = "jcache.expire.policy";
    private static final String JCACHE_EXPIRE_POLICY_DURATION_PROPERTY_KEY = "jcache.expire.policy.duration";
    private static final String JCACHE_ACCESSED_EXPIRY_IDENTIFIER = "ACCESSED";
    private static final String JCACHE_CREATED_EXPIRY_IDENTIFIER = "CREATED";
    private static final String JCACHE_MODIFIED_EXPIRY_IDENTIFIER = "MODIFIED";
    private static final String JCACHE_TOUCHED_EXPIRY_IDENTIFIER = "TOUCHED";
    private static final String HAZELCAST_CACHE_IN_MEMORY_FORMAT_PROPERTY_KEY = "jcache.cache.inmemory.format";
    private static final String HAZELCAST_CACHE_BINARY_IN_MEMORY_FORMAT_IDENTIFIER = "BINARY";
    private static final String HAZELCAST_CACHE_OBJECT_IN_MEMORY_FORMAT_IDENTIFIER = "OBJECT";
    private static final String HAZELCAST_CACHE_NATIVE_IN_MEMORY_FORMAT_IDENTIFIER = "NATIVE";
    private static final String JCACHE_AUTO_CREATE_CACHE_PROPERTY_KEY = "jcache.auto.create.cache";
    private static final String HAZELCAST_SERVER_CACHE_PROVIDER_IDENTIFIER = "Server";
    private static final Logger LOG = LoggerFactory.getLogger(JCacheStore.class);
    private ICache<K, T> cache;
    private CacheManager manager;
    private ConcurrentSkipListSet<K> cacheEntryList;
    private String goraCacheNamespace = "gora.jcache.namespace";
    private DataStore<K, T> persistentDataStore;
    private CacheConfig<K, T> cacheConfig;
    private HazelcastInstance hazelcastInstance;

    private static <T extends PersistentBase> T getPersistent(T persitent, String[] fields) {
        List otherFields = persitent.getSchema().getFields();
        Object[] otherFieldStrings = new String[otherFields.size()];
        for (int i = 0; i < otherFields.size(); ++i) {
            otherFieldStrings[i] = ((Schema.Field)otherFields.get(i)).name();
        }
        if (Arrays.equals(fields, otherFieldStrings)) {
            return persitent;
        }
        PersistentBase clonedPersistent = AvroUtils.deepClonePersistent(persitent);
        clonedPersistent.clear();
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                Schema.Field otherField = persitent.getSchema().getField(field);
                int index = otherField.pos();
                clonedPersistent.put(index, persitent.get(index));
            }
        } else {
            for (Object field : otherFieldStrings) {
                Schema.Field otherField = persitent.getSchema().getField((String)field);
                int index = otherField.pos();
                clonedPersistent.put(index, persitent.get(index));
            }
        }
        return (T)clonedPersistent;
    }

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        ClasspathXmlConfig config;
        super.initialize(keyClass, persistentClass, properties);
        CachingProvider cachingProvider = Caching.getCachingProvider((String)properties.getProperty(GORA_DEFAULT_JCACHE_PROVIDER_KEY));
        if (properties.getProperty(JCACHE_CACHE_NAMESPACE_PROPERTY_KEY) != null) {
            this.goraCacheNamespace = properties.getProperty(JCACHE_CACHE_NAMESPACE_PROPERTY_KEY);
        }
        try {
            this.persistentDataStore = DataStoreFactory.getDataStore(keyClass, persistentClass, (Configuration)new Configuration());
        }
        catch (GoraException ex) {
            LOG.error("Couldn't initialize persistent DataStore.", (Throwable)ex);
        }
        if (properties.getProperty(GORA_DEFAULT_JCACHE_PROVIDER_KEY).contains(HAZELCAST_SERVER_CACHE_PROVIDER_IDENTIFIER)) {
            config = new ClasspathXmlConfig(properties.getProperty(GORA_DEFAULT_JCACHE_HAZELCAST_CONFIG_KEY));
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        } else {
            try {
                config = new XmlClientConfigBuilder(properties.getProperty(GORA_DEFAULT_JCACHE_HAZELCAST_CONFIG_KEY)).build();
                this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
            }
            catch (IOException ex) {
                LOG.error("Couldn't locate the client side cache provider configuration.", (Throwable)ex);
            }
        }
        Properties providerProperties = new Properties();
        providerProperties.setProperty("hazelcast.instance.name", this.hazelcastInstance.getName());
        try {
            this.manager = cachingProvider.getCacheManager(new URI(this.goraCacheNamespace), null, providerProperties);
        }
        catch (URISyntaxException ex) {
            LOG.error("Couldn't initialize cache manager to bounded hazelcast instance.", (Throwable)ex);
            this.manager = cachingProvider.getCacheManager();
        }
        if (properties.getProperty(JCACHE_AUTO_CREATE_CACHE_PROPERTY_KEY) != null && Boolean.valueOf(properties.getProperty(JCACHE_AUTO_CREATE_CACHE_PROPERTY_KEY)).booleanValue() || this.manager.getCache(super.getPersistentClass().getSimpleName(), keyClass, persistentClass) == null) {
            String inMemoryFormat;
            this.cacheEntryList = new ConcurrentSkipListSet();
            this.cacheConfig = new CacheConfig();
            this.cacheConfig.setTypes(keyClass, persistentClass);
            if (properties.getProperty(JCACHE_READ_THROUGH_PROPERTY_KEY) != null) {
                this.cacheConfig.setReadThrough(Boolean.valueOf(properties.getProperty(JCACHE_READ_THROUGH_PROPERTY_KEY)).booleanValue());
            } else {
                this.cacheConfig.setReadThrough(true);
            }
            if (properties.getProperty(JCACHE_WRITE_THROUGH_PROPERTY_KEY) != null) {
                this.cacheConfig.setWriteThrough(Boolean.valueOf(properties.getProperty(JCACHE_WRITE_THROUGH_PROPERTY_KEY)).booleanValue());
            } else {
                this.cacheConfig.setWriteThrough(true);
            }
            if (properties.getProperty(JCACHE_STORE_BY_VALUE_PROPERTY_KEY) != null) {
                this.cacheConfig.setStoreByValue(Boolean.valueOf(properties.getProperty(JCACHE_STORE_BY_VALUE_PROPERTY_KEY)).booleanValue());
            }
            if (properties.getProperty(JCACHE_STATISTICS_PROPERTY_KEY) != null) {
                this.cacheConfig.setStatisticsEnabled(Boolean.valueOf(properties.getProperty(JCACHE_STATISTICS_PROPERTY_KEY)).booleanValue());
            }
            if (properties.getProperty(JCACHE_MANAGEMENT_PROPERTY_KEY) != null) {
                this.cacheConfig.setStatisticsEnabled(Boolean.valueOf(properties.getProperty(JCACHE_MANAGEMENT_PROPERTY_KEY)).booleanValue());
            }
            if (properties.getProperty(JCACHE_EVICTION_POLICY_PROPERTY_KEY) != null) {
                this.cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.valueOf((String)properties.getProperty(JCACHE_EVICTION_POLICY_PROPERTY_KEY)));
            }
            if (properties.getProperty(JCACHE_EVICTION_MAX_SIZE_POLICY_PROPERTY_KEY) != null) {
                this.cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf((String)properties.getProperty(JCACHE_EVICTION_MAX_SIZE_POLICY_PROPERTY_KEY)));
            }
            if (properties.getProperty(JCACHE_EVICTION_SIZE_PROPERTY_KEY) != null) {
                this.cacheConfig.getEvictionConfig().setSize(Integer.valueOf(properties.getProperty(JCACHE_EVICTION_SIZE_PROPERTY_KEY)).intValue());
            }
            if (properties.getProperty(JCACHE_EXPIRE_POLICY_PROPERTY_KEY) != null) {
                String expiryPolicyIdentifier = properties.getProperty(JCACHE_EXPIRE_POLICY_PROPERTY_KEY);
                if (expiryPolicyIdentifier.equals(JCACHE_ACCESSED_EXPIRY_IDENTIFIER)) {
                    this.cacheConfig.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new AccessedExpiryPolicy(new Duration(TimeUnit.SECONDS, (long)Integer.valueOf(properties.getProperty(JCACHE_EXPIRE_POLICY_DURATION_PROPERTY_KEY)).intValue()))));
                } else if (expiryPolicyIdentifier.equals(JCACHE_CREATED_EXPIRY_IDENTIFIER)) {
                    this.cacheConfig.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new CreatedExpiryPolicy(new Duration(TimeUnit.SECONDS, (long)Integer.valueOf(properties.getProperty(JCACHE_EXPIRE_POLICY_DURATION_PROPERTY_KEY)).intValue()))));
                } else if (expiryPolicyIdentifier.equals(JCACHE_MODIFIED_EXPIRY_IDENTIFIER)) {
                    this.cacheConfig.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new ModifiedExpiryPolicy(new Duration(TimeUnit.SECONDS, (long)Integer.valueOf(properties.getProperty(JCACHE_EXPIRE_POLICY_DURATION_PROPERTY_KEY)).intValue()))));
                } else if (expiryPolicyIdentifier.equals(JCACHE_TOUCHED_EXPIRY_IDENTIFIER)) {
                    this.cacheConfig.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new TouchedExpiryPolicy(new Duration(TimeUnit.SECONDS, (long)Integer.valueOf(properties.getProperty(JCACHE_EXPIRE_POLICY_DURATION_PROPERTY_KEY)).intValue()))));
                }
            }
            if (properties.getProperty(HAZELCAST_CACHE_IN_MEMORY_FORMAT_PROPERTY_KEY) != null && ((inMemoryFormat = properties.getProperty(HAZELCAST_CACHE_IN_MEMORY_FORMAT_PROPERTY_KEY)).equals(HAZELCAST_CACHE_BINARY_IN_MEMORY_FORMAT_IDENTIFIER) || inMemoryFormat.equals(HAZELCAST_CACHE_OBJECT_IN_MEMORY_FORMAT_IDENTIFIER) || inMemoryFormat.equals(HAZELCAST_CACHE_NATIVE_IN_MEMORY_FORMAT_IDENTIFIER))) {
                this.cacheConfig.setInMemoryFormat(InMemoryFormat.valueOf((String)inMemoryFormat));
            }
            this.cacheConfig.setCacheLoaderFactory(JCacheCacheFactoryBuilder.factoryOfCacheLoader(this.persistentDataStore, keyClass, persistentClass));
            this.cacheConfig.setCacheWriterFactory(JCacheCacheFactoryBuilder.factoryOfCacheWriter(this.persistentDataStore, keyClass, persistentClass));
            this.cache = (ICache)this.manager.createCache(persistentClass.getSimpleName(), this.cacheConfig).unwrap(ICache.class);
        } else {
            this.cache = (ICache)this.manager.getCache(super.getPersistentClass().getSimpleName(), keyClass, persistentClass).unwrap(ICache.class);
            this.populateLocalCacheEntrySet(this.cache);
        }
        this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration(JCacheCacheFactoryBuilder.factoryOfEntryListener(new JCacheCacheEntryListener(this.cacheEntryList)), null, true, true));
        LOG.info("JCache Gora datastore initialized successfully.");
    }

    public String getSchemaName() {
        return this.persistentClass.getSimpleName();
    }

    public void createSchema() {
        if (this.manager.getCache(super.getPersistentClass().getSimpleName(), this.keyClass, this.persistentClass) == null) {
            this.cacheEntryList.clear();
            this.cache = (ICache)this.manager.createCache(this.persistentClass.getSimpleName(), this.cacheConfig).unwrap(ICache.class);
        }
        this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration(JCacheCacheFactoryBuilder.factoryOfEntryListener(new JCacheCacheEntryListener(this.cacheEntryList)), null, true, true));
        this.persistentDataStore.createSchema();
        LOG.info("Created schema on persistent store and initialized cache for persistent bean {}.", (Object)super.getPersistentClass().getSimpleName());
    }

    public void deleteSchema() {
        this.cache.removeAll();
        this.manager.destroyCache(super.getPersistentClass().getSimpleName());
        this.persistentDataStore.deleteSchema();
        LOG.info("Deleted schema on persistent store and destroyed cache for persistent bean {}.", (Object)super.getPersistentClass().getSimpleName());
    }

    public boolean schemaExists() {
        return this.manager.getCache(super.getPersistentClass().getSimpleName(), this.keyClass, this.persistentClass) != null;
    }

    public T get(K key, String[] fields) {
        PersistentBase persitent = (PersistentBase)this.cache.get(key);
        if (persitent == null) {
            return null;
        }
        return (T)JCacheStore.getPersistent(persitent, fields);
    }

    public T get(K key) {
        return (T)((PersistentBase)this.cache.get(key));
    }

    public void put(K key, T val) {
        this.cache.put(key, val);
    }

    public boolean delete(K key) {
        return this.cache.remove(key);
    }

    public long deleteByQuery(Query<K, T> query) {
        try {
            long deletedRows = 0L;
            Result result = query.execute();
            Object[] fields = this.getFieldsToQuery(query.getFields());
            boolean isAllFields = Arrays.equals(fields, this.getFields());
            while (result.next()) {
                if (isAllFields) {
                    if (!this.delete(result.getKey())) continue;
                    ++deletedRows;
                    continue;
                }
                ArrayList<String> excludedFields = new ArrayList<String>();
                for (String field : this.getFields()) {
                    if (Arrays.asList(fields).contains(field)) continue;
                    excludedFields.add(field);
                }
                PersistentBase newClonedObj = JCacheStore.getPersistent((PersistentBase)result.get(), excludedFields.toArray(new String[excludedFields.size()]));
                if (!this.delete(result.getKey())) continue;
                this.put(result.getKey(), newClonedObj);
                ++deletedRows;
            }
            LOG.info("JCache Gora datastore deleled {} rows from Persistent datastore.", (Object)deletedRows);
            return deletedRows;
        }
        catch (Exception e) {
            LOG.error("Exception occurred while deleting entries from JCache Gora datastore. Hence returning 0.", (Throwable)e);
            return 0L;
        }
    }

    public Result<K, T> execute(Query<K, T> query) {
        Object startKey = query.getStartKey();
        Object endKey = query.getEndKey();
        if (startKey == null && !this.cacheEntryList.isEmpty()) {
            startKey = this.cacheEntryList.first();
        }
        if (endKey == null && !this.cacheEntryList.isEmpty()) {
            endKey = this.cacheEntryList.last();
        }
        query.setFields(this.getFieldsToQuery(query.getFields()));
        ConcurrentSkipListSet cacheEntrySubList = null;
        try {
            cacheEntrySubList = (ConcurrentSkipListSet)this.cacheEntryList.subSet(startKey, true, endKey, true);
        }
        catch (NullPointerException npe) {
            LOG.error("NPE occurred while executing the query for JCacheStore. Hence returning empty entry set.", (Throwable)npe);
            return new JCacheResult<K, T>(this, query, new ConcurrentSkipListSet());
        }
        return new JCacheResult<K, T>(this, query, cacheEntrySubList);
    }

    public Query<K, T> newQuery() {
        return new JCacheQuery(this);
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        ArrayList<PartitionQuery<K, T>> partitions = new ArrayList<PartitionQuery<K, T>>();
        try {
            Member[] clusterMembers = new Member[this.hazelcastInstance.getCluster().getMembers().size()];
            this.hazelcastInstance.getCluster().getMembers().toArray(clusterMembers);
            for (Member member : clusterMembers) {
                JCacheResult result = (JCacheResult)query.execute();
                ConcurrentSkipListSet<Object> memberOwnedCacheEntries = new ConcurrentSkipListSet<Object>();
                while (result.next()) {
                    Object key = result.getKey();
                    Partition partition = this.hazelcastInstance.getPartitionService().getPartition(key);
                    if (!partition.getOwner().getUuid().equals(member.getUuid())) continue;
                    memberOwnedCacheEntries.add(key);
                }
                PartitionQueryImpl partition = new PartitionQueryImpl(query, memberOwnedCacheEntries.first(), memberOwnedCacheEntries.last(), new String[]{member.getSocketAddress().getHostString()});
                partition.setConf(this.getConf());
                partitions.add((PartitionQuery<K, T>)partition);
            }
        }
        catch (Exception ex) {
            LOG.error("Exception occurred while partitioning the query based on Hazelcast partitions.", (Throwable)ex);
            return null;
        }
        LOG.info("Query is partitioned to {} number of partitions.", (Object)partitions.size());
        return partitions;
    }

    public void flush() {
        this.persistentDataStore.flush();
        LOG.info("JCache Gora datastore flushed successfully.");
    }

    public void close() {
        this.flush();
        this.cacheEntryList.clear();
        if (!this.cache.isDestroyed() && !this.manager.isClosed()) {
            this.cache.close();
        }
        if (!this.manager.isClosed()) {
            this.manager.close();
        }
        this.hazelcastInstance.shutdown();
        this.persistentDataStore.close();
        LOG.info("JCache Gora datastore destroyed successfully.");
    }

    private void populateLocalCacheEntrySet(ICache<K, T> cache) {
        this.cacheEntryList = new ConcurrentSkipListSet();
        Iterator cacheEntryIterator = cache.iterator();
        while (cacheEntryIterator.hasNext()) {
            this.cacheEntryList.add(((Cache.Entry)cacheEntryIterator.next()).getKey());
        }
        this.cacheConfig = (CacheConfig)cache.getConfiguration(CacheConfig.class);
        LOG.info("Populated local cache entry set with respect to remote cache provider.");
    }
}

