/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.jcache.store;

import java.util.Collection;
import java.util.Iterator;
import javax.cache.Cache;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheCacheWriter<K, T extends PersistentBase>
implements CacheWriter<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheCacheWriter.class);
    private DataStore<K, T> dataStore;

    public JCacheCacheWriter(DataStore<K, T> dataStore) {
        this.dataStore = dataStore;
    }

    public void write(Cache.Entry<? extends K, ? extends T> entry) throws CacheWriterException {
        this.dataStore.put(entry.getKey(), (Persistent)entry.getValue());
        LOG.info("Written data bean to persistent datastore on key {}.", (Object)entry.getKey().toString());
    }

    public void writeAll(Collection<Cache.Entry<? extends K, ? extends T>> entries) throws CacheWriterException {
        Iterator<Cache.Entry<K, T>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            this.write(iterator.next());
            iterator.remove();
        }
    }

    public void delete(Object key) throws CacheWriterException {
        this.dataStore.delete(key);
        LOG.info("Deleted data bean from persistent datastore on key {}.", (Object)key.toString());
    }

    public void deleteAll(Collection<?> keys) throws CacheWriterException {
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            this.delete(iterator.next());
            iterator.remove();
        }
    }
}

