/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.jcache.store;

import java.util.HashMap;
import java.util.Map;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheCacheLoader<K, T extends PersistentBase>
implements CacheLoader<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheCacheLoader.class);
    private DataStore<K, T> dataStore;

    public JCacheCacheLoader(DataStore<K, T> dataStore) {
        this.dataStore = dataStore;
    }

    public T load(K key) throws CacheLoaderException {
        PersistentBase persistent = null;
        persistent = (PersistentBase)this.dataStore.get(key);
        LOG.info("Loaded data bean from persistent datastore on key {}.", (Object)key.toString());
        return (T)persistent;
    }

    public Map<K, T> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        HashMap<K, PersistentBase> loaded = new HashMap<K, PersistentBase>();
        for (K key : keys) {
            PersistentBase persistent = (PersistentBase)this.dataStore.get(key);
            LOG.info("Loaded data bean from persistent datastore on key {}.", (Object)key.toString());
            if (persistent == null) continue;
            loaded.put(key, persistent);
        }
        return loaded;
    }
}

