/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.jcache.store;

import java.util.concurrent.ConcurrentSkipListSet;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.gora.persistency.impl.PersistentBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheCacheEntryListener<K, T extends PersistentBase>
implements CacheEntryCreatedListener<K, T>,
CacheEntryRemovedListener<K, T>,
CacheEntryUpdatedListener<K, T>,
CacheEntryExpiredListener<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheCacheEntryListener.class);
    private ConcurrentSkipListSet<K> cacheEntryList;

    public JCacheCacheEntryListener(ConcurrentSkipListSet cacheEntryList) {
        this.cacheEntryList = cacheEntryList;
    }

    public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends T>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, T> cacheEntryEvent : cacheEntryEvents) {
            this.cacheEntryList.add(cacheEntryEvent.getKey());
            LOG.info("Cache entry added on key {}.", (Object)cacheEntryEvent.getKey().toString());
        }
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends T>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, T> cacheEntryEvent : cacheEntryEvents) {
            this.cacheEntryList.remove(cacheEntryEvent.getKey());
            LOG.info("Cache entry removed on key {}.", (Object)cacheEntryEvent.getKey().toString());
        }
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends T>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, T> cacheEntryEvent : cacheEntryEvents) {
            LOG.info("Cache entry updated set on key {}.", (Object)cacheEntryEvent.getKey().toString());
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends T>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, T> cacheEntryEvent : cacheEntryEvents) {
            LOG.warn("Cache entry expired on key {}.", (Object)cacheEntryEvent.getKey().toString());
        }
    }
}

