/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.jcache.query;

import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableSet;
import org.apache.gora.jcache.store.JCacheStore;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheResult<K, T extends PersistentBase>
extends ResultBase<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheResult.class);
    private NavigableSet<K> cacheKeySet;
    private Iterator<K> iterator;
    private int current;

    public JCacheResult(DataStore<K, T> dataStore, Query<K, T> query) {
        super(dataStore, query);
    }

    public JCacheResult(DataStore<K, T> dataStore, Query<K, T> query, NavigableSet<K> cacheKeySet) {
        super(dataStore, query);
        this.cacheKeySet = cacheKeySet;
        this.iterator = cacheKeySet.iterator();
        this.current = 0;
    }

    public JCacheStore<K, T> getDataStore() {
        return (JCacheStore)super.getDataStore();
    }

    public float getProgress() throws IOException {
        if (this.cacheKeySet.size() == 0) {
            return 1.0f;
        }
        float progress = (float)this.current / (float)this.cacheKeySet.size();
        return progress;
    }

    public void close() throws IOException {
    }

    protected boolean nextInner() throws IOException {
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.key = this.iterator.next();
        LOG.info("Results set pointer is now moved to key {}.", this.key);
        this.persistent = this.dataStore.get(this.key);
        ++this.current;
        return true;
    }
}

