/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Pair;

public class HBaseTableConnection {
    private final Configuration conf;
    private final Connection connection;
    private final RegionLocator regionLocator;
    private final ThreadLocal<ConcurrentLinkedQueue<Mutation>> buffers;
    private final ThreadLocal<Table> tables;
    private final BlockingQueue<Table> tPool = new LinkedBlockingQueue<Table>();
    private final BlockingQueue<ConcurrentLinkedQueue<Mutation>> bPool = new LinkedBlockingQueue<ConcurrentLinkedQueue<Mutation>>();
    private final boolean autoFlush;
    private final TableName tableName;

    public HBaseTableConnection(Configuration conf, String tableName, boolean autoflush) throws IOException {
        this.conf = conf;
        this.tables = new ThreadLocal();
        this.buffers = new ThreadLocal();
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.tableName = TableName.valueOf((String)tableName);
        this.regionLocator = this.connection.getRegionLocator(this.tableName);
        this.autoFlush = autoflush;
    }

    private Table getTable() throws IOException {
        Table table = this.tables.get();
        if (table == null) {
            table = this.connection.getTable(this.tableName);
            this.tPool.add(table);
            this.tables.set(table);
        }
        return table;
    }

    private ConcurrentLinkedQueue<Mutation> getBuffer() throws IOException {
        ConcurrentLinkedQueue<Object> buffer = this.buffers.get();
        if (buffer == null) {
            buffer = new ConcurrentLinkedQueue();
            this.bPool.add(buffer);
            this.buffers.set(buffer);
        }
        return buffer;
    }

    public void flushCommits() throws IOException {
        BufferedMutator bufMutator = this.connection.getBufferedMutator(this.tableName);
        for (ConcurrentLinkedQueue concurrentLinkedQueue : this.bPool) {
            while (!concurrentLinkedQueue.isEmpty()) {
                Mutation m = (Mutation)concurrentLinkedQueue.poll();
                bufMutator.mutate(m);
            }
        }
        bufMutator.flush();
        bufMutator.close();
    }

    public void close() throws IOException {
        this.flushCommits();
        for (Table table : this.tPool) {
            table.close();
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.regionLocator.getStartEndKeys();
    }

    public HRegionLocation getRegionLocation(byte[] bs) throws IOException {
        return this.regionLocator.getRegionLocation(bs);
    }

    public boolean exists(Get get) throws IOException {
        return this.getTable().exists(get);
    }

    public boolean[] existsAll(List<Get> list) throws IOException {
        return this.getTable().existsAll(list);
    }

    public Result get(Get get) throws IOException {
        return this.getTable().get(get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        return this.getTable().get(gets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.getTable().getScanner(scan);
    }

    public void put(Put put) throws IOException {
        this.getBuffer().add((Mutation)put);
    }

    public void put(List<Put> puts) throws IOException {
        this.getBuffer().addAll(puts);
    }

    public void delete(Delete delete) throws IOException {
        this.getBuffer().add((Mutation)delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.getBuffer().addAll(deletes);
    }

    public TableName getName() {
        return this.tableName;
    }
}

