/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.apache.gora.hbase.query.HBaseGetResult;
import org.apache.gora.hbase.query.HBaseQuery;
import org.apache.gora.hbase.query.HBaseScannerResult;
import org.apache.gora.hbase.store.HBaseColumn;
import org.apache.gora.hbase.store.HBaseMapping;
import org.apache.gora.hbase.store.HBaseTableConnection;
import org.apache.gora.hbase.util.HBaseByteInterface;
import org.apache.gora.hbase.util.HBaseFilterUtil;
import org.apache.gora.persistency.impl.DirtyListWrapper;
import org.apache.gora.persistency.impl.DirtyMapWrapper;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HBaseStore<K, T extends PersistentBase>
extends DataStoreBase<K, T>
implements Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(HBaseStore.class);
    public static final String PARSE_MAPPING_FILE_KEY = "gora.hbase.mapping.file";
    @Deprecated
    private static final String DEPRECATED_MAPPING_FILE = "hbase-mapping.xml";
    public static final String DEFAULT_MAPPING_FILE = "gora-hbase-mapping.xml";
    private static final String SCANNER_CACHING_PROPERTIES_KEY = "scanner.caching";
    private static final int SCANNER_CACHING_PROPERTIES_DEFAULT = 0;
    private volatile HBaseAdmin admin;
    private volatile HBaseTableConnection table;
    private final boolean autoCreateSchema = true;
    private volatile HBaseMapping mapping;
    private HBaseFilterUtil<K, T> filterUtil;
    private int scannerCaching = 0;

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        try {
            super.initialize(keyClass, persistentClass, properties);
            this.conf = HBaseConfiguration.create((Configuration)this.getConf());
            this.admin = new HBaseAdmin(this.conf);
            this.mapping = this.readMapping(this.getConf().get(PARSE_MAPPING_FILE_KEY, DEFAULT_MAPPING_FILE));
            this.filterUtil = new HBaseFilterUtil(this.conf);
        }
        catch (FileNotFoundException ex) {
            try {
                this.mapping = this.readMapping(this.getConf().get(PARSE_MAPPING_FILE_KEY, DEPRECATED_MAPPING_FILE));
                LOG.warn("hbase-mapping.xml is deprecated, please rename the file to gora-hbase-mapping.xml");
            }
            catch (FileNotFoundException ex1) {
                LOG.error(ex1.getMessage());
                LOG.error(ex1.getStackTrace().toString());
            }
            catch (Exception ex1) {
                LOG.warn("hbase-mapping.xml is deprecated, please rename the file to gora-hbase-mapping.xml");
                throw new RuntimeException(ex1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.setScannerCaching(Integer.valueOf(DataStoreFactory.findProperty((Properties)this.properties, (DataStore)this, (String)SCANNER_CACHING_PROPERTIES_KEY, (String)String.valueOf(0))));
        }
        catch (Exception e) {
            LOG.error("Can not load scanner.caching from gora.properties. Setting to default value: 0", (Throwable)e);
            this.setScannerCaching(0);
        }
        this.createSchema();
        try {
            boolean autoflush = this.conf.getBoolean("hbase.client.autoflush.default", false);
            this.table = new HBaseTableConnection(this.getConf(), this.getSchemaName(), autoflush);
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
        }
    }

    public String getSchemaName() {
        return this.mapping.getTableName();
    }

    public HBaseMapping getMapping() {
        return this.mapping;
    }

    public void createSchema() {
        try {
            if (this.schemaExists()) {
                return;
            }
            HTableDescriptor tableDesc = this.mapping.getTable();
            this.admin.createTable(tableDesc);
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
        }
    }

    public void deleteSchema() {
        try {
            if (!this.schemaExists()) {
                return;
            }
            this.admin.disableTable(this.getSchemaName());
            this.admin.deleteTable(this.getSchemaName());
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
        }
    }

    public boolean schemaExists() {
        try {
            return this.admin.tableExists(this.mapping.getTableName());
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
            return false;
        }
    }

    public T get(K key, String[] fields) {
        try {
            fields = this.getFieldsToQuery(fields);
            Get get = new Get(HBaseByteInterface.toBytes(key));
            this.addFields(get, fields);
            org.apache.hadoop.hbase.client.Result result = this.table.get(get);
            return this.newInstance(result, fields);
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
            return null;
        }
    }

    public void put(K key, T persistent) {
        try {
            Schema schema = persistent.getSchema();
            byte[] keyRaw = HBaseByteInterface.toBytes(key);
            Put put = new Put(keyRaw);
            Delete delete = new Delete(keyRaw);
            List fields = schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                if (!persistent.isDirty(i)) continue;
                Schema.Field field = (Schema.Field)fields.get(i);
                Object o = persistent.get(i);
                HBaseColumn hcol = this.mapping.getColumn(field.name());
                if (hcol == null) {
                    throw new RuntimeException("HBase mapping for field [" + persistent.getClass().getName() + "#" + field.name() + "] not found. Wrong gora-hbase-mapping.xml?");
                }
                this.addPutsAndDeletes(put, delete, o, field.schema().getType(), field.schema(), hcol, hcol.getQualifier());
            }
            if (put.size() > 0) {
                this.table.put(put);
            }
            if (delete.size() > 0) {
                this.table.delete(delete);
                this.table.delete(delete);
                this.table.delete(delete);
            }
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
        }
    }

    private void addPutsAndDeletes(Put put, Delete delete, Object o, Schema.Type type, Schema schema, HBaseColumn hcol, byte[] qualifier) throws IOException {
        switch (type) {
            case UNION: {
                if (this.isNullable(schema) && o == null) {
                    if (qualifier == null) {
                        delete.deleteFamily(hcol.getFamily());
                        break;
                    }
                    delete.deleteColumn(hcol.getFamily(), qualifier);
                    break;
                }
                int index = this.getResolvedUnionIndex(schema);
                if (index > 1) {
                    byte[] serializedBytes = HBaseByteInterface.toBytes(o, schema);
                    put.add(hcol.getFamily(), qualifier, serializedBytes);
                    break;
                }
                Schema resolvedSchema = (Schema)schema.getTypes().get(index);
                this.addPutsAndDeletes(put, delete, o, resolvedSchema.getType(), resolvedSchema, hcol, qualifier);
                break;
            }
            case MAP: {
                if (qualifier == null) {
                    delete.deleteFamily(hcol.getFamily());
                } else {
                    delete.deleteColumn(hcol.getFamily(), qualifier);
                }
                Set set = ((Map)o).entrySet();
                for (Map.Entry entry : set) {
                    byte[] qual = HBaseByteInterface.toBytes(entry.getKey());
                    this.addPutsAndDeletes(put, delete, entry.getValue(), schema.getValueType().getType(), schema.getValueType(), hcol, qual);
                }
                break;
            }
            case ARRAY: {
                List array = (List)o;
                int j = 0;
                for (Object item : array) {
                    this.addPutsAndDeletes(put, delete, item, schema.getElementType().getType(), schema.getElementType(), hcol, Bytes.toBytes((int)j++));
                }
                break;
            }
            default: {
                byte[] serializedBytes = HBaseByteInterface.toBytes(o, schema);
                put.add(hcol.getFamily(), qualifier, serializedBytes);
            }
        }
    }

    private boolean isNullable(Schema unionSchema) {
        for (Schema innerSchema : unionSchema.getTypes()) {
            if (!innerSchema.getType().equals((Object)Schema.Type.NULL)) continue;
            return true;
        }
        return false;
    }

    public void delete(T obj) {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean delete(K key) {
        try {
            this.table.delete(new Delete(HBaseByteInterface.toBytes(key)));
            return true;
        }
        catch (IOException ex2) {
            LOG.error(ex2.getMessage());
            LOG.error(ex2.getStackTrace().toString());
            return false;
        }
    }

    public long deleteByQuery(Query<K, T> query) {
        try {
            Object[] fields = this.getFieldsToQuery(query.getFields());
            boolean isAllFields = Arrays.equals(fields, this.getFields());
            Result result = null;
            result = query.execute();
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            while (result.next()) {
                Delete delete = new Delete(HBaseByteInterface.toBytes(result.getKey()));
                deletes.add(delete);
                if (isAllFields) continue;
                this.addFields(delete, query);
            }
            this.table.delete(deletes);
            return deletes.size();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            return -1L;
        }
    }

    public void flush() {
        try {
            this.table.flushCommits();
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
        }
    }

    public Query<K, T> newQuery() {
        return new HBaseQuery(this);
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        Pair<byte[][], byte[][]> keys = this.table.getStartEndKeys();
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            throw new IOException("Expecting at least one region.");
        }
        if (this.table == null) {
            throw new IOException("No table was provided.");
        }
        ArrayList<PartitionQuery<K, T>> partitions = new ArrayList<PartitionQuery<K, T>>(((byte[][])keys.getFirst()).length);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            byte[] stopRow;
            String regionLocation = this.table.getRegionLocation(((byte[][])keys.getFirst())[i]).getServerAddress().getHostname();
            byte[] startRow = query.getStartKey() != null ? HBaseByteInterface.toBytes(query.getStartKey()) : HConstants.EMPTY_START_ROW;
            byte[] byArray = stopRow = query.getEndKey() != null ? HBaseByteInterface.toBytes(query.getEndKey()) : HConstants.EMPTY_END_ROW;
            if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
            Object startKey = Arrays.equals(HConstants.EMPTY_START_ROW, splitStart) ? null : HBaseByteInterface.fromBytes(this.keyClass, splitStart);
            Object endKey = Arrays.equals(HConstants.EMPTY_END_ROW, splitStop) ? null : HBaseByteInterface.fromBytes(this.keyClass, splitStop);
            PartitionQueryImpl partition = new PartitionQueryImpl(query, startKey, endKey, new String[]{regionLocation});
            partition.setConf(this.getConf());
            partitions.add((PartitionQuery<K, T>)partition);
        }
        return partitions;
    }

    public Result<K, T> execute(Query<K, T> query) {
        try {
            query.setFields(this.getFieldsToQuery(query.getFields()));
            if (query.getStartKey() != null && query.getStartKey().equals(query.getEndKey())) {
                Get get = new Get(HBaseByteInterface.toBytes(query.getStartKey()));
                this.addFields(get, query.getFields());
                this.addTimeRange(get, query);
                org.apache.hadoop.hbase.client.Result result = this.table.get(get);
                return new HBaseGetResult<K, T>(this, query, result);
            }
            ResultScanner scanner = this.createScanner(query);
            HBaseScannerResult<K, T> result = new HBaseScannerResult<K, T>(this, query, scanner);
            return result;
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            return null;
        }
    }

    public ResultScanner createScanner(Query<K, T> query) throws IOException {
        boolean succeeded;
        Scan scan = new Scan();
        scan.setCaching(this.getScannerCaching());
        if (query.getStartKey() != null) {
            scan.setStartRow(HBaseByteInterface.toBytes(query.getStartKey()));
        }
        if (query.getEndKey() != null) {
            scan.setStopRow(HBaseByteInterface.toBytes(query.getEndKey()));
        }
        this.addFields(scan, query);
        if (query.getFilter() != null && (succeeded = this.filterUtil.setFilter(scan, query.getFilter(), this))) {
            query.setLocalFilterEnabled(false);
        }
        return this.table.getScanner(scan);
    }

    private void addFields(Get get, String[] fieldNames) {
        for (String f : fieldNames) {
            HBaseColumn col = this.mapping.getColumn(f);
            if (col == null) {
                throw new RuntimeException("HBase mapping for field [" + f + "] not found. " + "Wrong gora-hbase-mapping.xml?");
            }
            Schema fieldSchema = ((Schema.Field)this.fieldMap.get(f)).schema();
            this.addFamilyOrColumn(get, col, fieldSchema);
        }
    }

    private void addFamilyOrColumn(Get get, HBaseColumn col, Schema fieldSchema) {
        switch (fieldSchema.getType()) {
            case UNION: {
                int index = this.getResolvedUnionIndex(fieldSchema);
                Schema resolvedSchema = (Schema)fieldSchema.getTypes().get(index);
                this.addFamilyOrColumn(get, col, resolvedSchema);
                break;
            }
            case MAP: 
            case ARRAY: {
                get.addFamily(col.family);
                break;
            }
            default: {
                get.addColumn(col.family, col.qualifier);
            }
        }
    }

    private void addFields(Scan scan, Query<K, T> query) throws IOException {
        String[] fields;
        for (String f : fields = query.getFields()) {
            HBaseColumn col = this.mapping.getColumn(f);
            if (col == null) {
                throw new RuntimeException("HBase mapping for field [" + f + "] not found. " + "Wrong gora-hbase-mapping.xml?");
            }
            Schema fieldSchema = ((Schema.Field)this.fieldMap.get(f)).schema();
            this.addFamilyOrColumn(scan, col, fieldSchema);
        }
    }

    private void addFamilyOrColumn(Scan scan, HBaseColumn col, Schema fieldSchema) {
        switch (fieldSchema.getType()) {
            case UNION: {
                int index = this.getResolvedUnionIndex(fieldSchema);
                Schema resolvedSchema = (Schema)fieldSchema.getTypes().get(index);
                this.addFamilyOrColumn(scan, col, resolvedSchema);
                break;
            }
            case MAP: 
            case ARRAY: {
                scan.addFamily(col.family);
                break;
            }
            default: {
                scan.addColumn(col.family, col.qualifier);
            }
        }
    }

    private void addFields(Delete delete, Query<K, T> query) throws IOException {
        String[] fields;
        for (String f : fields = query.getFields()) {
            HBaseColumn col = this.mapping.getColumn(f);
            if (col == null) {
                throw new RuntimeException("HBase mapping for field [" + f + "] not found. " + "Wrong gora-hbase-mapping.xml?");
            }
            Schema fieldSchema = ((Schema.Field)this.fieldMap.get(f)).schema();
            this.addFamilyOrColumn(delete, col, fieldSchema);
        }
    }

    private void addFamilyOrColumn(Delete delete, HBaseColumn col, Schema fieldSchema) {
        switch (fieldSchema.getType()) {
            case UNION: {
                int index = this.getResolvedUnionIndex(fieldSchema);
                Schema resolvedSchema = (Schema)fieldSchema.getTypes().get(index);
                this.addFamilyOrColumn(delete, col, resolvedSchema);
                break;
            }
            case MAP: 
            case ARRAY: {
                delete.deleteFamily(col.family);
                break;
            }
            default: {
                delete.deleteColumn(col.family, col.qualifier);
            }
        }
    }

    private void addTimeRange(Get get, Query<K, T> query) throws IOException {
        if (query.getStartTime() > 0L || query.getEndTime() > 0L) {
            if (query.getStartTime() == query.getEndTime()) {
                get.setTimeStamp(query.getStartTime());
            } else {
                long startTime = query.getStartTime() > 0L ? query.getStartTime() : 0L;
                long endTime = query.getEndTime() > 0L ? query.getEndTime() : Long.MAX_VALUE;
                get.setTimeRange(startTime, endTime);
            }
        }
    }

    public T newInstance(org.apache.hadoop.hbase.client.Result result, String[] fields) throws IOException {
        if (result == null || result.isEmpty()) {
            return null;
        }
        PersistentBase persistent = this.newPersistent();
        for (String f : fields) {
            HBaseColumn col = this.mapping.getColumn(f);
            if (col == null) {
                throw new RuntimeException("HBase mapping for field [" + f + "] not found. " + "Wrong gora-hbase-mapping.xml?");
            }
            Schema.Field field = (Schema.Field)this.fieldMap.get(f);
            Schema fieldSchema = field.schema();
            this.setField(result, persistent, col, field, fieldSchema);
        }
        persistent.clearDirty();
        return (T)persistent;
    }

    private void setField(org.apache.hadoop.hbase.client.Result result, T persistent, HBaseColumn col, Schema.Field field, Schema fieldSchema) throws IOException {
        switch (fieldSchema.getType()) {
            case UNION: {
                int index = this.getResolvedUnionIndex(fieldSchema);
                if (index > 1) {
                    byte[] val = result.getValue(col.getFamily(), col.getQualifier());
                    if (val == null) {
                        return;
                    }
                    this.setField(persistent, field, val);
                    break;
                }
                Schema resolvedSchema = (Schema)fieldSchema.getTypes().get(index);
                this.setField(result, persistent, col, field, resolvedSchema);
                break;
            }
            case MAP: {
                NavigableMap qualMap = (NavigableMap)result.getNoVersionMap().get(col.getFamily());
                if (qualMap == null) {
                    return;
                }
                Schema valueSchema = fieldSchema.getValueType();
                HashMap<Utf8, Object> map = new HashMap<Utf8, Object>();
                for (Map.Entry e : qualMap.entrySet()) {
                    map.put(new Utf8(Bytes.toString((byte[])((byte[])e.getKey()))), HBaseByteInterface.fromBytes(valueSchema, (byte[])e.getValue()));
                }
                this.setField(persistent, field, map);
                break;
            }
            case ARRAY: {
                NavigableMap qualMap = result.getFamilyMap(col.getFamily());
                if (qualMap == null) {
                    return;
                }
                Schema valueSchema = fieldSchema.getElementType();
                ArrayList arrayList = new ArrayList();
                DirtyListWrapper dirtyListWrapper = new DirtyListWrapper(arrayList);
                for (Map.Entry e : qualMap.entrySet()) {
                    dirtyListWrapper.add(HBaseByteInterface.fromBytes(valueSchema, (byte[])e.getValue()));
                }
                this.setField(persistent, field, arrayList);
                break;
            }
            default: {
                byte[] val = result.getValue(col.getFamily(), col.getQualifier());
                if (val == null) {
                    return;
                }
                this.setField(persistent, field, val);
            }
        }
    }

    private int getResolvedUnionIndex(Schema unionScema) {
        Schema.Type type1;
        Schema.Type type0;
        if (unionScema.getTypes().size() == 2 && !(type0 = ((Schema)unionScema.getTypes().get(0)).getType()).equals((Object)(type1 = ((Schema)unionScema.getTypes().get(1)).getType())) && (type0.equals((Object)Schema.Type.NULL) || type1.equals((Object)Schema.Type.NULL))) {
            if (type0.equals((Object)Schema.Type.NULL)) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    private void setField(T persistent, Schema.Field field, Map map) {
        persistent.put(field.pos(), (Object)new DirtyMapWrapper(map));
    }

    private void setField(T persistent, Schema.Field field, byte[] val) throws IOException {
        persistent.put(field.pos(), HBaseByteInterface.fromBytes(field.schema(), val));
    }

    private void setField(T persistent, Schema.Field field, List list) {
        persistent.put(field.pos(), (Object)new DirtyListWrapper(list));
    }

    private HBaseMapping readMapping(String filename) throws IOException {
        HBaseMapping.HBaseMappingBuilder mappingBuilder = new HBaseMapping.HBaseMappingBuilder();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename));
            Element root = doc.getRootElement();
            List tableElements = root.getChildren("table");
            for (Element tableElement : tableElements) {
                String tableName = tableElement.getAttributeValue("name");
                List fieldElements = tableElement.getChildren("family");
                for (Element fieldElement : fieldElements) {
                    String familyName = fieldElement.getAttributeValue("name");
                    String compression = fieldElement.getAttributeValue("compression");
                    String blockCache = fieldElement.getAttributeValue("blockCache");
                    String blockSize = fieldElement.getAttributeValue("blockSize");
                    String bloomFilter = fieldElement.getAttributeValue("bloomFilter");
                    String maxVersions = fieldElement.getAttributeValue("maxVersions");
                    String timeToLive = fieldElement.getAttributeValue("timeToLive");
                    String inMemory = fieldElement.getAttributeValue("inMemory");
                    mappingBuilder.addFamilyProps(tableName, familyName, compression, blockCache, blockSize, bloomFilter, maxVersions, timeToLive, inMemory);
                }
            }
            List classElements = root.getChildren("class");
            for (Element classElement : classElements) {
                if (classElement.getAttributeValue("keyClass").equals(this.keyClass.getCanonicalName()) && classElement.getAttributeValue("name").equals(this.persistentClass.getCanonicalName())) {
                    LOG.debug("Keyclass and nameclass match.");
                    String tableNameFromMapping = classElement.getAttributeValue("table");
                    String tableName = this.getSchemaName(tableNameFromMapping, this.persistentClass);
                    if (!tableName.equals(tableNameFromMapping)) {
                        LOG.warn("Mismatching schema's names. Mappingfile schema: '" + tableNameFromMapping + "'. PersistentClass schema's name: '" + tableName + "'" + "Assuming they are the same.");
                        if (tableNameFromMapping != null) {
                            mappingBuilder.renameTable(tableNameFromMapping, tableName);
                        }
                    }
                    mappingBuilder.setTableName(tableName);
                    List fields = classElement.getChildren("field");
                    for (Element field : fields) {
                        String fieldName = field.getAttributeValue("name");
                        String family = field.getAttributeValue("family");
                        String qualifier = field.getAttributeValue("qualifier");
                        mappingBuilder.addField(fieldName, family, qualifier);
                        mappingBuilder.addColumnFamily(tableName, family);
                    }
                    break;
                }
                LOG.error("KeyClass in gora-hbase-mapping is not the same as the one in the databean.");
            }
        }
        catch (MalformedURLException ex) {
            LOG.error("Error while trying to read the mapping file {}. Expected to be in the classpath (ClassLoader#getResource(java.lang.String)).", (Object)filename);
            LOG.error("Actual classpath = {}", Arrays.asList(((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs()));
            throw ex;
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            throw ex;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            throw new IOException(ex);
        }
        return mappingBuilder.build();
    }

    public void close() {
        try {
            this.table.close();
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public HBaseStore<K, T> setScannerCaching(int numRows) {
        if (numRows < 0) {
            LOG.warn("Invalid Scanner Caching optimization value. Cannot set to: " + numRows + ".");
            return this;
        }
        this.scannerCaching = numRows;
        return this;
    }
}

