/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.filter.Filter;
import org.apache.gora.hbase.store.HBaseStore;
import org.apache.gora.hbase.util.FilterFactory;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;

public class HBaseFilterUtil<K, T extends PersistentBase> {
    private static final Log LOG = LogFactory.getLog(HBaseFilterUtil.class);
    private Map<String, FilterFactory<K, T>> factories = new LinkedHashMap<String, FilterFactory<K, T>>();

    public HBaseFilterUtil(Configuration conf) throws GoraException {
        String[] factoryClassNames;
        for (String factoryClass : factoryClassNames = conf.getStrings("gora.hbase.filter.factories", new String[]{"org.apache.gora.hbase.util.DefaultFactory"})) {
            try {
                FilterFactory factory = (FilterFactory)ReflectionUtils.newInstance((String)factoryClass);
                for (String filterClass : factory.getSupportedFilters()) {
                    this.factories.put(filterClass, factory);
                }
                factory.setHBaseFitlerUtil(this);
            }
            catch (Exception e) {
                throw new GoraException((Throwable)e);
            }
        }
    }

    public FilterFactory<K, T> getFactory(Filter<K, T> fitler) {
        return this.factories.get(fitler.getClass().getCanonicalName());
    }

    public boolean setFilter(Scan scan, Filter<K, T> filter, HBaseStore<K, T> store) {
        FilterFactory<K, T> factory = this.getFactory(filter);
        if (factory != null) {
            org.apache.hadoop.hbase.filter.Filter hbaseFilter = factory.createFilter(filter, store);
            if (hbaseFilter != null) {
                scan.setFilter(hbaseFilter);
                return true;
            }
            LOG.warn((Object)("HBase remote filter not yet implemented for " + filter.getClass().getCanonicalName()));
            return false;
        }
        LOG.warn((Object)("HBase remote filter factory not yet implemented for " + filter.getClass().getCanonicalName()));
        return false;
    }
}

