/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.filter.Filter;
import org.apache.gora.filter.FilterList;
import org.apache.gora.filter.FilterOp;
import org.apache.gora.filter.MapFieldValueFilter;
import org.apache.gora.filter.SingleFieldValueFilter;
import org.apache.gora.hbase.store.HBaseColumn;
import org.apache.gora.hbase.store.HBaseStore;
import org.apache.gora.hbase.util.BaseFactory;
import org.apache.gora.hbase.util.FilterFactory;
import org.apache.gora.hbase.util.HBaseByteInterface;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;

public class DefaultFactory<K, T extends PersistentBase>
extends BaseFactory<K, T> {
    private static final Log LOG = LogFactory.getLog(DefaultFactory.class);

    @Override
    public List<String> getSupportedFilters() {
        ArrayList<String> filters = new ArrayList<String>();
        filters.add(SingleFieldValueFilter.class.getCanonicalName());
        filters.add(MapFieldValueFilter.class.getCanonicalName());
        filters.add(FilterList.class.getCanonicalName());
        return filters;
    }

    @Override
    public org.apache.hadoop.hbase.filter.Filter createFilter(Filter<K, T> filter, HBaseStore<K, T> store) {
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            org.apache.hadoop.hbase.filter.FilterList hbaseFilter = new org.apache.hadoop.hbase.filter.FilterList(FilterList.Operator.valueOf((String)filterList.getOperator().name()));
            for (Filter rowFitler : filterList.getFilters()) {
                FilterFactory<K, T> factory = this.getHbaseFitlerUtil().getFactory(rowFitler);
                if (factory == null) {
                    LOG.warn((Object)("HBase remote filter factory not yet implemented for " + rowFitler.getClass().getCanonicalName()));
                    return null;
                }
                org.apache.hadoop.hbase.filter.Filter hbaseRowFilter = factory.createFilter(rowFitler, store);
                if (hbaseRowFilter == null) continue;
                hbaseFilter.addFilter(hbaseRowFilter);
            }
            return hbaseFilter;
        }
        if (filter instanceof SingleFieldValueFilter) {
            SingleFieldValueFilter fieldFilter = (SingleFieldValueFilter)filter;
            HBaseColumn column = store.getMapping().getColumn(fieldFilter.getFieldName());
            CompareFilter.CompareOp compareOp = this.getCompareOp(fieldFilter.getFilterOp());
            byte[] family = column.getFamily();
            byte[] qualifier = column.getQualifier();
            byte[] value = HBaseByteInterface.toBytes(fieldFilter.getOperands().get(0));
            SingleColumnValueFilter hbaseFilter = new SingleColumnValueFilter(family, qualifier, compareOp, value);
            hbaseFilter.setFilterIfMissing(fieldFilter.isFilterIfMissing());
            return hbaseFilter;
        }
        if (filter instanceof MapFieldValueFilter) {
            MapFieldValueFilter mapFilter = (MapFieldValueFilter)filter;
            HBaseColumn column = store.getMapping().getColumn(mapFilter.getFieldName());
            CompareFilter.CompareOp compareOp = this.getCompareOp(mapFilter.getFilterOp());
            byte[] family = column.getFamily();
            byte[] qualifier = HBaseByteInterface.toBytes(mapFilter.getMapKey());
            byte[] value = HBaseByteInterface.toBytes(mapFilter.getOperands().get(0));
            SingleColumnValueFilter hbaseFilter = new SingleColumnValueFilter(family, qualifier, compareOp, value);
            hbaseFilter.setFilterIfMissing(mapFilter.isFilterIfMissing());
            return hbaseFilter;
        }
        LOG.warn((Object)("HBase remote filter not yet implemented for " + filter.getClass().getCanonicalName()));
        return null;
    }

    private CompareFilter.CompareOp getCompareOp(FilterOp filterOp) {
        switch (filterOp) {
            case EQUALS: {
                return CompareFilter.CompareOp.EQUAL;
            }
            case NOT_EQUALS: {
                return CompareFilter.CompareOp.NOT_EQUAL;
            }
            case LESS: {
                return CompareFilter.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case GREATER: {
                return CompareFilter.CompareOp.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException(filterOp + " no HBase equivalent yet");
    }
}

