/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class HBaseTableConnection
implements HTableInterface {
    private final Configuration conf;
    private final ThreadLocal<HTable> tables;
    private final BlockingQueue<HTable> pool = new LinkedBlockingQueue<HTable>();
    private final boolean autoflush;
    private final String tableName;

    public HBaseTableConnection(Configuration conf, String tableName, boolean autoflush) throws IOException {
        this.conf = conf;
        this.tables = new ThreadLocal();
        this.tableName = tableName;
        this.autoflush = autoflush;
    }

    private HTable getTable() throws IOException {
        HTable table = this.tables.get();
        if (table == null) {
            table = new HTable(this.conf, this.tableName){

                public synchronized void flushCommits() throws IOException {
                    super.flushCommits();
                }
            };
            table.setAutoFlush(this.autoflush);
            this.pool.add(table);
            this.tables.set(table);
        }
        return table;
    }

    public void close() throws IOException {
        for (HTable table : this.pool) {
            table.flushCommits();
            table.close();
        }
    }

    public byte[] getTableName() {
        return Bytes.toBytes((String)this.tableName);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public boolean isAutoFlush() {
        return this.autoflush;
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getTable().getStartEndKeys();
    }

    public HRegionLocation getRegionLocation(byte[] bs) throws IOException {
        return this.getTable().getRegionLocation(bs);
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.getTable().getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        return this.getTable().exists(get);
    }

    public void batch(List<Row> actions, Object[] results) throws IOException, InterruptedException {
        this.getTable().batch(actions, results);
    }

    public Object[] batch(List<Row> actions) throws IOException, InterruptedException {
        return this.getTable().batch(actions);
    }

    public Result get(Get get) throws IOException {
        return this.getTable().get(get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        return this.getTable().get(gets);
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        return this.getTable().getRowOrBefore(row, family);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.getTable().getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.getTable().getScanner(family);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.getTable().getScanner(family, qualifier);
    }

    public void put(Put put) throws IOException {
        this.getTable().put(put);
    }

    public void put(List<Put> puts) throws IOException {
        this.getTable().put(puts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.getTable().checkAndPut(row, family, qualifier, value, put);
    }

    public void delete(Delete delete) throws IOException {
        this.getTable().delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.getTable().delete(deletes);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.getTable().checkAndDelete(row, family, qualifier, value, delete);
    }

    public Result increment(Increment increment) throws IOException {
        return this.getTable().increment(increment);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.getTable().incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.getTable().incrementColumnValue(row, family, qualifier, amount, writeToWAL);
    }

    public void flushCommits() throws IOException {
        for (HTable table : this.pool) {
            table.flushCommits();
        }
    }

    public RowLock lockRow(byte[] row) throws IOException {
        return this.getTable().lockRow(row);
    }

    public void unlockRow(RowLock rl) throws IOException {
        this.getTable().unlockRow(rl);
    }
}

