/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.gora.hbase.store.HBaseColumn;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseMapping {
    private final HTableDescriptor tableDescriptor;
    private final Map<String, HBaseColumn> columnMap;

    public HBaseMapping(HTableDescriptor tableDescriptor, Map<String, HBaseColumn> columnMap) {
        this.tableDescriptor = tableDescriptor;
        this.columnMap = columnMap;
    }

    public String getTableName() {
        return this.tableDescriptor.getNameAsString();
    }

    public HTableDescriptor getTable() {
        return this.tableDescriptor;
    }

    public HBaseColumn getColumn(String fieldName) {
        return this.columnMap.get(fieldName);
    }

    public static class HBaseMappingBuilder {
        private Map<String, Map<String, HColumnDescriptor>> tableToFamilies = new HashMap<String, Map<String, HColumnDescriptor>>();
        private Map<String, HBaseColumn> columnMap = new HashMap<String, HBaseColumn>();
        private String tableName;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void addFamilyProps(String tableName, String familyName, String compression, String blockCache, String blockSize, String bloomFilter, String maxVersions, String timeToLive, String inMemory) {
            Map<String, HColumnDescriptor> families = this.getOrCreateFamilies(tableName);
            HColumnDescriptor columnDescriptor = this.getOrCreateFamily(familyName, families);
            if (compression != null) {
                columnDescriptor.setCompressionType(Compression.Algorithm.valueOf((String)compression));
            }
            if (blockCache != null) {
                columnDescriptor.setBlockCacheEnabled(Boolean.parseBoolean(blockCache));
            }
            if (blockSize != null) {
                columnDescriptor.setBlocksize(Integer.parseInt(blockSize));
            }
            if (bloomFilter != null) {
                columnDescriptor.setBloomFilterType(StoreFile.BloomType.valueOf((String)bloomFilter));
            }
            if (maxVersions != null) {
                columnDescriptor.setMaxVersions(Integer.parseInt(maxVersions));
            }
            if (timeToLive != null) {
                columnDescriptor.setTimeToLive(Integer.parseInt(timeToLive));
            }
            if (inMemory != null) {
                columnDescriptor.setInMemory(Boolean.parseBoolean(inMemory));
            }
        }

        public void addColumnFamily(String tableName, String familyName) {
            Map<String, HColumnDescriptor> families = this.getOrCreateFamilies(tableName);
            this.getOrCreateFamily(familyName, families);
        }

        public void addField(String fieldName, String family, String qualifier) {
            byte[] familyBytes = Bytes.toBytes((String)family);
            byte[] qualifierBytes = qualifier == null ? null : Bytes.toBytes((String)qualifier);
            HBaseColumn column = new HBaseColumn(familyBytes, qualifierBytes);
            this.columnMap.put(fieldName, column);
        }

        private HColumnDescriptor getOrCreateFamily(String familyName, Map<String, HColumnDescriptor> families) {
            HColumnDescriptor columnDescriptor = families.get(familyName);
            if (columnDescriptor == null) {
                columnDescriptor = new HColumnDescriptor(familyName);
                families.put(familyName, columnDescriptor);
            }
            return columnDescriptor;
        }

        private Map<String, HColumnDescriptor> getOrCreateFamilies(String tableName) {
            Map<String, HColumnDescriptor> families = this.tableToFamilies.get(tableName);
            if (families == null) {
                families = new HashMap<String, HColumnDescriptor>();
                this.tableToFamilies.put(tableName, families);
            }
            return families;
        }

        public void renameTable(String oldName, String newName) {
            Map<String, HColumnDescriptor> families = this.tableToFamilies.remove(oldName);
            if (families == null) {
                throw new IllegalArgumentException(oldName + " does not exist");
            }
            this.tableToFamilies.put(newName, families);
        }

        public HBaseMapping build() {
            if (this.tableName == null) {
                throw new IllegalStateException("tableName is not specified");
            }
            Map<String, HColumnDescriptor> families = this.tableToFamilies.get(this.tableName);
            if (families == null) {
                throw new IllegalStateException("no families for table " + this.tableName);
            }
            HTableDescriptor tableDescriptors = new HTableDescriptor(this.tableName);
            for (HColumnDescriptor desc : families.values()) {
                tableDescriptors.addFamily(desc);
            }
            return new HBaseMapping(tableDescriptors, this.columnMap);
        }
    }
}

