/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.gora.util.AvroUtils;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseByteInterface {
    public static final ThreadLocal<BinaryDecoder> decoders = new ThreadLocal();
    public static final ThreadLocal<BinaryEncoderWithStream> encoders = new ThreadLocal();
    public static final ThreadLocal<Map<String, SpecificDatumReader<?>>> readerMaps = new ThreadLocal<Map<String, SpecificDatumReader<?>>>(){

        @Override
        protected Map<String, SpecificDatumReader<?>> initialValue() {
            return new HashMap();
        }
    };
    public static final ThreadLocal<Map<String, SpecificDatumWriter<?>>> writerMaps = new ThreadLocal<Map<String, SpecificDatumWriter<?>>>(){

        @Override
        protected Map<String, SpecificDatumWriter<?>> initialValue() {
            return new HashMap();
        }
    };

    public static Object fromBytes(Schema schema, byte[] val) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case ENUM: {
                return AvroUtils.getEnumValue((Schema)schema, (int)val[0]);
            }
            case STRING: {
                return new Utf8(Bytes.toString((byte[])val));
            }
            case BYTES: {
                return ByteBuffer.wrap(val);
            }
            case INT: {
                return Bytes.toInt((byte[])val);
            }
            case LONG: {
                return Bytes.toLong((byte[])val);
            }
            case FLOAT: {
                return Float.valueOf(Bytes.toFloat((byte[])val));
            }
            case DOUBLE: {
                return Bytes.toDouble((byte[])val);
            }
            case BOOLEAN: {
                return val[0] != 0;
            }
            case RECORD: {
                Map<String, SpecificDatumReader<?>> readerMap = readerMaps.get();
                SpecificDatumReader reader = readerMap.get(schema.getFullName());
                if (reader == null) {
                    reader = new SpecificDatumReader(schema);
                    readerMap.put(schema.getFullName(), reader);
                }
                BinaryDecoder decoderFromCache = decoders.get();
                BinaryDecoder decoder = DecoderFactory.defaultFactory().createBinaryDecoder(val, decoderFromCache);
                if (decoderFromCache == null) {
                    decoders.set(decoder);
                }
                return reader.read(null, (Decoder)decoder);
            }
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public static <K> K fromBytes(Class<K> clazz, byte[] val) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return (K)Byte.valueOf(val[0]);
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return (K)Boolean.valueOf(val[0] != 0);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return (K)Short.valueOf(Bytes.toShort((byte[])val));
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return (K)Integer.valueOf(Bytes.toInt((byte[])val));
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return (K)Long.valueOf(Bytes.toLong((byte[])val));
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return (K)Float.valueOf(Bytes.toFloat((byte[])val));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return (K)Double.valueOf(Bytes.toDouble((byte[])val));
        }
        if (clazz.equals(String.class)) {
            return (K)Bytes.toString((byte[])val);
        }
        if (clazz.equals(Utf8.class)) {
            return (K)new Utf8(Bytes.toString((byte[])val));
        }
        throw new RuntimeException("Can't parse data as class: " + clazz);
    }

    public static byte[] toBytes(Object o) {
        Class<?> clazz = o.getClass();
        if (clazz.equals(Enum.class)) {
            return new byte[]{(byte)((Enum)o).ordinal()};
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return new byte[]{(Byte)o};
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return new byte[]{(Boolean)o != false ? (byte)1 : 0};
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return Bytes.toBytes((short)((Short)o));
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Bytes.toBytes((int)((Integer)o));
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Bytes.toBytes((long)((Long)o));
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Bytes.toBytes((float)((Float)o).floatValue());
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return Bytes.toBytes((double)((Double)o));
        }
        if (clazz.equals(String.class)) {
            return Bytes.toBytes((String)((String)o));
        }
        if (clazz.equals(Utf8.class)) {
            return ((Utf8)o).getBytes();
        }
        throw new RuntimeException("Can't parse data as class: " + clazz);
    }

    public static byte[] toBytes(Object o, Schema schema) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case STRING: {
                return Bytes.toBytes((String)((Utf8)o).toString());
            }
            case BYTES: {
                return ((ByteBuffer)o).array();
            }
            case INT: {
                return Bytes.toBytes((int)((Integer)o));
            }
            case LONG: {
                return Bytes.toBytes((long)((Long)o));
            }
            case FLOAT: {
                return Bytes.toBytes((float)((Float)o).floatValue());
            }
            case DOUBLE: {
                return Bytes.toBytes((double)((Double)o));
            }
            case BOOLEAN: {
                byte[] byArray;
                if (((Boolean)o).booleanValue()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                return byArray;
            }
            case ENUM: {
                return new byte[]{(byte)((Enum)o).ordinal()};
            }
            case RECORD: {
                BinaryEncoderWithStream encoder;
                Map<String, SpecificDatumWriter<?>> writerMap = writerMaps.get();
                SpecificDatumWriter writer = writerMap.get(schema.getFullName());
                if (writer == null) {
                    writer = new SpecificDatumWriter(schema);
                    writerMap.put(schema.getFullName(), writer);
                }
                if ((encoder = encoders.get()) == null) {
                    encoder = new BinaryEncoderWithStream(new ByteArrayOutputStream());
                    encoders.set(encoder);
                }
                ByteArrayOutputStream os = (ByteArrayOutputStream)encoder.getOut();
                os.reset();
                writer.write(o, (Encoder)encoder);
                encoder.flush();
                return os.toByteArray();
            }
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public static final class BinaryEncoderWithStream
    extends BinaryEncoder {
        public BinaryEncoderWithStream(OutputStream out) {
            super(out);
        }

        protected OutputStream getOut() {
            return this.out;
        }
    }
}

