/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.apache.gora.examples.generated.Employee;
import org.apache.gora.examples.generated.Metadata;
import org.apache.gora.hbase.util.HBaseByteInterface;
import org.junit.Assert;
import org.junit.Test;

public class TestHBaseByteInterface {
    private static final Random RANDOM = new Random();

    @Test
    public void testEncodingDecoding() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            Utf8 name = new Utf8("john");
            long dateOfBirth = System.currentTimeMillis();
            int salary = 1337;
            Utf8 ssn = new Utf8(String.valueOf(RANDOM.nextLong()));
            Employee e = new Employee();
            e.setName(name);
            e.setDateOfBirth(dateOfBirth);
            e.setSalary(salary);
            e.setSsn(ssn);
            byte[] employerBytes = HBaseByteInterface.toBytes((Object)e, (Schema)Employee._SCHEMA);
            Employee e2 = (Employee)HBaseByteInterface.fromBytes((Schema)Employee._SCHEMA, (byte[])employerBytes);
            Assert.assertEquals((Object)name, (Object)e2.getName());
            Assert.assertEquals((long)dateOfBirth, (long)e2.getDateOfBirth());
            Assert.assertEquals((long)salary, (long)e2.getSalary());
            Assert.assertEquals((Object)ssn, (Object)e2.getSsn());
            Utf8 key = new Utf8("theKey");
            Utf8 value = new Utf8("theValue " + RANDOM.nextLong());
            Metadata m = new Metadata();
            m.putToData(key, value);
            byte[] datumBytes = HBaseByteInterface.toBytes((Object)m, (Schema)Metadata._SCHEMA);
            Metadata m2 = (Metadata)HBaseByteInterface.fromBytes((Schema)Metadata._SCHEMA, (byte[])datumBytes);
            Assert.assertEquals((Object)value, (Object)m2.getFromData(key));
        }
    }

    @Test
    public void testEncodingDecodingMultithreaded() throws Exception {
        int numThreads = 8;
        ExecutorService pool = Executors.newFixedThreadPool(numThreads);
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < numThreads; ++i) {
            tasks.add(new Callable<Integer>(){

                @Override
                public Integer call() {
                    try {
                        TestHBaseByteInterface.this.testEncodingDecoding();
                        return 0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 1;
                    }
                }
            });
        }
        List results = pool.invokeAll(tasks);
        for (Future result : results) {
            Assert.assertEquals((long)0L, (long)((Integer)result.get()).intValue());
        }
    }
}

