/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.gora.GoraTestDriver;
import org.apache.gora.examples.generated.Employee;
import org.apache.gora.examples.generated.WebPage;
import org.apache.gora.hbase.GoraHBaseTestDriver;
import org.apache.gora.hbase.store.HBaseStore;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.DataStoreTestBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHBaseStore
extends DataStoreTestBase {
    private Configuration conf;

    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.getTestDriver().getHbaseUtil().getConfiguration();
    }

    protected DataStore<String, Employee> createEmployeeDataStore() throws IOException {
        return DataStoreFactory.createDataStore(HBaseStore.class, String.class, Employee.class, (Configuration)this.conf);
    }

    protected DataStore<String, WebPage> createWebPageDataStore() throws IOException {
        return DataStoreFactory.createDataStore(HBaseStore.class, String.class, WebPage.class, (Configuration)this.conf);
    }

    public GoraHBaseTestDriver getTestDriver() {
        return (GoraHBaseTestDriver)testDriver;
    }

    public void assertSchemaExists(String schemaName) throws Exception {
        HBaseAdmin admin = this.getTestDriver().getHbaseUtil().getHBaseAdmin();
        Assert.assertTrue((boolean)admin.tableExists(schemaName));
    }

    public void assertPutArray() throws IOException {
        HTable table = new HTable("WebPage");
        Get get = new Get(Bytes.toBytes((String)"com.example/http"));
        Result result = table.get(get);
        Assert.assertEquals((int)result.getFamilyMap(Bytes.toBytes((String)"parsedContent")).size(), (int)4);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)"parsedContent"), Bytes.toBytes((int)0)), Bytes.toBytes((String)"example")));
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)"parsedContent"), Bytes.toBytes((int)3)), Bytes.toBytes((String)"example.com")));
        table.close();
    }

    public void assertPutBytes(byte[] contentBytes) throws IOException {
        HTable table = new HTable("WebPage");
        Get get = new Get(Bytes.toBytes((String)"com.example/http"));
        Result result = table.get(get);
        byte[] actualBytes = result.getValue(Bytes.toBytes((String)"content"), null);
        Assert.assertNotNull((Object)actualBytes);
        Assert.assertTrue((boolean)Arrays.equals(contentBytes, actualBytes));
        table.close();
    }

    public void assertPutMap() throws IOException {
        HTable table = new HTable("WebPage");
        Get get = new Get(Bytes.toBytes((String)"com.example/http"));
        Result result = table.get(get);
        byte[] anchor2Raw = result.getValue(Bytes.toBytes((String)"outlinks"), Bytes.toBytes((String)"http://example2.com"));
        Assert.assertNotNull((Object)anchor2Raw);
        String anchor2 = Bytes.toString((byte[])anchor2Raw);
        Assert.assertEquals((String)"anchor2", (String)anchor2);
        table.close();
    }

    public void testQueryEndKey() throws IOException {
    }

    public void testQueryKeyRange() throws IOException {
    }

    public void testDeleteByQuery() throws IOException {
    }

    public static void main(String[] args) throws Exception {
        TestHBaseStore test = new TestHBaseStore();
        test.setUpClass();
        test.setUp();
        test.testQuery();
        test.tearDown();
        test.tearDownClass();
    }

    static {
        TestHBaseStore.setTestDriver((GoraTestDriver)new GoraHBaseTestDriver());
    }
}

