/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.util.Utf8;
import org.apache.gora.hbase.query.HBaseGetResult;
import org.apache.gora.hbase.query.HBaseQuery;
import org.apache.gora.hbase.query.HBaseScannerResult;
import org.apache.gora.hbase.store.HBaseColumn;
import org.apache.gora.hbase.store.HBaseMapping;
import org.apache.gora.hbase.store.HBaseTableConnection;
import org.apache.gora.hbase.util.HBaseByteInterface;
import org.apache.gora.persistency.ListGenericArray;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.State;
import org.apache.gora.persistency.StateManager;
import org.apache.gora.persistency.StatefulHashMap;
import org.apache.gora.persistency.StatefulMap;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HBaseStore<K, T extends Persistent>
extends DataStoreBase<K, T>
implements Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(HBaseStore.class);
    public static final String PARSE_MAPPING_FILE_KEY = "gora.hbase.mapping.file";
    @Deprecated
    private static final String DEPRECATED_MAPPING_FILE = "hbase-mapping.xml";
    public static final String DEFAULT_MAPPING_FILE = "gora-hbase-mapping.xml";
    private volatile HBaseAdmin admin;
    private volatile HBaseTableConnection table;
    private final boolean autoCreateSchema = true;
    private volatile HBaseMapping mapping;

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) throws IOException {
        super.initialize(keyClass, persistentClass, properties);
        this.conf = HBaseConfiguration.create((Configuration)this.getConf());
        this.admin = new HBaseAdmin(this.conf);
        try {
            this.mapping = this.readMapping(this.getConf().get(PARSE_MAPPING_FILE_KEY, DEFAULT_MAPPING_FILE));
        }
        catch (FileNotFoundException ex) {
            try {
                this.mapping = this.readMapping(this.getConf().get(PARSE_MAPPING_FILE_KEY, DEPRECATED_MAPPING_FILE));
                LOG.warn("hbase-mapping.xml is deprecated, please rename the file to gora-hbase-mapping.xml");
            }
            catch (FileNotFoundException ex1) {
                throw ex;
            }
            catch (Exception ex1) {
                LOG.warn("hbase-mapping.xml is deprecated, please rename the file to gora-hbase-mapping.xml");
                throw new RuntimeException(ex1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.createSchema();
        boolean autoflush = this.conf.getBoolean("hbase.client.autoflush.default", false);
        this.table = new HBaseTableConnection(this.getConf(), this.getSchemaName(), autoflush);
    }

    public String getSchemaName() {
        return this.mapping.getTableName();
    }

    public void createSchema() throws IOException {
        if (this.schemaExists()) {
            return;
        }
        HTableDescriptor tableDesc = this.mapping.getTable();
        this.admin.createTable(tableDesc);
    }

    public void deleteSchema() throws IOException {
        if (!this.schemaExists()) {
            return;
        }
        this.admin.disableTable(this.getSchemaName());
        this.admin.deleteTable(this.getSchemaName());
    }

    public boolean schemaExists() throws IOException {
        return this.admin.tableExists(this.mapping.getTableName());
    }

    public T get(K key, String[] fields) throws IOException {
        fields = this.getFieldsToQuery(fields);
        Get get = new Get(HBaseByteInterface.toBytes(key));
        this.addFields(get, fields);
        org.apache.hadoop.hbase.client.Result result = this.table.get(get);
        return this.newInstance(result, fields);
    }

    public void put(K key, T persistent) throws IOException {
        Schema schema = persistent.getSchema();
        StateManager stateManager = persistent.getStateManager();
        byte[] keyRaw = HBaseByteInterface.toBytes(key);
        Put put = new Put(keyRaw);
        Delete delete = new Delete(keyRaw);
        boolean hasPuts = false;
        boolean hasDeletes = false;
        Iterator iter = schema.getFields().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Schema.Field field = (Schema.Field)iter.next();
            if (stateManager.isDirty(persistent, i)) {
                Schema.Type type = field.schema().getType();
                Object o = persistent.get(i);
                HBaseColumn hcol = this.mapping.getColumn(field.name());
                switch (type) {
                    case MAP: {
                        byte[] val;
                        if (o instanceof StatefulMap) {
                            StatefulHashMap map = (StatefulHashMap)o;
                            for (Map.Entry e : map.states().entrySet()) {
                                Utf8 mapKey = (Utf8)e.getKey();
                                switch ((State)e.getValue()) {
                                    case DIRTY: {
                                        byte[] qual = Bytes.toBytes((String)mapKey.toString());
                                        byte[] val2 = HBaseByteInterface.toBytes(map.get((Object)mapKey), field.schema().getValueType());
                                        put.add(hcol.getFamily(), qual, val2);
                                        hasPuts = true;
                                        break;
                                    }
                                    case DELETED: {
                                        byte[] qual = Bytes.toBytes((String)mapKey.toString());
                                        hasDeletes = true;
                                        delete.deleteColumn(hcol.getFamily(), qual);
                                    }
                                }
                            }
                        } else {
                            Set set = ((Map)o).entrySet();
                            for (Map.Entry entry : set) {
                                byte[] qual = HBaseByteInterface.toBytes(entry.getKey());
                                val = HBaseByteInterface.toBytes(entry.getValue());
                                put.add(hcol.getFamily(), qual, val);
                                hasPuts = true;
                            }
                        }
                        break;
                    }
                    case ARRAY: {
                        byte[] val;
                        if (!(o instanceof GenericArray)) break;
                        GenericArray arr = (GenericArray)o;
                        int j = 0;
                        for (Object item : arr) {
                            val = HBaseByteInterface.toBytes(item);
                            put.add(hcol.getFamily(), Bytes.toBytes((int)j++), val);
                            hasPuts = true;
                        }
                        break;
                    }
                    default: {
                        put.add(hcol.getFamily(), hcol.getQualifier(), HBaseByteInterface.toBytes(o, field.schema()));
                        hasPuts = true;
                    }
                }
            }
            ++i;
        }
        if (hasPuts) {
            this.table.put(put);
        }
        if (hasDeletes) {
            this.table.delete(delete);
        }
    }

    public void delete(T obj) {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean delete(K key) throws IOException {
        this.table.delete(new Delete(HBaseByteInterface.toBytes(key)));
        return true;
    }

    public long deleteByQuery(Query<K, T> query) throws IOException {
        Object[] fields = this.getFieldsToQuery(query.getFields());
        boolean isAllFields = Arrays.equals(fields, this.getBeanFactory().getCachedPersistent().getFields());
        Result result = query.execute();
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        while (result.next()) {
            Delete delete = new Delete(HBaseByteInterface.toBytes(result.getKey()));
            deletes.add(delete);
            if (isAllFields) continue;
            this.addFields(delete, query);
        }
        this.table.delete(deletes);
        return deletes.size();
    }

    public void flush() throws IOException {
        this.table.flushCommits();
    }

    public Query<K, T> newQuery() {
        return new HBaseQuery(this);
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        Pair<byte[][], byte[][]> keys = this.table.getStartEndKeys();
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            throw new IOException("Expecting at least one region.");
        }
        if (this.table == null) {
            throw new IOException("No table was provided.");
        }
        ArrayList<PartitionQuery<K, T>> partitions = new ArrayList<PartitionQuery<K, T>>(((byte[][])keys.getFirst()).length);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            byte[] stopRow;
            String regionLocation = this.table.getRegionLocation(((byte[][])keys.getFirst())[i]).getServerAddress().getHostname();
            byte[] startRow = query.getStartKey() != null ? HBaseByteInterface.toBytes(query.getStartKey()) : HConstants.EMPTY_START_ROW;
            byte[] byArray = stopRow = query.getEndKey() != null ? HBaseByteInterface.toBytes(query.getEndKey()) : HConstants.EMPTY_END_ROW;
            if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
            Object startKey = Arrays.equals(HConstants.EMPTY_START_ROW, splitStart) ? null : HBaseByteInterface.fromBytes(this.keyClass, splitStart);
            Object endKey = Arrays.equals(HConstants.EMPTY_END_ROW, splitStop) ? null : HBaseByteInterface.fromBytes(this.keyClass, splitStop);
            PartitionQueryImpl partition = new PartitionQueryImpl(query, startKey, endKey, new String[]{regionLocation});
            partitions.add((PartitionQuery<K, T>)partition);
        }
        return partitions;
    }

    public Result<K, T> execute(Query<K, T> query) throws IOException {
        query.setFields(this.getFieldsToQuery(query.getFields()));
        if (query.getStartKey() != null && query.getStartKey().equals(query.getEndKey())) {
            Get get = new Get(HBaseByteInterface.toBytes(query.getStartKey()));
            this.addFields(get, query.getFields());
            this.addTimeRange(get, query);
            org.apache.hadoop.hbase.client.Result result = this.table.get(get);
            return new HBaseGetResult<K, T>(this, query, result);
        }
        ResultScanner scanner = this.createScanner(query);
        HBaseScannerResult<K, T> result = new HBaseScannerResult<K, T>(this, query, scanner);
        return result;
    }

    public ResultScanner createScanner(Query<K, T> query) throws IOException {
        Scan scan = new Scan();
        if (query.getStartKey() != null) {
            scan.setStartRow(HBaseByteInterface.toBytes(query.getStartKey()));
        }
        if (query.getEndKey() != null) {
            scan.setStopRow(HBaseByteInterface.toBytes(query.getEndKey()));
        }
        this.addFields(scan, query);
        return this.table.getScanner(scan);
    }

    private void addFields(Get get, String[] fieldNames) {
        block3: for (String f : fieldNames) {
            HBaseColumn col = this.mapping.getColumn(f);
            Schema fieldSchema = ((Schema.Field)this.fieldMap.get(f)).schema();
            switch (fieldSchema.getType()) {
                case MAP: 
                case ARRAY: {
                    get.addFamily(col.family);
                    continue block3;
                }
                default: {
                    get.addColumn(col.family, col.qualifier);
                }
            }
        }
    }

    private void addFields(Scan scan, Query<K, T> query) throws IOException {
        String[] fields;
        block3: for (String f : fields = query.getFields()) {
            HBaseColumn col = this.mapping.getColumn(f);
            Schema fieldSchema = ((Schema.Field)this.fieldMap.get(f)).schema();
            switch (fieldSchema.getType()) {
                case MAP: 
                case ARRAY: {
                    scan.addFamily(col.family);
                    continue block3;
                }
                default: {
                    scan.addColumn(col.family, col.qualifier);
                }
            }
        }
    }

    private void addFields(Delete delete, Query<K, T> query) throws IOException {
        String[] fields;
        block3: for (String f : fields = query.getFields()) {
            HBaseColumn col = this.mapping.getColumn(f);
            Schema fieldSchema = ((Schema.Field)this.fieldMap.get(f)).schema();
            switch (fieldSchema.getType()) {
                case MAP: 
                case ARRAY: {
                    delete.deleteFamily(col.family);
                    continue block3;
                }
                default: {
                    delete.deleteColumn(col.family, col.qualifier);
                }
            }
        }
    }

    private void addTimeRange(Get get, Query<K, T> query) throws IOException {
        if (query.getStartTime() > 0L || query.getEndTime() > 0L) {
            if (query.getStartTime() == query.getEndTime()) {
                get.setTimeStamp(query.getStartTime());
            } else {
                long startTime = query.getStartTime() > 0L ? query.getStartTime() : 0L;
                long endTime = query.getEndTime() > 0L ? query.getEndTime() : Long.MAX_VALUE;
                get.setTimeRange(startTime, endTime);
            }
        }
    }

    public T newInstance(org.apache.hadoop.hbase.client.Result result, String[] fields) throws IOException {
        if (result == null || result.isEmpty()) {
            return null;
        }
        Persistent persistent = this.newPersistent();
        StateManager stateManager = persistent.getStateManager();
        block4: for (String f : fields) {
            HBaseColumn col = this.mapping.getColumn(f);
            Schema.Field field = (Schema.Field)this.fieldMap.get(f);
            Schema fieldSchema = field.schema();
            switch (fieldSchema.getType()) {
                case MAP: {
                    NavigableMap qualMap = (NavigableMap)result.getNoVersionMap().get(col.getFamily());
                    if (qualMap == null) continue block4;
                    Schema valueSchema = fieldSchema.getValueType();
                    HashMap<Utf8, Object> map = new HashMap<Utf8, Object>();
                    for (Map.Entry e : qualMap.entrySet()) {
                        map.put(new Utf8(Bytes.toString((byte[])((byte[])e.getKey()))), HBaseByteInterface.fromBytes(valueSchema, (byte[])e.getValue()));
                    }
                    this.setField(persistent, field, map);
                    continue block4;
                }
                case ARRAY: {
                    NavigableMap qualMap = result.getFamilyMap(col.getFamily());
                    if (qualMap == null) continue block4;
                    Schema valueSchema = fieldSchema.getElementType();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (Map.Entry e : qualMap.entrySet()) {
                        arrayList.add(HBaseByteInterface.fromBytes(valueSchema, (byte[])e.getValue()));
                    }
                    ListGenericArray arr = new ListGenericArray(fieldSchema, arrayList);
                    this.setField(persistent, field, (GenericArray)arr);
                    continue block4;
                }
                default: {
                    byte[] val = result.getValue(col.getFamily(), col.getQualifier());
                    if (val == null) continue block4;
                    this.setField(persistent, field, val);
                }
            }
        }
        stateManager.clearDirty(persistent);
        return (T)persistent;
    }

    private void setField(T persistent, Schema.Field field, Map map) {
        persistent.put(field.pos(), (Object)new StatefulHashMap(map));
    }

    private void setField(T persistent, Schema.Field field, byte[] val) throws IOException {
        persistent.put(field.pos(), HBaseByteInterface.fromBytes(field.schema(), val));
    }

    private void setField(T persistent, Schema.Field field, GenericArray list) {
        persistent.put(field.pos(), (Object)list);
    }

    private HBaseMapping readMapping(String filename) throws IOException {
        HBaseMapping.HBaseMappingBuilder mappingBuilder = new HBaseMapping.HBaseMappingBuilder();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename));
            Element root = doc.getRootElement();
            List tableElements = root.getChildren("table");
            for (Element tableElement : tableElements) {
                String tableName = tableElement.getAttributeValue("name");
                List fieldElements = tableElement.getChildren("family");
                for (Element fieldElement : fieldElements) {
                    String familyName = fieldElement.getAttributeValue("name");
                    String compression = fieldElement.getAttributeValue("compression");
                    String blockCache = fieldElement.getAttributeValue("blockCache");
                    String blockSize = fieldElement.getAttributeValue("blockSize");
                    String bloomFilter = fieldElement.getAttributeValue("bloomFilter");
                    String maxVersions = fieldElement.getAttributeValue("maxVersions");
                    String timeToLive = fieldElement.getAttributeValue("timeToLive");
                    String inMemory = fieldElement.getAttributeValue("inMemory");
                    mappingBuilder.addFamilyProps(tableName, familyName, compression, blockCache, blockSize, bloomFilter, maxVersions, timeToLive, inMemory);
                }
            }
            List classElements = root.getChildren("class");
            for (Element classElement : classElements) {
                if (!classElement.getAttributeValue("keyClass").equals(this.keyClass.getCanonicalName()) || !classElement.getAttributeValue("name").equals(this.persistentClass.getCanonicalName())) continue;
                String tableNameFromMapping = classElement.getAttributeValue("table");
                String tableName = this.getSchemaName(tableNameFromMapping, this.persistentClass);
                if (!tableName.equals(tableNameFromMapping)) {
                    LOG.info("Keyclass and nameclass match but mismatching table names  mappingfile schema is '" + tableNameFromMapping + "' vs actual schema '" + tableName + "' , assuming they are the same.");
                    if (tableNameFromMapping != null) {
                        mappingBuilder.renameTable(tableNameFromMapping, tableName);
                    }
                }
                mappingBuilder.setTableName(tableName);
                List fields = classElement.getChildren("field");
                for (Element field : fields) {
                    String fieldName = field.getAttributeValue("name");
                    String family = field.getAttributeValue("family");
                    String qualifier = field.getAttributeValue("qualifier");
                    mappingBuilder.addField(fieldName, family, qualifier);
                    mappingBuilder.addColumnFamily(tableName, family);
                }
                break;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return mappingBuilder.build();
    }

    public void close() throws IOException {
        this.table.close();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

