/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase;

import org.apache.gora.GoraTestDriver;
import org.apache.gora.hbase.store.HBaseStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class GoraHBaseTestDriver
extends GoraTestDriver {
    protected HBaseTestingUtility hbaseUtil = new HBaseTestingUtility();
    protected int numServers = 1;

    public GoraHBaseTestDriver() {
        super(HBaseStore.class);
    }

    public void setNumServers(int numServers) {
        this.numServers = numServers;
    }

    public int getNumServers() {
        return this.numServers;
    }

    public void setUpClass() throws Exception {
        super.setUpClass();
        log.info("Starting HBase cluster");
        this.hbaseUtil.startMiniCluster(this.numServers);
    }

    public void tearDownClass() throws Exception {
        super.tearDownClass();
        log.info("Stoping HBase cluster");
        this.hbaseUtil.shutdownMiniCluster();
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void deleteAllTables() throws Exception {
        HBaseAdmin admin = this.hbaseUtil.getHBaseAdmin();
        for (HTableDescriptor table : admin.listTables()) {
            admin.disableTable(table.getName());
            admin.deleteTable(table.getName());
        }
    }

    public Configuration getConf() {
        return this.hbaseUtil.getConfiguration();
    }

    public HBaseTestingUtility getHbaseUtil() {
        return this.hbaseUtil;
    }
}

