/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.hbase.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.gora.hbase.store.HBaseColumn;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseMapping {
    private Map<String, HTableDescriptor> tableDescriptors = new HashMap<String, HTableDescriptor>();
    private String tableName;
    private Map<String, HBaseColumn> columnMap = new HashMap<String, HBaseColumn>();

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addTable(String tableName) {
        if (!this.tableDescriptors.containsKey(tableName)) {
            this.tableDescriptors.put(tableName, new HTableDescriptor(tableName));
        }
    }

    public HTableDescriptor getTable() {
        return this.getTable(this.tableName);
    }

    public HTableDescriptor getTable(String tableName) {
        return this.tableDescriptors.get(tableName);
    }

    public void addColumnFamily(String tableName, String familyName, String compression, String blockCache, String blockSize, String bloomFilter, String maxVersions, String timeToLive, String inMemory) {
        HColumnDescriptor columnDescriptor = this.addColumnFamily(tableName, familyName);
        if (compression != null) {
            columnDescriptor.setCompressionType(Compression.Algorithm.valueOf((String)compression));
        }
        if (blockCache != null) {
            columnDescriptor.setBlockCacheEnabled(Boolean.parseBoolean(blockCache));
        }
        if (blockSize != null) {
            columnDescriptor.setBlocksize(Integer.parseInt(blockSize));
        }
        if (bloomFilter != null) {
            columnDescriptor.setBloomFilterType(StoreFile.BloomType.valueOf((String)bloomFilter));
        }
        if (maxVersions != null) {
            columnDescriptor.setMaxVersions(Integer.parseInt(maxVersions));
        }
        if (timeToLive != null) {
            columnDescriptor.setTimeToLive(Integer.parseInt(timeToLive));
        }
        if (inMemory != null) {
            columnDescriptor.setInMemory(Boolean.parseBoolean(inMemory));
        }
        this.getTable(tableName).addFamily(columnDescriptor);
    }

    public HColumnDescriptor addColumnFamily(String tableName, String familyName) {
        HTableDescriptor tableDescriptor = this.getTable(tableName);
        HColumnDescriptor columnDescriptor = tableDescriptor.getFamily(Bytes.toBytes((String)familyName));
        if (columnDescriptor == null) {
            columnDescriptor = new HColumnDescriptor(familyName);
            tableDescriptor.addFamily(columnDescriptor);
        }
        return columnDescriptor;
    }

    public void addField(String fieldName, String tableName, String family, String qualifier) {
        byte[] familyBytes = Bytes.toBytes((String)family);
        byte[] qualifierBytes = qualifier == null ? null : Bytes.toBytes((String)qualifier);
        HBaseColumn column = new HBaseColumn(tableName, familyBytes, qualifierBytes);
        this.columnMap.put(fieldName, column);
    }

    public HBaseColumn getColumn(String fieldName) {
        return this.columnMap.get(fieldName);
    }
}

