/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBUtils {
    public static final String DYNAMO_KEY_HASHRANGE = "hashrange";
    public static final String DYNAMO_KEY_HASHR = "hash";
    public static final String AWS_CREDENTIALS_PROPERTIES = "awscredentials.properties";
    public static final String WS_PROVIDER = "amazon.web.services";
    public static final String CLI_TYP_PROP = "gora.dynamodb.client";
    public static final String ENDPOINT_PROP = "gora.dynamodb.endpoint";
    public static final String PREF_SCH_NAME = "preferred.schema.name";
    public static final String CONSISTENCY_READS = "gora.dynamodb.consistent.reads";
    public static final String CONSISTENCY_READS_TRUE = "true";
    public static final String SERIALIZATION_TYPE = "gora.dynamodb.serialization.type";
    public static final String DYNAMO_SERIALIZATION = "dynamo";
    public static final String AVRO_SERIALIZATION = "avro";
    public static final String SYNC_CLIENT_PROP = "sync";
    public static final String ASYNC_CLIENT_PROP = "async";
    public static final String MAPPING_FILE = "gora-dynamodb-mapping.xml";
    public static long WAIT_TIME = 600000L;
    public static long SLEEP_TIME = 20000L;
    public static long SLEEP_DELETE_TIME = 10000L;
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBUtils.class);

    public static AmazonDynamoDB getClient(String clientType, AWSCredentials credentials) {
        if (clientType.equals(SYNC_CLIENT_PROP)) {
            return new AmazonDynamoDBClient(credentials);
        }
        if (clientType.equals(ASYNC_CLIENT_PROP)) {
            return new AmazonDynamoDBAsyncClient(credentials);
        }
        return null;
    }

    public static PropertiesCredentials getCredentials(Class<?> clazz) {
        PropertiesCredentials awsCredentials = null;
        try {
            InputStream awsCredInpStr = clazz.getClassLoader().getResourceAsStream(AWS_CREDENTIALS_PROPERTIES);
            if (awsCredInpStr == null) {
                LOG.error("AWS Credentials File was not found on the classpath!");
            }
            awsCredentials = new PropertiesCredentials(awsCredInpStr);
        }
        catch (IOException e) {
            LOG.error("Error loading AWS Credentials File from the classpath!", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return awsCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCreateTableRequest(AmazonDynamoDB awsClient, String tableName, ArrayList<KeySchemaElement> keySchema, Map<String, String> attrs, ProvisionedThroughput proThrou) {
        CreateTableRequest createTableRequest = DynamoDBUtils.buildCreateTableRequest(tableName, keySchema, proThrou, attrs);
        try {
            awsClient.createTable(createTableRequest).getTableDescription();
            DynamoDBUtils.waitForTableToBecomeAvailable(awsClient, tableName);
        }
        catch (ResourceInUseException ex) {
            LOG.warn("Table '{}' already exists.", (Object)tableName);
        }
        finally {
            LOG.info("Table '{}' is available.", (Object)tableName);
        }
    }

    public static CreateTableRequest buildCreateTableRequest(String tableName, ArrayList<KeySchemaElement> keySchema, ProvisionedThroughput proThrou, Map<String, String> attrs) {
        CreateTableRequest createTableRequest = new CreateTableRequest();
        createTableRequest.setTableName(tableName);
        createTableRequest.setKeySchema(keySchema);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        for (KeySchemaElement kEle : keySchema) {
            AttributeDefinition attrDef = new AttributeDefinition();
            attrDef.setAttributeName(kEle.getAttributeName());
            attrDef.setAttributeType(attrs.get(kEle.getAttributeName()));
            attributeDefinitions.add(attrDef);
        }
        createTableRequest.setAttributeDefinitions(attributeDefinitions);
        createTableRequest.setProvisionedThroughput(proThrou);
        return createTableRequest;
    }

    public static void waitForTableToBecomeAvailable(AmazonDynamoDB awsClient, String tableName) {
        LOG.debug("Waiting for {} to become available", (Object)tableName);
        long startTime = System.currentTimeMillis();
        long endTime = startTime + WAIT_TIME;
        while (System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                DescribeTableRequest request = new DescribeTableRequest().withTableName(tableName);
                TableDescription tableDescription = awsClient.describeTable(request).getTable();
                String tableStatus = tableDescription.getTableStatus();
                LOG.debug("{} - current state: {}", (Object)tableName, (Object)tableStatus);
                if (!tableStatus.equals(TableStatus.ACTIVE.toString())) continue;
                return;
            }
            catch (AmazonServiceException ase) {
                if (ase.getErrorCode().equalsIgnoreCase("ResourceNotFoundException")) continue;
                throw ase;
            }
        }
        throw new RuntimeException("Table " + tableName + " never became active");
    }

    public static enum DynamoDBType {
        DYNAMO("native"),
        AVRO("avro");

        private String value;

        private DynamoDBType(String val) {
            this.value = val;
        }

        public String toString() {
            return this.value;
        }
    }
}

