/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.NullArgumentException;
import org.apache.gora.dynamodb.query.DynamoDBKey;
import org.apache.gora.dynamodb.query.DynamoDBQuery;
import org.apache.gora.dynamodb.query.DynamoDBResult;
import org.apache.gora.dynamodb.store.DynamoDBStore;
import org.apache.gora.dynamodb.store.DynamoDBUtils;
import org.apache.gora.dynamodb.store.IDynamoDB;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.ws.impl.WSDataStoreBase;
import org.apache.gora.util.GoraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBNativeStore<K, T extends Persistent>
extends WSDataStoreBase<K, T>
implements IDynamoDB<K, T> {
    private static final String GET_RANGE_KEY_METHOD = "getRangeKey";
    private static final String GET_HASH_KEY_METHOD = "getHashKey";
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBNativeStore.class);
    private DynamoDBStore<K, T> dynamoDBStoreHandler;

    public long deleteByQuery(Query<K, T> query) {
        Result<K, T> result = this.execute(query);
        ArrayList<Persistent> deletes = new ArrayList<Persistent>();
        try {
            while (result.next()) {
                Persistent resultObj = result.get();
                deletes.add(resultObj);
                DynamoDBKey<Object, Object> dKey = new DynamoDBKey<Object, Object>();
                dKey.setHashKey(this.getHashFromObj(resultObj));
                dKey.setRangeKey(this.getRangeKeyFromObj(resultObj));
                this.delete(dKey);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error("Illegal argument detected", (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Illegal access detected", (Object)e.getMessage());
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
        return deletes.size();
    }

    public Result<K, T> execute(Query<K, T> query) {
        DynamoDBQuery<K, T> dynamoDBQuery = this.buildDynamoDBQuery(query);
        DynamoDBMapper mapper = new DynamoDBMapper(this.dynamoDBStoreHandler.getDynamoDbClient());
        PaginatedScanList objList = null;
        if (DynamoDBQuery.getType().equals("range")) {
            objList = mapper.scan(this.persistentClass, (DynamoDBScanExpression)dynamoDBQuery.getQueryExpression());
        }
        if (DynamoDBQuery.getType().equals("scan")) {
            objList = mapper.scan(this.persistentClass, (DynamoDBScanExpression)dynamoDBQuery.getQueryExpression());
        }
        return new DynamoDBResult<K, T>(this, query, objList);
    }

    public T get(K key, String[] fields) {
        return null;
    }

    public T get(K key) {
        Persistent object;
        block6: {
            object = null;
            try {
                Object rangeKey = this.getRangeKeyFromKey(key);
                Object hashKey = this.getHashFromKey(key);
                if (hashKey != null) {
                    DynamoDBMapper mapper = new DynamoDBMapper(this.dynamoDBStoreHandler.getDynamoDbClient());
                    object = rangeKey != null ? (Persistent)mapper.load(this.persistentClass, hashKey, rangeKey) : (Persistent)mapper.load(this.persistentClass, hashKey);
                    break block6;
                }
                throw new GoraException("Error while retrieving keys from object: " + key.toString());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Illegal argument detected", (Object)e.getMessage());
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Illegal access detected", (Object)e.getMessage());
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (GoraException ge) {
                LOG.error(ge.getMessage());
                LOG.error(ge.getStackTrace().toString());
            }
        }
        return (T)object;
    }

    public Query<K, T> newQuery() {
        DynamoDBQuery query = new DynamoDBQuery(this);
        return query;
    }

    public K newKey() {
        return null;
    }

    public T newPersistent() {
        Persistent obj = null;
        try {
            obj = (Persistent)this.persistentClass.newInstance();
        }
        catch (InstantiationException e) {
            LOG.error("Error instantiating " + this.persistentClass.getCanonicalName());
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOG.error("Error instantiating " + this.persistentClass.getCanonicalName());
            throw new IllegalAccessError(e.getMessage());
        }
        return (T)obj;
    }

    public void put(K key, T obj) {
        try {
            DynamoDBMapper mapper;
            Object hashKey = this.getHashKey(key, obj);
            Object rangeKey = this.getRangeKey(key, obj);
            if (hashKey != null) {
                mapper = new DynamoDBMapper(this.dynamoDBStoreHandler.getDynamoDbClient());
                if (rangeKey != null) {
                    mapper.load(this.persistentClass, hashKey, rangeKey);
                } else {
                    mapper.load(this.persistentClass, hashKey);
                }
            } else {
                throw new GoraException("No HashKey found in Key nor in Object.");
            }
            mapper.save(obj);
        }
        catch (NullPointerException npe) {
            LOG.error("Error while putting an item. " + npe.toString());
            throw new NullArgumentException(npe.getMessage());
        }
        catch (Exception e) {
            LOG.error("Error while putting an item. " + obj.toString());
            throw new RuntimeException(e);
        }
    }

    public boolean delete(K key) {
        try {
            Object[] params;
            Persistent object = null;
            Object rangeKey = null;
            Object hashKey = null;
            DynamoDBMapper mapper = new DynamoDBMapper(this.dynamoDBStoreHandler.getDynamoDbClient());
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals(GET_RANGE_KEY_METHOD)) continue;
                params = null;
                rangeKey = met.invoke(key, params);
                break;
            }
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals(GET_HASH_KEY_METHOD)) continue;
                params = null;
                hashKey = met.invoke(key, params);
                break;
            }
            if (hashKey == null) {
                object = (Persistent)mapper.load(this.persistentClass, key);
            }
            if ((object = rangeKey == null ? (Persistent)mapper.load(this.persistentClass, hashKey) : (Persistent)mapper.load(this.persistentClass, hashKey, rangeKey)) == null) {
                return false;
            }
            mapper.delete((Object)object);
            return true;
        }
        catch (Exception e) {
            LOG.error("Error while deleting value with key " + key.toString());
            LOG.error(e.getMessage());
            return false;
        }
    }

    public void initialize(Class<K> keyClass, Class<T> pPersistentClass, Properties properties) {
        super.initialize(keyClass, pPersistentClass, properties);
        this.setWsProvider("amazon.web.services");
        if (this.autoCreateSchema) {
            this.createSchema();
        }
    }

    private DynamoDBQuery<K, T> buildDynamoDBQuery(Query<K, T> query) {
        if (this.getSchemaName() == null) {
            throw new IllegalStateException("There is not a preferred schema set.");
        }
        DynamoDBQuery<K, T> dynamoDBQuery = new DynamoDBQuery<K, T>();
        dynamoDBQuery.setKeySchema(this.dynamoDBStoreHandler.getDynamoDbMapping().getKeySchema(this.getSchemaName()));
        dynamoDBQuery.setKeyItems(this.dynamoDBStoreHandler.getDynamoDbMapping().getItems(this.getSchemaName()));
        dynamoDBQuery.setQuery(query);
        dynamoDBQuery.setConsistencyReadLevel(this.dynamoDBStoreHandler.getConsistencyReads());
        dynamoDBQuery.buildExpression();
        return dynamoDBQuery;
    }

    public void close() {
    }

    public void flush() {
        LOG.warn("DynamoDBNativeStore puts and gets directly into the datastore");
    }

    public BeanFactory<K, T> getBeanFactory() {
        return null;
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> arg0) throws IOException {
        return null;
    }

    public void setBeanFactory(BeanFactory<K, T> arg0) {
    }

    public void createSchema() {
        LOG.info("Creating Native DynamoDB Schemas.");
        if (this.dynamoDBStoreHandler.getDynamoDbMapping().getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        if (this.dynamoDBStoreHandler.getPreferredSchema() == null) {
            LOG.debug("Creating schemas.");
            for (String tableName : this.dynamoDBStoreHandler.getDynamoDbMapping().getTables().keySet()) {
                DynamoDBUtils.executeCreateTableRequest(this.dynamoDBStoreHandler.getDynamoDbClient(), tableName, this.dynamoDBStoreHandler.getTableKeySchema(tableName), this.dynamoDBStoreHandler.getTableAttributes(tableName), this.dynamoDBStoreHandler.getTableProvisionedThroughput(tableName));
            }
            LOG.debug("tables created successfully.");
        } else {
            String tableName = this.dynamoDBStoreHandler.getPreferredSchema();
            LOG.debug("Creating schema " + tableName);
            DynamoDBUtils.executeCreateTableRequest(this.dynamoDBStoreHandler.getDynamoDbClient(), tableName, this.dynamoDBStoreHandler.getTableKeySchema(tableName), this.dynamoDBStoreHandler.getTableAttributes(tableName), this.dynamoDBStoreHandler.getTableProvisionedThroughput(tableName));
        }
    }

    @Override
    public void setDynamoDBStoreHandler(DynamoDBStore<K, T> dynamoHandler) {
        this.dynamoDBStoreHandler = dynamoHandler;
    }

    public void deleteSchema() {
    }

    public String getSchemaName() {
        return this.dynamoDBStoreHandler.getSchemaName();
    }

    public boolean schemaExists() {
        return this.dynamoDBStoreHandler.schemaExists();
    }

    private Object getHashKey(K key, T obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object hashKey = this.getHashFromKey(key);
        if (hashKey == null) {
            hashKey = this.getHashFromObj(obj);
        }
        if (hashKey == null) {
            hashKey = key;
        }
        return hashKey;
    }

    private Object getHashFromKey(K obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object hashKey = null;
        if (obj instanceof DynamoDBKey) {
            hashKey = ((DynamoDBKey)obj).getHashKey();
        } else {
            for (Method met : obj.getClass().getDeclaredMethods()) {
                if (!met.getName().equals(GET_HASH_KEY_METHOD)) continue;
                Object[] params = null;
                hashKey = met.invoke(obj, params);
                break;
            }
        }
        return hashKey;
    }

    private Object getHashFromObj(T obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object hashKey = null;
        if (obj instanceof DynamoDBKey) {
            hashKey = ((DynamoDBKey)obj).getHashKey();
        } else {
            for (Method met : obj.getClass().getDeclaredMethods()) {
                if (!met.getName().equals(GET_HASH_KEY_METHOD)) continue;
                Object[] params = null;
                hashKey = met.invoke(obj, params);
                break;
            }
        }
        return hashKey;
    }

    private Object getRangeKey(K key, T obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object rangeKey = this.getRangeKeyFromKey(key);
        if (rangeKey == null) {
            rangeKey = this.getRangeKeyFromObj(obj);
        }
        return rangeKey;
    }

    private Object getRangeKeyFromKey(K obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object rangeKey = null;
        if (obj instanceof DynamoDBKey) {
            rangeKey = ((DynamoDBKey)obj).getRangeKey();
        } else {
            for (Method met : obj.getClass().getDeclaredMethods()) {
                if (!met.getName().equals(GET_RANGE_KEY_METHOD)) continue;
                Object[] params = null;
                rangeKey = met.invoke(obj, params);
                break;
            }
        }
        return rangeKey;
    }

    private Object getRangeKeyFromObj(T obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object rangeKey = null;
        if (obj instanceof DynamoDBKey) {
            rangeKey = ((DynamoDBKey)obj).getRangeKey();
        } else {
            for (Method met : obj.getClass().getDeclaredMethods()) {
                if (!met.getName().equals(GET_RANGE_KEY_METHOD)) continue;
                Object[] params = null;
                rangeKey = met.invoke(obj, params);
                break;
            }
        }
        return rangeKey;
    }
}

