/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.gora.filter.Filter;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.ws.impl.QueryWSBase;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBQuery<K, T extends Persistent>
extends QueryWSBase<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBQuery.class);
    private boolean consistencyReadLevel;
    private static ComparisonOperator rangeCompOp;
    private static ComparisonOperator scanCompOp;
    public static final String RANGE_QUERY = "range";
    public static final String SCAN_QUERY = "scan";
    public static final ComparisonOperator DEFAULT_SCAN_OP;
    private static String type;
    private Query<K, T> query;
    private Object dynamoDBExpression;
    private ArrayList<KeySchemaElement> keySchema;
    private K hashKey;
    private Map<String, String> keyItems;

    public DynamoDBQuery() {
        super(null);
    }

    public DynamoDBQuery(DataStore<K, T> dataStore) {
        super(dataStore);
    }

    public void setKey(K key) {
        this.hashKey = key;
    }

    public K getKey() {
        return this.hashKey;
    }

    private void defineQueryParams() {
        if ((this.query.getStartKey() != null || this.query.getKey() != null) && this.query.getEndKey() != null) {
            DynamoDBQuery.setType(RANGE_QUERY);
        } else if (this.query.getKey() != null || this.query.getStartKey() != null) {
            DynamoDBQuery.setType(SCAN_QUERY);
        }
    }

    public void buildExpression() {
        this.defineQueryParams();
        if (DynamoDBQuery.getType().equals(RANGE_QUERY)) {
            this.buildRangeExpression();
        } else if (DynamoDBQuery.getType().equals(SCAN_QUERY)) {
            this.buildScanExpression();
        } else {
            throw new IllegalArgumentException("Query type not supported");
        }
    }

    private Map<String, AttributeValue> buildHashKey(K qKey) {
        HashMap<String, AttributeValue> hashKey = new HashMap<String, AttributeValue>();
        for (KeySchemaElement key : this.getKeySchema()) {
            AttributeValue attr = new AttributeValue();
            if (!key.getKeyType().equals(KeyType.HASH.toString())) continue;
            if (this.keyItems.get(key.getAttributeName()).equals("N")) {
                attr.withN(this.getHashKey(qKey).toString());
            } else if (this.keyItems.get(key.getAttributeName()).equals("S")) {
                attr.withS(this.getHashKey(qKey).toString());
            } else if (this.keyItems.get(key.getAttributeName()).equals("B")) {
                attr.withB(ByteBuffer.wrap(this.getHashKey(qKey).toString().getBytes(Charset.defaultCharset())));
            } else {
                throw new IllegalArgumentException("Data type not supported for " + key.getAttributeName());
            }
            hashKey.put(key.getAttributeName(), attr);
        }
        if (hashKey.isEmpty()) {
            throw new IllegalStateException("No key value has been defined.");
        }
        return hashKey;
    }

    private Map<String, AttributeValue> buildRangeKey(K qKey) {
        HashMap<String, AttributeValue> kAttrs = new HashMap<String, AttributeValue>();
        for (KeySchemaElement key : this.getKeySchema()) {
            AttributeValue attr = new AttributeValue();
            if (!key.getKeyType().equals(KeyType.RANGE.toString())) continue;
            if (this.keyItems.get(key.getAttributeName()).equals("N")) {
                attr.withN(this.getRangeKey(qKey).toString());
            } else if (this.keyItems.get(key.getAttributeName()).equals("S")) {
                attr.withS(this.getRangeKey(qKey).toString());
            } else if (this.keyItems.get(key.getAttributeName()).equals("B")) {
                attr.withB(ByteBuffer.wrap(this.getRangeKey(qKey).toString().getBytes(Charset.defaultCharset())));
            } else {
                throw new IllegalArgumentException("Data type not supported for " + key.getAttributeName());
            }
            kAttrs.put(key.getAttributeName(), attr);
        }
        return kAttrs;
    }

    public void buildScanExpression() {
        Object qKey = this.getKey();
        if (qKey == null) {
            LOG.warn("No key defined. Trying with startKey.");
            qKey = this.query.getStartKey();
            if (qKey == null) {
                throw new IllegalStateException("No key has been defined please check");
            }
        }
        ComparisonOperator compOp = DynamoDBQuery.getScanCompOp() != null ? DynamoDBQuery.getScanCompOp() : DEFAULT_SCAN_OP;
        DynamoDBScanExpression newScanExpression = new DynamoDBScanExpression();
        Map<String, AttributeValue> hashAttrVals = this.buildHashKey(qKey);
        for (Map.Entry<String, AttributeValue> en : hashAttrVals.entrySet()) {
            Condition scanFilterHashCondition = new Condition().withComparisonOperator(compOp.toString()).withAttributeValueList(new AttributeValue[]{en.getValue()});
            newScanExpression.addFilterCondition(en.getKey(), scanFilterHashCondition);
        }
        Map<String, AttributeValue> rangeAttrVals = this.buildRangeKey(qKey);
        for (Map.Entry<String, AttributeValue> en : rangeAttrVals.entrySet()) {
            Condition scanFilterRangeCondition = new Condition().withComparisonOperator(compOp.toString()).withAttributeValueList(new AttributeValue[]{en.getValue()});
            newScanExpression.addFilterCondition(en.getKey(), scanFilterRangeCondition);
        }
        this.dynamoDBExpression = newScanExpression;
    }

    public void buildRangeExpression() {
        DynamoDBScanExpression queryExpression = new DynamoDBScanExpression();
        ComparisonOperator compOp = ComparisonOperator.BETWEEN;
        Map<String, AttributeValue> hashAttrVals = this.buildHashKey(this.query.getStartKey());
        Map<String, AttributeValue> endHashAttrVals = this.buildHashKey(this.query.getEndKey());
        for (Map.Entry<String, AttributeValue> en : hashAttrVals.entrySet()) {
            Condition scanFilterHashCondition = new Condition().withComparisonOperator(compOp.toString()).withAttributeValueList(new AttributeValue[]{en.getValue(), endHashAttrVals.get(en.getKey())});
            queryExpression.addFilterCondition(en.getKey(), scanFilterHashCondition);
        }
        Map<String, AttributeValue> rangeAttrVals = this.buildRangeKey(this.query.getStartKey());
        Map<String, AttributeValue> endRangeAttrVals = this.buildRangeKey(this.query.getEndKey());
        for (Map.Entry<String, AttributeValue> en : rangeAttrVals.entrySet()) {
            Condition scanFilterRangeCondition = new Condition().withComparisonOperator(compOp.toString()).withAttributeValueList(new AttributeValue[]{en.getValue(), endRangeAttrVals.get(en.getKey())});
            queryExpression.addFilterCondition(en.getKey(), scanFilterRangeCondition);
        }
        this.dynamoDBExpression = queryExpression;
    }

    private Object getHashKey(K key) {
        Object hashKey = null;
        try {
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals("getHashKey")) continue;
                Object[] params = null;
                hashKey = met.invoke(key, params);
                break;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.", (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return hashKey;
    }

    private Object getRangeKey(K key) {
        Object rangeKey = null;
        try {
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals("getRangeKey")) continue;
                Object[] params = null;
                rangeKey = met.invoke(key, params);
                break;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.", (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return rangeKey;
    }

    public boolean getConsistencyReadLevel() {
        return this.consistencyReadLevel;
    }

    public void setConsistencyReadLevel(boolean pConsistencyReadLevel) {
        this.consistencyReadLevel = pConsistencyReadLevel;
    }

    public ArrayList<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public Object getQueryExpression() {
        return this.dynamoDBExpression;
    }

    public void setKeySchema(ArrayList<KeySchemaElement> arrayList) {
        this.keySchema = arrayList;
    }

    public void setQuery(Query<K, T> pQuery) {
        this.setStartKey(this.query.getStartKey());
        this.setEndKey(this.query.getEndKey());
    }

    public Query<K, T> getQuery() {
        return this.query;
    }

    public static String getType() {
        return type;
    }

    public static void setType(String pType) {
        type = pType;
    }

    public static ComparisonOperator getScanCompOp() {
        return scanCompOp;
    }

    public static void setScanCompOp(ComparisonOperator scanCompOp) {
        DynamoDBQuery.scanCompOp = scanCompOp;
    }

    public static ComparisonOperator getRangeCompOp() {
        if (rangeCompOp == null) {
            rangeCompOp = ComparisonOperator.BETWEEN;
        }
        return rangeCompOp;
    }

    public static void setRangeCompOp(ComparisonOperator pRangeCompOp) {
        rangeCompOp = pRangeCompOp;
    }

    public void setKeyItems(Map<String, String> items) {
        this.keyItems = items;
    }

    public void setFilter(Filter<K, T> filter) {
    }

    public Filter<K, T> getFilter() {
        return null;
    }

    public void setLocalFilterEnabled(boolean enable) {
    }

    public boolean isLocalFilterEnabled() {
        return false;
    }

    static {
        DEFAULT_SCAN_OP = ComparisonOperator.GE;
    }
}

