/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.compiler;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.gora.dynamodb.store.DynamoDBMapping;
import org.apache.gora.util.GoraException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoraDynamoDBCompiler {
    private File dest;
    private Writer out;
    private static final Logger log = LoggerFactory.getLogger(GoraDynamoDBCompiler.class);
    private String packageName;

    private GoraDynamoDBCompiler(File dest) {
        this.dest = dest;
    }

    public static void compileSchema(File src, File dest) throws IOException {
        log.info("Compiling {} to {}", (Object)src, (Object)dest);
        GoraDynamoDBCompiler compiler = new GoraDynamoDBCompiler(dest);
        DynamoDBMapping dynamoDBMap = compiler.readMapping(src);
        if (dynamoDBMap.getTables().isEmpty()) {
            throw new IllegalStateException("There are no tables defined.");
        }
        for (String tableName : dynamoDBMap.getTables().keySet()) {
            compiler.compile(tableName, dynamoDBMap.getKeySchema(tableName), dynamoDBMap.getItems(tableName));
            log.info("{} written without issues to {}", (Object)tableName, (Object)dest.getAbsolutePath());
        }
    }

    private void compile(String pTableName, ArrayList<KeySchemaElement> arrayList, Map<String, String> map) {
        try {
            this.startFile(pTableName, pTableName);
            this.setHeaders(this.packageName);
            this.line(0, "");
            this.line(0, "@DynamoDBTable(tableName = \"" + pTableName + "\")");
            this.line(0, "public class " + pTableName + " implements Persistent {");
            for (KeySchemaElement pKeySchema : arrayList) {
                this.setKeyAttributes(pKeySchema, map.get(pKeySchema.getAttributeName()), 2);
                this.setKeyMethods(pKeySchema, map.get(pKeySchema.getAttributeName()), 2);
                map.remove(pKeySchema.getAttributeName());
            }
            this.setItems(map, 2);
            this.setDefaultMethods(2, pTableName);
            this.line(0, "}");
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            log.error("Error while compiling table {}", (Object)pTableName, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void setItems(Map<String, String> pItems, int pIden) throws IOException {
        for (String itemName : pItems.keySet()) {
            String itemType = "String";
            if (pItems.get(itemName).toString().equals("N")) {
                itemType = "double";
            }
            if (pItems.get(itemName).toString().equals("SS")) {
                itemType = "Set<String>";
            }
            if (pItems.get(itemName).toString().equals("SN")) {
                itemType = "Set<double>";
            }
            this.line(pIden, "private " + itemType + " " + itemName + ";");
            this.setItemMethods(itemName, itemType, pIden);
        }
        this.line(0, "");
    }

    private void setItemMethods(String pItemName, String pItemType, int pIden) throws IOException {
        this.line(pIden, "@DynamoDBAttribute(attributeName = \"" + GoraDynamoDBCompiler.camelCasify(pItemName) + "\")");
        this.line(pIden, "public " + pItemType + " get" + GoraDynamoDBCompiler.camelCasify(pItemName) + "() {  return " + pItemName + ";  }");
        this.line(pIden, "public void set" + GoraDynamoDBCompiler.camelCasify(pItemName) + "(" + pItemType + " p" + GoraDynamoDBCompiler.camelCasify(pItemName) + ") {  this." + pItemName + " = p" + GoraDynamoDBCompiler.camelCasify(pItemName) + ";  }");
        this.line(0, "");
    }

    private void setKeyMethods(KeySchemaElement pKeySchema, String attType, int pIden) throws IOException {
        StringBuilder strBuilder = new StringBuilder();
        String string = attType = attType.equals("S") ? "String" : "double";
        if (pKeySchema.getKeyType().equals(KeyType.HASH.toString())) {
            strBuilder.append("@DynamoDBHashKey(attributeName=\"" + pKeySchema.getAttributeName() + "\") \n");
            strBuilder.append("    public " + attType + " getHashKey() {  return " + pKeySchema.getAttributeName() + "; } \n");
            strBuilder.append("    public void setHashKey(" + attType + " ");
            strBuilder.append("p" + GoraDynamoDBCompiler.camelCasify(pKeySchema.getAttributeName()) + "){  this." + pKeySchema.getAttributeName());
            strBuilder.append(" = p" + GoraDynamoDBCompiler.camelCasify(pKeySchema.getAttributeName()) + "; }");
            this.line(pIden, strBuilder.toString());
        }
        strBuilder.delete(0, strBuilder.length());
        if (pKeySchema.getKeyType().equals(KeyType.RANGE.toString())) {
            strBuilder.append("@DynamoDBRangeKey(attributeName=\"" + pKeySchema.getAttributeName() + "\") \n");
            strBuilder.append("    public " + attType + " getRangeKey() { return " + pKeySchema.getAttributeName() + "; } \n");
            strBuilder.append("    public void setRangeKey(" + attType + " ");
            strBuilder.append("p" + GoraDynamoDBCompiler.camelCasify(pKeySchema.getAttributeName()) + "){  this." + pKeySchema.getAttributeName());
            strBuilder.append(" = p" + GoraDynamoDBCompiler.camelCasify(pKeySchema.getAttributeName()) + "; }");
            this.line(pIden, strBuilder.toString());
        }
        this.line(0, "");
    }

    private void setKeyAttributes(KeySchemaElement pKeySchema, String attType, int pIden) throws IOException {
        StringBuilder strBuilder = new StringBuilder();
        String string = attType = attType.equals("S") ? "String " : "double ";
        if (pKeySchema != null) {
            strBuilder.append("private " + attType);
            strBuilder.append(pKeySchema.getAttributeName() + ";");
            this.line(pIden, strBuilder.toString());
        }
        strBuilder.delete(0, strBuilder.length());
        this.line(0, "");
    }

    private static String camelCasify(String s) {
        return s.substring(0, 1).toUpperCase(Locale.getDefault()) + s.substring(1);
    }

    private void startFile(String name, String space) throws IOException {
        String fullDest = FilenameUtils.normalize((String)(this.dest.getAbsolutePath() + File.separatorChar + this.packageName.replace('.', File.separatorChar)));
        File dir = new File(fullDest);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create " + dir);
        }
        name = GoraDynamoDBCompiler.cap(name) + ".java";
        this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, name)), Charset.defaultCharset());
    }

    private void setHeaders(String namespace) throws IOException {
        if (namespace != null) {
            this.line(0, "package " + namespace + ";\n");
        }
        this.line(0, "import java.util.List;");
        this.line(0, "import java.util.Set;");
        this.line(0, "");
        this.line(0, "import org.apache.avro.Schema.Field;");
        this.line(0, "import org.apache.gora.persistency.Persistent;");
        this.line(0, "import org.apache.gora.persistency.Tombstone;");
        this.line(0, "import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;");
        this.line(0, "import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;");
        this.line(0, "import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;");
        this.line(0, "import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;");
    }

    private void setDefaultMethods(int pIden, String tabName) throws IOException {
        this.line(pIden, "public void setNew(boolean pNew){}");
        this.line(pIden, "public void setDirty(boolean pDirty){}");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clear() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public " + tabName + " clone() { return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isDirty() { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isDirty(int fieldIndex) { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isDirty(String field) { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setDirty() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setDirty(int fieldIndex) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setDirty(String field) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearDirty(int fieldIndex) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearDirty(String field) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearDirty() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public Tombstone getTombstone() { return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public List<Field> getUnmanagedFields() { return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public Persistent newInstance() { return new " + tabName + "(); }");
    }

    private void line(int indent, String text) throws IOException {
        for (int i = 0; i < indent; ++i) {
            this.out.append("  ");
        }
        this.out.append(text);
        this.out.append("\n");
    }

    static String cap(String name) {
        return name.substring(0, 1).toUpperCase(Locale.getDefault()) + name.substring(1, name.length());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                log.error("Usage: Compiler <schema file> <output dir>");
                System.exit(1);
            }
            GoraDynamoDBCompiler.compileSchema(new File(args[0]), new File(args[1]));
        }
        catch (Exception e) {
            log.error("Something went wrong. Please check the input file.", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private DynamoDBMapping readMapping(File pMapFile) throws IOException {
        DynamoDBMapping.DynamoDBMappingBuilder mappingBuilder = new DynamoDBMapping.DynamoDBMappingBuilder();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(pMapFile);
            if (doc == null || doc.getRootElement() == null) {
                throw new GoraException("Unable to load gora-dynamodb-mapping.xml. Please check its existance!");
            }
            Element root = doc.getRootElement();
            List tableElements = root.getChildren("table");
            boolean keys = false;
            for (Element tableElement : tableElements) {
                String tableName = tableElement.getAttributeValue("name");
                long readCapacUnits = Long.parseLong(tableElement.getAttributeValue("readcunit"));
                long writeCapacUnits = Long.parseLong(tableElement.getAttributeValue("writecunit"));
                this.packageName = tableElement.getAttributeValue("package");
                mappingBuilder.setProvisionedThroughput(tableName, readCapacUnits, writeCapacUnits);
                log.debug("Table properties have been set for name, package and provisioned throughput.");
                List fieldElements = tableElement.getChildren("attribute");
                for (Element fieldElement : fieldElements) {
                    String key = fieldElement.getAttributeValue("key");
                    String attributeName = fieldElement.getAttributeValue("name");
                    String attributeType = fieldElement.getAttributeValue("type");
                    mappingBuilder.addAttribute(tableName, attributeName, attributeType);
                    if (key == null) continue;
                    mappingBuilder.setKeySchema(tableName, attributeName, key);
                    keys = true;
                }
                log.debug("Attributes for table '{}' have been read.", (Object)tableName);
                if (keys) continue;
                log.warn("Keys for table '{}' have NOT been set.", (Object)tableName);
            }
        }
        catch (IOException ex) {
            log.error("Error while performing xml mapping.", (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            log.error("An error occured whilst reading the xml mapping file!", (Object)ex.getMessage());
            throw new IOException(ex);
        }
        return mappingBuilder.build();
    }
}

