/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gora.dynamodb.store.DynamoDBFactory;
import org.apache.gora.dynamodb.store.DynamoDBMapping;
import org.apache.gora.dynamodb.store.DynamoDBUtils;
import org.apache.gora.dynamodb.store.IDynamoDB;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBStore<K, T extends Persistent>
implements DataStore<K, T> {
    private IDynamoDB<K, T> dynamoDbStore;
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBStore.class);
    private DynamoDBMapping mapping;
    private AmazonDynamoDB dynamoDBClient;
    private String consistency;
    private DynamoDBUtils.DynamoDBType serializationType;
    private String preferredSchema;

    public void close() {
        this.dynamoDbStore.close();
    }

    public void createSchema() {
        this.dynamoDbStore.createSchema();
    }

    public boolean delete(K key) {
        return this.dynamoDbStore.delete(key);
    }

    public long deleteByQuery(Query<K, T> query) {
        return this.dynamoDbStore.deleteByQuery(query);
    }

    public void deleteSchema() {
        if (this.getDynamoDbMapping().getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        if (this.preferredSchema == null) {
            LOG.debug("Delete schemas");
            if (this.getDynamoDbMapping().getTables().isEmpty()) {
                throw new IllegalStateException("There are not tables defined.");
            }
            for (String tableName : this.getDynamoDbMapping().getTables().keySet()) {
                this.executeDeleteTableRequest(tableName);
            }
            LOG.debug("All schemas deleted successfully.");
        } else {
            LOG.debug("create schema " + this.preferredSchema);
            this.executeDeleteTableRequest(this.preferredSchema);
        }
    }

    public Result<K, T> execute(Query<K, T> query) {
        return this.dynamoDbStore.execute(query);
    }

    public void flush() {
        this.dynamoDbStore.flush();
    }

    public T get(K key) {
        return (T)this.dynamoDbStore.get(key);
    }

    public T get(K key, String[] fields) {
        return (T)this.dynamoDbStore.get(key, fields);
    }

    public BeanFactory<K, T> getBeanFactory() {
        return null;
    }

    public Class<K> getKeyClass() {
        return null;
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> arg0) throws IOException {
        return null;
    }

    public Class<T> getPersistentClass() {
        return null;
    }

    public String getSchemaName() {
        return this.getPreferredSchema();
    }

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        try {
            LOG.debug("Initializing DynamoDB store");
            this.setDynamoDBProperties(properties);
            this.dynamoDbStore = DynamoDBFactory.buildDynamoDBStore(this.getSerializationType());
            this.dynamoDbStore.setDynamoDBStoreHandler(this);
            this.dynamoDbStore.initialize(keyClass, persistentClass, properties);
        }
        catch (Exception e) {
            LOG.error("Error while initializing DynamoDB store", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void setDynamoDBProperties(Properties properties) throws IOException {
        this.setSerializationType(properties.getProperty("gora.dynamodb.serialization.type"));
        PropertiesCredentials creds = DynamoDBUtils.getCredentials(this.getClass());
        this.setPreferredSchema(properties.getProperty("preferred.schema.name"));
        this.setDynamoDBClient(DynamoDBUtils.getClient(properties.getProperty("gora.dynamodb.client"), (AWSCredentials)creds));
        this.getDynamoDBClient().setEndpoint(properties.getProperty("gora.dynamodb.endpoint"));
        this.setDynamoDbMapping(this.readMapping());
        this.setConsistency(properties.getProperty("gora.dynamodb.consistent.reads"));
    }

    public K newKey() {
        return (K)this.dynamoDbStore.newKey();
    }

    public T newPersistent() {
        return (T)this.dynamoDbStore.newPersistent();
    }

    public Query<K, T> newQuery() {
        return this.dynamoDbStore.newQuery();
    }

    public void put(K key, T value) {
        this.dynamoDbStore.put(key, (Persistent)value);
    }

    public boolean schemaExists() {
        LOG.info("Verifying schemas.");
        TableDescription success = null;
        if (this.getDynamoDbMapping().getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        if (this.getPreferredSchema() == null) {
            LOG.debug("Verifying schemas");
            if (this.getDynamoDbMapping().getTables().isEmpty()) {
                throw new IllegalStateException("There are not tables defined.");
            }
            for (String tableName : this.getDynamoDbMapping().getTables().keySet()) {
                success = this.getTableSchema(tableName);
                if (success != null) continue;
                return false;
            }
        } else {
            LOG.info("Verifying schema " + this.preferredSchema);
            success = this.getTableSchema(this.preferredSchema);
        }
        LOG.info("Finished verifying schemas.");
        return success != null;
    }

    public void setBeanFactory(BeanFactory<K, T> arg0) {
    }

    public void setKeyClass(Class<K> arg0) {
        this.dynamoDbStore.setKeyClass(arg0);
    }

    public void setPersistentClass(Class<T> arg0) {
        this.dynamoDbStore.setPersistentClass(arg0);
    }

    public void truncateSchema() {
    }

    private DynamoDBMapping readMapping() throws IOException {
        DynamoDBMapping.DynamoDBMappingBuilder mappingBuilder = new DynamoDBMapping.DynamoDBMappingBuilder();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.getClass().getClassLoader().getResourceAsStream("gora-dynamodb-mapping.xml"));
            if (doc == null || doc.getRootElement() == null) {
                throw new GoraException("Unable to load gora-dynamodb-mapping.xml. Please check its existance!");
            }
            Element root = doc.getRootElement();
            List tableElements = root.getChildren("table");
            boolean keys = false;
            for (Element tableElement : tableElements) {
                String tableName = tableElement.getAttributeValue("name");
                long readCapacUnits = Long.parseLong(tableElement.getAttributeValue("readcunit"));
                long writeCapacUnits = Long.parseLong(tableElement.getAttributeValue("writecunit"));
                mappingBuilder.setProvisionedThroughput(tableName, readCapacUnits, writeCapacUnits);
                LOG.debug("Basic table properties have been set: Name, and Provisioned throughput.");
                List fieldElements = tableElement.getChildren("attribute");
                for (Element fieldElement : fieldElements) {
                    String key = fieldElement.getAttributeValue("key");
                    String attributeName = fieldElement.getAttributeValue("name");
                    String attributeType = fieldElement.getAttributeValue("type");
                    mappingBuilder.addAttribute(tableName, attributeName, attributeType);
                    if (key == null) continue;
                    mappingBuilder.setKeySchema(tableName, attributeName, key);
                    keys = true;
                }
                LOG.debug("Attributes for table '" + tableName + "' have been read.");
                if (keys) continue;
                LOG.warn("Keys for table '" + tableName + "' have NOT been set.");
            }
        }
        catch (IOException ex) {
            LOG.error("Error while performing xml mapping.", (Object)ex.getMessage());
            throw new IOException(ex);
        }
        catch (Exception ex) {
            LOG.error("Error while performing xml mapping.", (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
        return mappingBuilder.build();
    }

    public void executeDeleteTableRequest(String pTableName) {
        try {
            DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withTableName(pTableName);
            DeleteTableResult result = this.getDynamoDBClient().deleteTable(deleteTableRequest);
            this.waitForTableToBeDeleted(pTableName);
            LOG.debug("Schema: " + result.getTableDescription() + " deleted successfully.");
        }
        catch (Exception e) {
            LOG.debug("Schema: {} deleted.", (Object)pTableName, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void waitForTableToBeDeleted(String pTableName) {
        LOG.debug("Waiting for " + pTableName + " to be deleted.");
        long startTime = System.currentTimeMillis();
        long endTime = startTime + DynamoDBUtils.WAIT_TIME;
        while (System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(DynamoDBUtils.SLEEP_DELETE_TIME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                DescribeTableRequest request = new DescribeTableRequest().withTableName(pTableName);
                TableDescription tableDescription = this.getDynamoDBClient().describeTable(request).getTable();
                String tableStatus = tableDescription.getTableStatus();
                LOG.debug(pTableName + " - current state: " + tableStatus);
            }
            catch (AmazonServiceException ase) {
                if (ase.getErrorCode().equalsIgnoreCase("ResourceNotFoundException")) {
                    return;
                }
                LOG.error(ase.getMessage());
            }
        }
        LOG.debug(pTableName + " deleted.");
    }

    private TableDescription getTableSchema(String tableName) {
        TableDescription tableDescription = null;
        try {
            DescribeTableRequest describeTableRequest = new DescribeTableRequest().withTableName(tableName);
            tableDescription = this.getDynamoDBClient().describeTable(describeTableRequest).getTable();
        }
        catch (ResourceNotFoundException e) {
            LOG.error("Error while getting table schema: " + tableName);
            return tableDescription;
        }
        return tableDescription;
    }

    public ArrayList<KeySchemaElement> getTableKeySchema(String tableName) {
        return this.getDynamoDbMapping().getKeySchema(tableName);
    }

    public ProvisionedThroughput getTableProvisionedThroughput(String tableName) {
        return this.getDynamoDbMapping().getProvisionedThroughput(tableName);
    }

    public Map<String, String> getTableAttributes(String tableName) {
        return this.getDynamoDbMapping().getItems(tableName);
    }

    public boolean getConsistencyReads() {
        return this.getConsistency() != null && this.getConsistency().equals("true");
    }

    public void setDynamoDbStore(IDynamoDB<K, T> iDynamoDB) {
        this.dynamoDbStore = iDynamoDB;
    }

    private void setSerializationType(String serializationType) {
        if (serializationType == null || serializationType.isEmpty() || serializationType.equals("avro")) {
            LOG.warn("Using AVRO serialization.");
            this.serializationType = DynamoDBUtils.DynamoDBType.AVRO;
        } else {
            LOG.warn("Using DynamoDB serialization.");
            this.serializationType = DynamoDBUtils.DynamoDBType.DYNAMO;
        }
    }

    private DynamoDBUtils.DynamoDBType getSerializationType() {
        return this.serializationType;
    }

    public String getPreferredSchema() {
        return this.preferredSchema;
    }

    public void setPreferredSchema(String preferredSchema) {
        this.preferredSchema = preferredSchema;
    }

    public AmazonDynamoDB getDynamoDbClient() {
        return this.getDynamoDBClient();
    }

    public DynamoDBMapping getDynamoDbMapping() {
        return this.mapping;
    }

    public void setDynamoDbMapping(DynamoDBMapping mapping) {
        this.mapping = mapping;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = consistency;
    }

    public AmazonDynamoDB getDynamoDBClient() {
        return this.dynamoDBClient;
    }

    public void setDynamoDBClient(AmazonDynamoDB dynamoDBClient) {
        this.dynamoDBClient = dynamoDBClient;
    }
}

