/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBMapping {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBMapping.class);
    private final Map<String, Map<String, String>> tablesToItems;
    private final Map<String, ArrayList<KeySchemaElement>> tablesToKeySchemas;
    private final Map<String, ProvisionedThroughput> tablesToPrTh;

    public DynamoDBMapping(Map<String, Map<String, String>> tablesToItems2, Map<String, ArrayList<KeySchemaElement>> tablesToKeySchemas, Map<String, ProvisionedThroughput> provisionedThroughput) {
        this.tablesToItems = tablesToItems2;
        this.tablesToKeySchemas = tablesToKeySchemas;
        this.tablesToPrTh = provisionedThroughput;
    }

    public Map<String, Map<String, String>> getTables() {
        return this.tablesToItems;
    }

    public Map<String, String> getItems(String tableName) {
        return this.tablesToItems.get(tableName);
    }

    public ArrayList<KeySchemaElement> getKeySchema(String tableName) {
        return this.tablesToKeySchemas.get(tableName);
    }

    public ProvisionedThroughput getProvisionedThroughput(String tableName) {
        return this.tablesToPrTh.get(tableName);
    }

    public static class DynamoDBMappingBuilder {
        private Map<String, Map<String, String>> tablesToItems = new HashMap<String, Map<String, String>>();
        private Map<String, ArrayList<KeySchemaElement>> tablesToKeySchemas = new HashMap<String, ArrayList<KeySchemaElement>>();
        private Map<String, ProvisionedThroughput> tablesToPrTh = new HashMap<String, ProvisionedThroughput>();

        public String getTableName(String tableName) {
            return tableName;
        }

        public void setProvisionedThroughput(String tableName, long readCapUnits, long writeCapUnits) {
            ProvisionedThroughput ptDesc = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCapUnits)).withWriteCapacityUnits(Long.valueOf(writeCapUnits));
        }

        public void setKeySchema(String tableName, String keyName, String keyType) {
            ArrayList<Object> kSchema = this.tablesToKeySchemas.get(tableName);
            if (kSchema == null) {
                kSchema = new ArrayList();
                this.tablesToKeySchemas.put(tableName, kSchema);
            }
            KeyType type = keyType.equals("hashrange") ? KeyType.RANGE : KeyType.HASH;
            kSchema.add(new KeySchemaElement().withAttributeName(keyName).withKeyType(type));
        }

        private Map<String, String> getOrCreateTable(String tableName) {
            Map<String, String> items = this.tablesToItems.get(tableName);
            if (items == null) {
                items = new HashMap<String, String>();
                this.tablesToItems.put(tableName, items);
            }
            return items;
        }

        public void addAttribute(String tableName, String attributeName, String attrType) {
            Map<String, String> items = this.getOrCreateTable(tableName);
            items.put(attributeName, attrType);
        }

        private boolean verifyAllKeySchemas() {
            boolean rsl = true;
            if (this.tablesToItems.isEmpty() || this.tablesToKeySchemas.isEmpty()) {
                rsl = false;
            }
            for (String tableName : this.tablesToItems.keySet()) {
                if (this.tablesToKeySchemas.get(tableName) == null) {
                    LOG.error("No schema defined for DynamoDB table '" + tableName + '\'');
                    rsl = false;
                }
                rsl = this.verifyKeySchema(tableName);
            }
            return rsl;
        }

        private boolean verifyKeySchema(String tableName) {
            ArrayList<KeySchemaElement> kSchema = this.tablesToKeySchemas.get(tableName);
            boolean hashPk = false;
            if (kSchema == null) {
                LOG.error("No keys defined for '{}'. Please check your schema!", (Object)tableName);
                return hashPk;
            }
            for (KeySchemaElement ks : kSchema) {
                if (!ks.getKeyType().equals(KeyType.HASH.toString())) continue;
                hashPk = true;
            }
            return hashPk;
        }

        public DynamoDBMapping build() {
            if (this.tablesToItems.isEmpty()) {
                throw new IllegalStateException("No tables were defined.");
            }
            if (!this.verifyAllKeySchemas()) {
                throw new IllegalStateException("no key schemas defined for table ");
            }
            return new DynamoDBMapping(this.tablesToItems, this.tablesToKeySchemas, this.tablesToPrTh);
        }
    }
}

