/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import org.apache.gora.dynamodb.store.DynamoDBAvroStore;
import org.apache.gora.dynamodb.store.DynamoDBNativeStore;
import org.apache.gora.dynamodb.store.DynamoDBUtils;
import org.apache.gora.dynamodb.store.IDynamoDB;
import org.apache.gora.persistency.Persistent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBFactory {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBFactory.class);

    public static <K, T extends Persistent> IDynamoDB<K, T> buildDynamoDBStore(DynamoDBUtils.DynamoDBType serType) {
        IDynamoDB ds;
        switch (serType) {
            case DYNAMO: {
                ds = new DynamoDBNativeStore();
                LOG.debug("Using DynamoDB based serialization mode.");
                break;
            }
            case AVRO: {
                ds = new DynamoDBAvroStore();
                LOG.debug("Using Avro based serialization mode.");
                break;
            }
            default: {
                throw new IllegalStateException("Serialization mode not supported.");
            }
        }
        return ds;
    }
}

