/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.query;

import java.io.IOException;
import java.util.List;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.ws.impl.ResultWSBase;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBResult<K, T extends Persistent>
extends ResultWSBase<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBResult.class);
    private List<T> dynamoDBResultSet;

    public DynamoDBResult(DataStore<K, T> dataStore, Query<K, T> query, List<T> objList) {
        super(dataStore, query);
        LOG.debug("DynamoDB result created.");
        this.setResultSet(objList);
    }

    public void setResultSet(List<T> objList) {
        this.dynamoDBResultSet = objList;
        this.limit = objList.size();
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.limit <= 0L || this.offset <= 0L) {
            return 0.0f;
        }
        return this.limit / this.offset;
    }

    protected boolean nextInner() throws Exception {
        if (this.offset < 0L || this.offset > (long)(this.dynamoDBResultSet.size() - 1)) {
            return false;
        }
        this.persistent = (Persistent)this.dynamoDBResultSet.get((int)this.offset);
        return true;
    }

    public void close() throws IOException {
    }
}

