/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.AmazonDynamoDBAsyncClient;
import com.amazonaws.services.dynamodb.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodb.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.amazonaws.services.dynamodb.model.DeleteTableRequest;
import com.amazonaws.services.dynamodb.model.DeleteTableResult;
import com.amazonaws.services.dynamodb.model.DescribeTableRequest;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodb.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodb.model.TableDescription;
import com.amazonaws.services.dynamodb.model.TableStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.gora.dynamodb.query.DynamoDBKey;
import org.apache.gora.dynamodb.query.DynamoDBQuery;
import org.apache.gora.dynamodb.query.DynamoDBResult;
import org.apache.gora.dynamodb.store.DynamoDBMapping;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.ws.impl.WSDataStoreBase;
import org.apache.gora.util.GoraException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBStore<K, T extends Persistent>
extends WSDataStoreBase<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBStore.class);
    private static String preferredSchema;
    private static final String MAPPING_FILE = "gora-dynamodb-mapping.xml";
    private static long waitTime;
    private static long sleepTime;
    private static long sleepDeleteTime;
    private static String awsCredentialsProperties;
    private static String wsProvider;
    private static String CLI_TYP_PROP;
    private static String ENDPOINT_PROP;
    private static String PREF_SCH_NAME;
    private static String CONSISTENCY_READS;
    private DynamoDBMapping mapping;
    private AmazonDynamoDB dynamoDBClient;
    private String consistency;
    Class<T> persistentClass;

    public void initialize(Class<K> keyClass, Class<T> pPersistentClass, Properties properties) {
        try {
            LOG.debug("Initializing DynamoDB store");
            this.getCredentials();
            this.setWsProvider(wsProvider);
            preferredSchema = properties.getProperty(PREF_SCH_NAME);
            this.dynamoDBClient = this.getClient(properties.getProperty(CLI_TYP_PROP), (AWSCredentials)this.getConf());
            this.dynamoDBClient.setEndpoint(properties.getProperty(ENDPOINT_PROP));
            this.mapping = this.readMapping();
            this.consistency = properties.getProperty(CONSISTENCY_READS);
            this.persistentClass = pPersistentClass;
        }
        catch (Exception e) {
            LOG.error("Error while initializing DynamoDB store");
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public AmazonDynamoDB getClient(String clientType, AWSCredentials credentials) {
        if (clientType.equals("sync")) {
            return new AmazonDynamoDBClient(credentials);
        }
        if (clientType.equals("async")) {
            return new AmazonDynamoDBAsyncClient(credentials);
        }
        return null;
    }

    private DynamoDBMapping readMapping() throws IOException {
        DynamoDBMapping.DynamoDBMappingBuilder mappingBuilder = new DynamoDBMapping.DynamoDBMappingBuilder();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(MAPPING_FILE));
            Element root = doc.getRootElement();
            List tableElements = root.getChildren("table");
            for (Element tableElement : tableElements) {
                String tableName = tableElement.getAttributeValue("name");
                long readCapacUnits = Long.parseLong(tableElement.getAttributeValue("readcunit"));
                long writeCapacUnits = Long.parseLong(tableElement.getAttributeValue("readcunit"));
                mappingBuilder.setTableName(tableName);
                mappingBuilder.setProvisionedThroughput(tableName, readCapacUnits, writeCapacUnits);
                LOG.debug("Basic table properties have been set: Name, and Provisioned throughput.");
                List fieldElements = tableElement.getChildren("key");
                for (Element fieldElement : fieldElements) {
                    String keyName = fieldElement.getAttributeValue("name");
                    String keyType = fieldElement.getAttributeValue("type");
                    String keyAttrType = fieldElement.getAttributeValue("att-type");
                    if (keyType.equals("hash")) {
                        mappingBuilder.setHashKeySchema(tableName, keyName, keyAttrType);
                        continue;
                    }
                    if (!keyType.equals("hashrange")) continue;
                    mappingBuilder.setHashRangeKeySchema(tableName, keyName, keyAttrType);
                }
                LOG.debug("Table key schemas have been set.");
                fieldElements = tableElement.getChildren("attribute");
                for (Element fieldElement : fieldElements) {
                    String attributeName = fieldElement.getAttributeValue("name");
                    String attributeType = fieldElement.getAttributeValue("type");
                    mappingBuilder.addAttribute(tableName, attributeName, attributeType, 0);
                }
                LOG.debug("Table attributes have been read.");
            }
        }
        catch (IOException ex) {
            LOG.error("Error while performing xml mapping.");
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Error while performing xml mapping.");
            ex.printStackTrace();
            throw new IOException(ex);
        }
        return mappingBuilder.build();
    }

    private AWSCredentials getCredentials() throws FileNotFoundException, IllegalArgumentException, IOException {
        if (this.authentication == null) {
            InputStream awsCredInpStr = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(awsCredentialsProperties);
            if (awsCredInpStr == null) {
                LOG.info("AWS Credentials File was not found on the classpath!");
            }
            PropertiesCredentials credentials = new PropertiesCredentials(awsCredInpStr);
            this.setConf(credentials);
        }
        return (AWSCredentials)this.authentication;
    }

    private DynamoDBQuery<K, T> buildDynamoDBQuery(Query<K, T> query) {
        if (this.getSchemaName() == null) {
            throw new IllegalStateException("There is not a preferred schema defined.");
        }
        DynamoDBQuery<K, T> dynamoDBQuery = new DynamoDBQuery<K, T>();
        dynamoDBQuery.setKeySchema(this.mapping.getKeySchema(this.getSchemaName()));
        dynamoDBQuery.setQuery(query);
        dynamoDBQuery.setConsistencyReadLevel(this.getConsistencyReads());
        dynamoDBQuery.buildExpression();
        return dynamoDBQuery;
    }

    private boolean getConsistencyReads() {
        return this.consistency != null && this.consistency.equals("true");
    }

    public Result<K, T> execute(Query<K, T> query) {
        DynamoDBQuery<K, T> dynamoDBQuery = this.buildDynamoDBQuery(query);
        DynamoDBMapper mapper = new DynamoDBMapper(this.dynamoDBClient);
        PaginatedQueryList objList = null;
        if (DynamoDBQuery.getType().equals("range")) {
            objList = mapper.query(this.persistentClass, (DynamoDBQueryExpression)dynamoDBQuery.getQueryExpression());
        }
        if (DynamoDBQuery.getType().equals("scan")) {
            objList = mapper.scan(this.persistentClass, (DynamoDBScanExpression)dynamoDBQuery.getQueryExpression());
        }
        return new DynamoDBResult<K, T>(this, query, objList);
    }

    public T get(K key, String[] fields) {
        return null;
    }

    public T get(K key) {
        Persistent object;
        block6: {
            object = null;
            try {
                Object rangeKey = this.getRangeKey(key);
                Object hashKey = this.getHashKey(key);
                if (hashKey != null) {
                    DynamoDBMapper mapper = new DynamoDBMapper(this.dynamoDBClient);
                    object = rangeKey != null ? (Persistent)mapper.load(this.persistentClass, hashKey, rangeKey) : (Persistent)mapper.load(this.persistentClass, hashKey);
                    break block6;
                }
                throw new GoraException("Error while retrieving keys from object: " + key.toString());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (GoraException ge) {
                LOG.error(ge.getMessage());
                LOG.error(ge.getStackTrace().toString());
            }
        }
        return (T)object;
    }

    public Query<K, T> newQuery() {
        DynamoDBQuery query = new DynamoDBQuery(this);
        return query;
    }

    public String getSchemaName() {
        if (preferredSchema != null) {
            return preferredSchema;
        }
        return null;
    }

    public void setSchemaName(String pSchemaName) {
        preferredSchema = pSchemaName;
    }

    public void createSchema() {
        LOG.info("Creating schema");
        if (this.mapping.getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        if (preferredSchema == null) {
            LOG.debug("create schemas");
            for (String tableName : this.mapping.getTables().keySet()) {
                this.executeCreateTableRequest(tableName);
            }
            LOG.debug("tables created successfully.");
        } else {
            LOG.debug("create schema " + preferredSchema);
            this.executeCreateTableRequest(preferredSchema);
        }
    }

    private void executeCreateTableRequest(String tableName) {
        CreateTableRequest createTableRequest = this.getCreateTableRequest(tableName, this.mapping.getKeySchema(tableName), this.mapping.getProvisionedThroughput(tableName));
        this.dynamoDBClient.createTable(createTableRequest).getTableDescription();
        this.waitForTableToBecomeAvailable(tableName);
        LOG.info(tableName + "Schema now available");
    }

    private CreateTableRequest getCreateTableRequest(String tableName, KeySchema keySchema, ProvisionedThroughput proThrou) {
        CreateTableRequest createTableRequest = new CreateTableRequest();
        createTableRequest.setTableName(tableName);
        createTableRequest.setKeySchema(keySchema);
        createTableRequest.setProvisionedThroughput(proThrou);
        return createTableRequest;
    }

    public void deleteSchema() {
        if (this.mapping.getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        if (preferredSchema == null) {
            LOG.debug("Delete schemas");
            if (this.mapping.getTables().isEmpty()) {
                throw new IllegalStateException("There are not tables defined.");
            }
            for (String tableName : this.mapping.getTables().keySet()) {
                this.executeDeleteTableRequest(tableName);
            }
            LOG.debug("All schemas deleted successfully.");
        } else {
            LOG.debug("create schema " + preferredSchema);
            this.executeDeleteTableRequest(preferredSchema);
        }
    }

    public void executeDeleteTableRequest(String pTableName) {
        try {
            DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withTableName(pTableName);
            DeleteTableResult result = this.dynamoDBClient.deleteTable(deleteTableRequest);
            this.waitForTableToBeDeleted(pTableName);
            LOG.debug("Schema: " + result.getTableDescription() + " deleted successfully.");
        }
        catch (Exception e) {
            LOG.debug("Schema: " + pTableName + " deleted.");
            e.printStackTrace();
        }
    }

    private void waitForTableToBeDeleted(String pTableName) {
        LOG.debug("Waiting for " + pTableName + " to be deleted.");
        long startTime = System.currentTimeMillis();
        long endTime = startTime + waitTime;
        while (System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(sleepDeleteTime);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                DescribeTableRequest request = new DescribeTableRequest().withTableName(pTableName);
                TableDescription tableDescription = this.dynamoDBClient.describeTable(request).getTable();
                String tableStatus = tableDescription.getTableStatus();
                LOG.debug(pTableName + " - current state: " + tableStatus);
            }
            catch (AmazonServiceException ase) {
                if (ase.getErrorCode().equalsIgnoreCase("ResourceNotFoundException")) {
                    return;
                }
                ase.printStackTrace();
            }
        }
        LOG.debug(pTableName + " deleted.");
    }

    private void waitForTableToBecomeAvailable(String tableName) {
        LOG.debug("Waiting for " + tableName + " to become available");
        long startTime = System.currentTimeMillis();
        long endTime = startTime + waitTime;
        while (System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                DescribeTableRequest request = new DescribeTableRequest().withTableName(tableName);
                TableDescription tableDescription = this.dynamoDBClient.describeTable(request).getTable();
                String tableStatus = tableDescription.getTableStatus();
                LOG.debug(tableName + " - current state: " + tableStatus);
                if (!tableStatus.equals(TableStatus.ACTIVE.toString())) continue;
                return;
            }
            catch (AmazonServiceException ase) {
                if (ase.getErrorCode().equalsIgnoreCase("ResourceNotFoundException")) continue;
                throw ase;
            }
        }
        throw new RuntimeException("Table " + tableName + " never became active");
    }

    public boolean schemaExists() {
        LOG.info("Verifying schemas.");
        TableDescription success = null;
        if (this.mapping.getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        if (preferredSchema == null) {
            LOG.debug("Verifying schemas");
            if (this.mapping.getTables().isEmpty()) {
                throw new IllegalStateException("There are not tables defined.");
            }
            for (String tableName : this.mapping.getTables().keySet()) {
                success = this.getTableSchema(tableName);
                if (success != null) continue;
                return false;
            }
        } else {
            LOG.info("Verifying schema " + preferredSchema);
            success = this.getTableSchema(preferredSchema);
        }
        LOG.info("Finished verifying schemas.");
        return success != null;
    }

    private TableDescription getTableSchema(String tableName) {
        TableDescription tableDescription = null;
        try {
            DescribeTableRequest describeTableRequest = new DescribeTableRequest().withTableName(tableName);
            tableDescription = this.dynamoDBClient.describeTable(describeTableRequest).getTable();
        }
        catch (ResourceNotFoundException e) {
            LOG.error("Error while getting table schema: " + tableName);
            return tableDescription;
        }
        return tableDescription;
    }

    public K newKey() {
        return null;
    }

    public T newPersistent() {
        Persistent obj = null;
        try {
            obj = (Persistent)this.persistentClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public void put(K key, T obj) {
        try {
            DynamoDBMapper mapper;
            Object rangeKey = this.getRangeKey(key);
            Object hashKey = this.getHashKey(key);
            if (hashKey == null) {
                hashKey = this.getHashKey((K)obj);
            }
            if (rangeKey == null) {
                rangeKey = this.getRangeKey((K)obj);
            }
            if (hashKey != null) {
                mapper = new DynamoDBMapper(this.dynamoDBClient);
                if (rangeKey != null) {
                    mapper.load(this.persistentClass, (Object)hashKey.toString(), (Object)rangeKey.toString());
                } else {
                    mapper.load(this.persistentClass, (Object)hashKey.toString());
                }
            } else {
                throw new GoraException("Error while retrieving keys from object: " + obj.toString());
            }
            mapper.save(obj);
        }
        catch (NullPointerException npe) {
            LOG.error("Error while putting an item. " + npe.toString());
            npe.printStackTrace();
        }
        catch (Exception e) {
            LOG.error("Error while putting an item. " + obj.toString());
            e.printStackTrace();
        }
    }

    public boolean delete(K key) {
        try {
            Object[] params;
            Persistent object = null;
            Object rangeKey = null;
            Object hashKey = null;
            DynamoDBMapper mapper = new DynamoDBMapper(this.dynamoDBClient);
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals("getRangeKey")) continue;
                params = null;
                rangeKey = met.invoke(key, params);
                break;
            }
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals("getHashKey")) continue;
                params = null;
                hashKey = met.invoke(key, params);
                break;
            }
            if (hashKey == null) {
                object = (Persistent)mapper.load(this.persistentClass, key);
            }
            if ((object = rangeKey == null ? (Persistent)mapper.load(this.persistentClass, hashKey) : (Persistent)mapper.load(this.persistentClass, hashKey, rangeKey)) == null) {
                return false;
            }
            mapper.delete((Object)object);
            return true;
        }
        catch (Exception e) {
            LOG.error("Error while deleting value with key " + key.toString());
            LOG.error(e.getMessage());
            return false;
        }
    }

    public long deleteByQuery(Query<K, T> query) {
        Result<K, T> result = this.execute(query);
        ArrayList<Persistent> deletes = new ArrayList<Persistent>();
        try {
            while (result.next()) {
                Persistent resultObj = result.get();
                deletes.add(resultObj);
                DynamoDBKey<Object, Object> dKey = new DynamoDBKey<Object, Object>();
                dKey.setHashKey(this.getHashKey((K)resultObj));
                dKey.setRangeKey(this.getRangeKey((K)resultObj));
                this.delete(dKey);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletes.size();
    }

    private Object getHashKey(T obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object hashKey = null;
        for (Method met : obj.getClass().getDeclaredMethods()) {
            if (!met.getName().equals("getHashKey")) continue;
            Object[] params = null;
            hashKey = met.invoke(obj, params);
            break;
        }
        return hashKey;
    }

    private Object getHashKey(K obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object hashKey = null;
        for (Method met : obj.getClass().getDeclaredMethods()) {
            if (!met.getName().equals("getHashKey")) continue;
            Object[] params = null;
            hashKey = met.invoke(obj, params);
            break;
        }
        return hashKey;
    }

    private Object getRangeKey(T obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object rangeKey = null;
        for (Method met : obj.getClass().getDeclaredMethods()) {
            if (!met.getName().equals("getRangeKey")) continue;
            Object[] params = null;
            rangeKey = met.invoke(obj, params);
            break;
        }
        return rangeKey;
    }

    private Object getRangeKey(K obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object rangeKey = null;
        for (Method met : obj.getClass().getDeclaredMethods()) {
            if (!met.getName().equals("getRangeKey")) continue;
            Object[] params = null;
            rangeKey = met.invoke(obj, params);
            break;
        }
        return rangeKey;
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        return null;
    }

    public void flush() {
    }

    public void setBeanFactory(BeanFactory<K, T> beanFactory) {
    }

    public BeanFactory<K, T> getBeanFactory() {
        return null;
    }

    public void close() {
        LOG.debug("Datastore closed.");
        this.flush();
    }

    static {
        waitTime = 600000L;
        sleepTime = 20000L;
        sleepDeleteTime = 10000L;
        awsCredentialsProperties = "AwsCredentials.properties";
        wsProvider = "Amazon.Web.Services";
        CLI_TYP_PROP = "gora.dynamodb.client";
        ENDPOINT_PROP = "gora.dynamodb.endpoint";
        PREF_SCH_NAME = "preferred.schema.name";
        CONSISTENCY_READS = "gora.dynamodb.consistent.reads";
    }
}

