/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.store;

import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import com.amazonaws.services.dynamodb.model.ProvisionedThroughput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBMapping {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBMapping.class);
    private final Map<String, List<Map<String, String>>> tablesToItems;
    private final Map<String, KeySchema> tablesToKeySchemas;
    private final Map<String, ProvisionedThroughput> tablesToPrTh;

    public DynamoDBMapping(Map<String, List<Map<String, String>>> tables, Map<String, KeySchema> tablesToKeySchemas, Map<String, ProvisionedThroughput> provisionedThroughput) {
        this.tablesToItems = tables;
        this.tablesToKeySchemas = tablesToKeySchemas;
        this.tablesToPrTh = provisionedThroughput;
    }

    public Map<String, List<Map<String, String>>> getTables() {
        return this.tablesToItems;
    }

    public List<Map<String, String>> getItems(String tableName) {
        return this.tablesToItems.get(tableName);
    }

    public KeySchema getKeySchema(String tableName) {
        return this.tablesToKeySchemas.get(tableName);
    }

    public ProvisionedThroughput getProvisionedThroughput(String tableName) {
        return this.tablesToPrTh.get(tableName);
    }

    public static class DynamoDBMappingBuilder {
        private String tableName;
        private Map<String, List<Map<String, String>>> tablesToItems = new HashMap<String, List<Map<String, String>>>();
        private Map<String, KeySchema> tablesToKeySchemas = new HashMap<String, KeySchema>();
        private Map<String, ProvisionedThroughput> tablesToPrTh = new HashMap<String, ProvisionedThroughput>();

        public void setTableName(String tabName) {
            this.tableName = tabName;
        }

        public String getTableName(String tableName) {
            return tableName;
        }

        public void setProvisionedThroughput(String tableName, long readCapUnits, long writeCapUnits) {
            ProvisionedThroughput ptDesc = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCapUnits)).withWriteCapacityUnits(Long.valueOf(writeCapUnits));
            this.tablesToPrTh.put(tableName, ptDesc);
        }

        public void setHashRangeKeySchema(String tableName, String rangeKeyName, String rangeKeyType) {
            KeySchema kSchema = this.tablesToKeySchemas.get(tableName);
            if (kSchema == null) {
                kSchema = new KeySchema();
            }
            KeySchemaElement rangeKeyElement = new KeySchemaElement().withAttributeName(rangeKeyName).withAttributeType(rangeKeyType);
            kSchema.setRangeKeyElement(rangeKeyElement);
            this.tablesToKeySchemas.put(tableName, kSchema);
        }

        public void setHashKeySchema(String tableName, String keyName, String keyType) {
            KeySchema kSchema = this.tablesToKeySchemas.get(tableName);
            if (kSchema == null) {
                kSchema = new KeySchema();
            }
            KeySchemaElement hashKey = new KeySchemaElement().withAttributeName(keyName).withAttributeType(keyType);
            kSchema.setHashKeyElement(hashKey);
            this.tablesToKeySchemas.put(tableName, kSchema);
        }

        private List<Map<String, String>> getOrCreateTable(String tableName) {
            List<Map<String, String>> items = this.tablesToItems.get(tableName);
            if (items == null) {
                items = new ArrayList<Map<String, String>>();
                this.tablesToItems.put(tableName, items);
            }
            return items;
        }

        private HashMap<String, String> getOrCreateItemAttribs(List<Map<String, String>> items, int itemNumber) {
            HashMap itemAttribs;
            if (items.isEmpty()) {
                items.add(new HashMap());
            }
            if ((itemAttribs = (HashMap)items.get(itemNumber)) == null) {
                items.add(new HashMap());
            }
            return (HashMap)items.get(itemNumber);
        }

        public void addAttribute(String tableName, String attributeName, String attrType, int itemNumber) {
            List<Map<String, String>> items = this.getOrCreateTable(tableName);
            HashMap<String, String> itemAttribs = this.getOrCreateItemAttribs(items, itemNumber);
            itemAttribs.put(attributeName, attrType);
        }

        private String verifyAllKeySchemas() {
            String wrongTable = "";
            if (this.tablesToItems.isEmpty()) {
                return "";
            }
            for (String tableName : this.tablesToItems.keySet()) {
                if (this.tablesToKeySchemas.isEmpty()) {
                    return "";
                }
                if (this.verifyKeySchema(tableName)) continue;
                return "";
            }
            return wrongTable;
        }

        private boolean verifyKeySchema(String tableName) {
            KeySchema kSchema = this.tablesToKeySchemas.get(tableName);
            if (kSchema == null) {
                return false;
            }
            KeySchemaElement rangeKey = kSchema.getRangeKeyElement();
            KeySchemaElement hashKey = kSchema.getHashKeyElement();
            if (rangeKey != null) {
                return hashKey != null;
            }
            return hashKey != null;
        }

        public DynamoDBMapping build() {
            if (this.tableName == null) {
                throw new IllegalStateException("tableName is not specified");
            }
            if (this.tablesToItems.isEmpty()) {
                throw new IllegalStateException("No tables");
            }
            String wrongTableName = this.verifyAllKeySchemas();
            if (!wrongTableName.equals("")) {
                throw new IllegalStateException("no key schemas defined for table " + wrongTableName);
            }
            return new DynamoDBMapping(this.tablesToItems, this.tablesToKeySchemas, this.tablesToPrTh);
        }
    }
}

