/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.query;

import com.amazonaws.services.dynamodb.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.ComparisonOperator;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.ws.impl.QueryWSBase;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBQuery<K, T extends Persistent>
extends QueryWSBase<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBQuery.class);
    private boolean consistencyReadLevel;
    private static ComparisonOperator rangeCompOp;
    private static ComparisonOperator scanCompOp;
    public static final String RANGE_QUERY = "range";
    public static final String SCAN_QUERY = "scan";
    private static String type;
    private Query<K, T> query;
    private Object dynamoDBExpression;
    private KeySchema keySchema;
    private K hashKey;

    public DynamoDBQuery() {
        super(null);
    }

    public DynamoDBQuery(DataStore<K, T> dataStore) {
        super(dataStore);
    }

    public void setKey(K key) {
        this.hashKey = key;
    }

    public K getKey() {
        return this.hashKey;
    }

    public void buildExpression() {
        AttributeValue hashAttrValue = this.buildKeyHashAttribute();
        if (hashAttrValue == null) {
            throw new IllegalStateException("There is not a key schema defined.");
        }
        if (DynamoDBQuery.getType().equals(RANGE_QUERY)) {
            Condition newCondition = this.buildRangeCondition();
            this.buildQueryExpression(newCondition, hashAttrValue);
        }
        if (DynamoDBQuery.getType().equals(SCAN_QUERY)) {
            this.buildScanExpression(hashAttrValue);
        }
    }

    public void buildScanExpression(AttributeValue pHashAttrValue) {
        DynamoDBScanExpression newScanExpression = new DynamoDBScanExpression();
        newScanExpression.addFilterCondition(this.getKeySchema().getHashKeyElement().getAttributeName(), this.buildKeyScanCondition());
        this.dynamoDBExpression = newScanExpression;
    }

    public void buildQueryExpression(Condition pNewCondition, AttributeValue pHashAttrValue) {
        DynamoDBQueryExpression newQueryExpression = new DynamoDBQueryExpression(pHashAttrValue);
        newQueryExpression.setConsistentRead(this.getConsistencyReadLevel());
        newQueryExpression.setRangeKeyCondition(pNewCondition);
        this.dynamoDBExpression = newQueryExpression;
    }

    private AttributeValue buildKeyHashAttribute() {
        String pAttrType = this.getKeySchema().getHashKeyElement().getAttributeType();
        if (pAttrType.equals("S")) {
            return new AttributeValue().withS(this.getHashKey(this.query.getKey()).toString());
        }
        if (pAttrType.equals("N")) {
            return new AttributeValue().withN(this.getHashKey(this.query.getKey()).toString());
        }
        return null;
    }

    private Object getHashKey(K key) {
        Object hashKey = null;
        try {
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals("getHashKey")) continue;
                Object[] params = null;
                hashKey = met.invoke(key, params);
                break;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.");
            e.printStackTrace();
        }
        return hashKey;
    }

    private Object getRangeKey(K key) {
        Object rangeKey = null;
        try {
            for (Method met : key.getClass().getDeclaredMethods()) {
                if (!met.getName().equals("getRangeKey")) continue;
                Object[] params = null;
                rangeKey = met.invoke(key, params);
                break;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.info("DynamoDBStore: Error while trying to fetch range key.");
            e.printStackTrace();
        }
        return rangeKey;
    }

    private Condition buildKeyScanCondition() {
        Condition scanKeyCondition = new Condition();
        scanKeyCondition.setComparisonOperator(DynamoDBQuery.getScanCompOp());
        scanKeyCondition.withAttributeValueList(new AttributeValue[]{this.buildKeyHashAttribute()});
        return scanKeyCondition;
    }

    private Condition buildRangeCondition() {
        KeySchemaElement kRangeSchema = this.getKeySchema().getRangeKeyElement();
        Condition rangeKeyCondition = null;
        if (kRangeSchema != null) {
            rangeKeyCondition = new Condition();
            rangeKeyCondition.setComparisonOperator(ComparisonOperator.BETWEEN.toString());
            AttributeValue startVal = null;
            AttributeValue endVal = null;
            if (kRangeSchema.getAttributeType().equals("S")) {
                startVal = new AttributeValue().withS(this.getRangeKey(this.query.getStartKey()).toString());
                endVal = new AttributeValue().withS(this.getRangeKey(this.query.getEndKey()).toString());
            } else if (kRangeSchema.getAttributeType().equals("N")) {
                startVal = new AttributeValue().withN(this.getRangeKey(this.query.getStartKey()).toString());
                endVal = new AttributeValue().withN(this.getRangeKey(this.query.getEndKey()).toString());
            }
            rangeKeyCondition.withAttributeValueList(new AttributeValue[]{startVal, endVal});
        }
        return rangeKeyCondition;
    }

    public boolean getConsistencyReadLevel() {
        return this.consistencyReadLevel;
    }

    public void setConsistencyReadLevel(boolean pConsistencyReadLevel) {
        this.consistencyReadLevel = pConsistencyReadLevel;
    }

    public KeySchema getKeySchema() {
        return this.keySchema;
    }

    public Object getQueryExpression() {
        return this.dynamoDBExpression;
    }

    public void setKeySchema(KeySchema pKeySchema) {
        this.keySchema = pKeySchema;
    }

    public void setQuery(Query<K, T> pQuery) {
        this.query = pQuery;
    }

    public Query<K, T> getQuery() {
        return this.query;
    }

    public static String getType() {
        return type;
    }

    public static void setType(String pType) {
        type = pType;
    }

    public static ComparisonOperator getScanCompOp() {
        if (scanCompOp == null) {
            scanCompOp = ComparisonOperator.GE;
        }
        return scanCompOp;
    }

    public static void setScanCompOp(ComparisonOperator scanCompOp) {
        DynamoDBQuery.scanCompOp = scanCompOp;
    }

    public static ComparisonOperator getRangeCompOp() {
        if (rangeCompOp == null) {
            rangeCompOp = ComparisonOperator.BETWEEN;
        }
        return rangeCompOp;
    }

    public static void setRangeCompOp(ComparisonOperator pRangeCompOp) {
        rangeCompOp = pRangeCompOp;
    }
}

