/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.dynamodb.compiler;

import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.gora.dynamodb.store.DynamoDBMapping;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoraDynamoDBCompiler {
    private File dest;
    private Writer out;
    private static final Logger log = LoggerFactory.getLogger(GoraDynamoDBCompiler.class);

    private GoraDynamoDBCompiler(File dest) {
        this.dest = dest;
    }

    public static void compileSchema(File src, File dest) throws IOException {
        log.info("Compiling " + src + " to " + dest);
        GoraDynamoDBCompiler compiler = new GoraDynamoDBCompiler(dest);
        DynamoDBMapping dynamoDBMap = compiler.readMapping(src);
        if (dynamoDBMap.getTables().isEmpty()) {
            throw new IllegalStateException("There are not tables defined.");
        }
        for (String tableName : dynamoDBMap.getTables().keySet()) {
            compiler.compile(tableName, dynamoDBMap.getKeySchema(tableName), dynamoDBMap.getItems(tableName));
        }
    }

    private void compile(String pTableName, KeySchema pKeySchema, List<Map<String, String>> pItems) {
        try {
            this.startFile(pTableName, pTableName);
            this.setHeaders(null);
            this.line(0, "");
            this.line(0, "@DynamoDBTable(tableName = \"" + pTableName + "\")");
            this.line(0, "public class " + pTableName + " implements Persistent {");
            this.setKeyAttributes(pKeySchema, 2);
            this.setKeyMethods(pKeySchema, 2);
            this.setItems(pItems, 2);
            this.setDefaultMethods(2);
            this.line(0, "}");
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            log.error("Error while compiling table " + pTableName);
            e.printStackTrace();
        }
    }

    private void setItems(List<Map<String, String>> pItems, int pIden) throws IOException {
        for (Map<String, String> item : pItems) {
            for (String itemName : item.keySet()) {
                String itemType = "String";
                if (item.get(itemName).toString().equals("N")) {
                    itemType = "double";
                }
                if (item.get(itemName).toString().equals("SS")) {
                    itemType = "Set<String>";
                }
                if (item.get(itemName).toString().equals("SN")) {
                    itemType = "Set<double>";
                }
                this.line(pIden, "private " + itemType + " " + itemName + ";");
                this.setItemMethods(itemName, itemType, pIden);
            }
        }
        this.line(0, "");
    }

    private void setItemMethods(String pItemName, String pItemType, int pIden) throws IOException {
        this.line(pIden, "@DynamoDBAttribute(attributeName = \"" + GoraDynamoDBCompiler.camelCasify(pItemName) + "\")");
        this.line(pIden, "public " + pItemType + " get" + GoraDynamoDBCompiler.camelCasify(pItemName) + "() {  return " + pItemName + ";  }");
        this.line(pIden, "public void set" + GoraDynamoDBCompiler.camelCasify(pItemName) + "(" + pItemType + " p" + GoraDynamoDBCompiler.camelCasify(pItemName) + ") {  this." + pItemName + " = p" + GoraDynamoDBCompiler.camelCasify(pItemName) + ";  }");
        this.line(0, "");
    }

    private void setKeyMethods(KeySchema pKeySchema, int pIden) throws IOException {
        KeySchemaElement hashKey = pKeySchema.getHashKeyElement();
        KeySchemaElement rangeKey = pKeySchema.getRangeKeyElement();
        StringBuilder strBuilder = new StringBuilder();
        if (hashKey != null) {
            strBuilder.append("@DynamoDBHashKey(attributeName=\"" + hashKey.getAttributeName() + "\") \n");
            strBuilder.append("    public String getHashKey() {  return " + hashKey.getAttributeName() + "; } \n");
            strBuilder.append("    public void setHashKey(" + (hashKey.getAttributeType().equals("S") ? "String " : "double "));
            strBuilder.append("p" + GoraDynamoDBCompiler.camelCasify(hashKey.getAttributeName()) + "){  this." + hashKey.getAttributeName());
            strBuilder.append(" = p" + GoraDynamoDBCompiler.camelCasify(hashKey.getAttributeName()) + "; }");
            this.line(pIden, strBuilder.toString());
        }
        strBuilder.delete(0, strBuilder.length());
        if (rangeKey != null) {
            strBuilder.append("@DynamoDBRangeKey(attributeName=\"" + rangeKey.getAttributeName() + "\") \n");
            strBuilder.append("    public String getRangeKey() {  return " + rangeKey.getAttributeName() + "; } \n");
            strBuilder.append("    public void setRangeKey(" + (rangeKey.getAttributeType().equals("S") ? "String " : "double "));
            strBuilder.append("p" + GoraDynamoDBCompiler.camelCasify(rangeKey.getAttributeName()) + "){  this." + rangeKey.getAttributeName());
            strBuilder.append(" = p" + GoraDynamoDBCompiler.camelCasify(rangeKey.getAttributeName()) + "; }");
            this.line(pIden, strBuilder.toString());
        }
        this.line(0, "");
    }

    private void setKeyAttributes(KeySchema pKeySchema, int pIden) throws IOException {
        KeySchemaElement hashKey = pKeySchema.getHashKeyElement();
        KeySchemaElement rangeKey = pKeySchema.getRangeKeyElement();
        StringBuilder strBuilder = new StringBuilder();
        if (hashKey != null) {
            strBuilder.append("private " + (hashKey.getAttributeType().equals("S") ? "String " : "double "));
            strBuilder.append(hashKey.getAttributeName() + ";");
            this.line(pIden, strBuilder.toString());
        }
        strBuilder.delete(0, strBuilder.length());
        if (rangeKey != null) {
            strBuilder.append("private " + (rangeKey.getAttributeType().equals("S") ? "String " : "double "));
            strBuilder.append(rangeKey.getAttributeName() + ";");
            this.line(pIden, strBuilder.toString());
        }
        this.line(0, "");
    }

    private static String camelCasify(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String toUpperCase(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i > 0 && Character.isUpperCase(s.charAt(i)) && Character.isLowerCase(s.charAt(i - 1)) && Character.isLetter(s.charAt(i))) {
                builder.append("_");
            }
            builder.append(Character.toUpperCase(s.charAt(i)));
        }
        return builder.toString();
    }

    private void startFile(String name, String space) throws IOException {
        File dir = new File(this.dest, space.replace('.', File.separatorChar));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create " + dir);
        }
        name = GoraDynamoDBCompiler.cap(name) + ".java";
        this.out = new OutputStreamWriter(new FileOutputStream(new File(dir, name)));
    }

    private void setHeaders(String namespace) throws IOException {
        if (namespace != null) {
            this.line(0, "package " + namespace + ";\n");
        }
        this.line(0, "import java.util.Set;");
        this.line(0, "import org.apache.gora.persistency.Persistent;");
        this.line(0, "import org.apache.gora.persistency.StateManager;");
        this.line(0, "import com.amazonaws.services.dynamodb.datamodeling.DynamoDBAttribute;");
        this.line(0, "import com.amazonaws.services.dynamodb.datamodeling.DynamoDBHashKey;");
        this.line(0, "import com.amazonaws.services.dynamodb.datamodeling.DynamoDBRangeKey;");
        this.line(0, "import com.amazonaws.services.dynamodb.datamodeling.DynamoDBTable;");
    }

    private void setDefaultMethods(int pIden) throws IOException {
        this.line(pIden, "public void setNew(boolean pNew){}");
        this.line(pIden, "public void setDirty(boolean pDirty){}");
        this.line(pIden, "@Override");
        this.line(pIden, "public StateManager getStateManager() { return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public Persistent newInstance(StateManager stateManager) { return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public String[] getFields() { return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public String getField(int index) {return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public int getFieldIndex(String field) { return 0; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clear() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public person clone() {return null; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isNew() { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setNew() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearNew() {}");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isDirty() { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isDirty(int fieldIndex) { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isDirty(String field) { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setDirty() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setDirty(int fieldIndex) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setDirty(String field) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearDirty(int fieldIndex) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearDirty(String field) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearDirty() { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isReadable(int fieldIndex) {return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public boolean isReadable(String field) { return false; }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setReadable(int fieldIndex) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void setReadable(String field) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearReadable(int fieldIndex) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearReadable(String field) { }");
        this.line(pIden, "@Override");
        this.line(pIden, "public void clearReadable() { }");
    }

    private void line(int indent, String text) throws IOException {
        for (int i = 0; i < indent; ++i) {
            this.out.append("  ");
        }
        this.out.append(text);
        this.out.append("\n");
    }

    static String cap(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: Compiler <schema file> <output dir>");
            System.exit(1);
        }
        GoraDynamoDBCompiler.compileSchema(new File(args[0]), new File(args[1]));
    }

    private DynamoDBMapping readMapping(File pMapFile) throws IOException {
        DynamoDBMapping.DynamoDBMappingBuilder mappingBuilder = new DynamoDBMapping.DynamoDBMappingBuilder();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(pMapFile);
            Element root = doc.getRootElement();
            List tableElements = root.getChildren("table");
            for (Element tableElement : tableElements) {
                String tableName = tableElement.getAttributeValue("name");
                long readCapacUnits = Long.parseLong(tableElement.getAttributeValue("readcunit"));
                long writeCapacUnits = Long.parseLong(tableElement.getAttributeValue("readcunit"));
                mappingBuilder.setTableName(tableName);
                mappingBuilder.setProvisionedThroughput(tableName, readCapacUnits, writeCapacUnits);
                log.debug("Basic table properties have been set: Name, and Provisioned throughput.");
                List fieldElements = tableElement.getChildren("key");
                for (Element fieldElement : fieldElements) {
                    String keyName = fieldElement.getAttributeValue("name");
                    String keyType = fieldElement.getAttributeValue("type");
                    String keyAttrType = fieldElement.getAttributeValue("att-type");
                    if (keyType.equals("hash")) {
                        mappingBuilder.setHashKeySchema(tableName, keyName, keyAttrType);
                        continue;
                    }
                    if (!keyType.equals("hashrange")) continue;
                    mappingBuilder.setHashRangeKeySchema(tableName, keyName, keyAttrType);
                }
                log.debug("Table key schemas have been set.");
                fieldElements = tableElement.getChildren("attribute");
                for (Element fieldElement : fieldElements) {
                    String attributeName = fieldElement.getAttributeValue("name");
                    String attributeType = fieldElement.getAttributeValue("type");
                    mappingBuilder.addAttribute(tableName, attributeName, attributeType, 0);
                }
                log.info("Table attributes have been read.");
            }
        }
        catch (IOException ex) {
            log.info("Error while performing xml mapping.");
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex);
        }
        return mappingBuilder.build();
    }
}

