/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BinaryNode;
import org.codehaus.jackson.node.JsonNodeFactory;

public class GoraCompiler
extends SpecificCompiler {
    public static String DIRTY_BYTES_FIELD_NAME = "__g__dirty";
    public static final int FIRST_UNMANAGED_FIELD_INDEX = 1;
    private static final Set<String> GORA_RESERVED_NAMES = new HashSet<String>();
    private static final Set<String> GORA_HIDDEN_FIELD_NAMES;

    public static void compileSchema(File[] srcFiles, File dest) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        for (File src : srcFiles) {
            System.out.println("Compiling: " + src.getAbsolutePath());
            Schema originalSchema = parser.parse(src);
            HashMap queue = new HashMap();
            Schema newSchema = originalSchema;
            GoraCompiler compiler = new GoraCompiler(newSchema);
            compiler.setTemplateDir("/org/apache/gora/compiler/templates/");
            compiler.compileToDestination(src, dest);
            System.out.println("Compiled into: " + dest.getAbsolutePath());
        }
    }

    public static String generateAppropriateImmutabilityModifier(Schema schema) {
        switch (schema.getType()) {
            case BYTES: {
                return ".asReadOnlyBuffer()";
            }
        }
        return "";
    }

    public static String generateAppropriateWrapperOrValue(Schema schema) {
        switch (schema.getType()) {
            case MAP: {
                return "(value instanceof org.apache.gora.persistency.Dirtyable) ? value : new org.apache.gora.persistency.impl.DirtyMapWrapper(value)";
            }
            case ARRAY: {
                return "(value instanceof org.apache.gora.persistency.Dirtyable) ? value : new org.apache.gora.persistency.impl.DirtyListWrapper(value)";
            }
            case BYTES: {
                return "deepCopyToReadOnlyBuffer(value)";
            }
        }
        return "value";
    }

    public static String generateAppropriateWrapperOrValueForPut(Schema schema) {
        switch (schema.getType()) {
            case MAP: {
                return "(value instanceof org.apache.gora.persistency.Dirtyable) ? value : new org.apache.gora.persistency.impl.DirtyMapWrapper((java.util.Map)value)";
            }
            case ARRAY: {
                return "(value instanceof org.apache.gora.persistency.Dirtyable) ? value : new org.apache.gora.persistency.impl.DirtyListWrapper((java.util.List)value)";
            }
        }
        return "value";
    }

    public static String generateAppropriateWrapper(Schema schema, Schema.Field field) {
        if (field.name() == "__g__dirty") {
            return "java.nio.ByteBuffer.wrap(new byte[" + GoraCompiler.getNumberOfBytesNeededForDirtyBits(schema) + "])";
        }
        switch (field.schema().getType()) {
            case RECORD: {
                return field.schema().getName() + ".newBuilder().build()";
            }
            case MAP: {
                return "new org.apache.gora.persistency.impl.DirtyMapWrapper((java.util.Map)defaultValue(fields()[" + field.pos() + "]))";
            }
            case ARRAY: {
                return "new org.apache.gora.persistency.impl.DirtyListWrapper((java.util.List)defaultValue(fields()[" + field.pos() + "]))";
            }
        }
        return "defaultValue(fields()[" + field.pos() + "])";
    }

    public static String generateAppropriateValue(Schema.Field field) {
        switch (field.schema().getType()) {
            case RECORD: {
                return field.schema().getName() + ".newBuilder().build()";
            }
            case MAP: {
                return "new org.apache.gora.persistency.impl.DirtyMapWrapper(new java.util.HashMap())";
            }
            case ARRAY: {
                return "new org.apache.gora.persistency.impl.DirtyListWrapper(new java.util.ArrayList())";
            }
        }
        return "this." + field.name();
    }

    public static String toUpperCase(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i > 0 && Character.isUpperCase(s.charAt(i)) && Character.isLowerCase(s.charAt(i - 1)) && Character.isLetter(s.charAt(i))) {
                builder.append("_");
            }
            builder.append(Character.toUpperCase(s.charAt(i)));
        }
        return builder.toString();
    }

    private static int getNumberOfBytesNeededForDirtyBits(Schema originalSchema) {
        return (int)Math.ceil((double)(originalSchema.getFields().size() + 1) * 0.125);
    }

    public static String generateDirtyMethod(Schema schema, Schema.Field field) {
        String getMethod = GoraCompiler.generateGetMethod((Schema)schema, (Schema.Field)field);
        String dirtyMethod = "is" + getMethod.substring(3) + "Dirty";
        return dirtyMethod;
    }

    public static String generateDefaultValueString(Schema schema, String fieldName) {
        if (fieldName == "__g__dirty") {
            return "java.nio.ByteBuffer.wrap(new byte[" + GoraCompiler.getNumberOfBytesNeededForDirtyBits(schema) + "])";
        }
        throw new IllegalArgumentException(fieldName + " is not a gora managed field.");
    }

    public static boolean isNotHiddenField(String fieldName) {
        return !GORA_HIDDEN_FIELD_NAMES.contains(fieldName);
    }

    GoraCompiler(Schema schema) {
        super(schema);
    }

    private static Schema getSchemaWithDirtySupport(Schema originalSchema, Map<Schema, Schema> queue) throws IOException {
        switch (originalSchema.getType()) {
            case RECORD: {
                if (queue.containsKey(originalSchema)) {
                    return queue.get(originalSchema);
                }
                return GoraCompiler.getRecordSchemaWithDirtySupport(originalSchema, queue);
            }
            case UNION: {
                return GoraCompiler.getUnionSchemaWithDirtySupport(originalSchema, queue);
            }
            case MAP: {
                return GoraCompiler.getMapSchemaWithDirtySupport(originalSchema, queue);
            }
            case ARRAY: {
                return GoraCompiler.getArraySchemaWithDirtySupport(originalSchema, queue);
            }
        }
        return originalSchema;
    }

    private static Schema getArraySchemaWithDirtySupport(Schema originalSchema, Map<Schema, Schema> queue) throws IOException {
        return Schema.createArray((Schema)GoraCompiler.getSchemaWithDirtySupport(originalSchema.getElementType(), queue));
    }

    private static Schema getMapSchemaWithDirtySupport(Schema originalSchema, Map<Schema, Schema> queue) throws IOException {
        return Schema.createMap((Schema)GoraCompiler.getSchemaWithDirtySupport(originalSchema.getValueType(), queue));
    }

    private static Schema getUnionSchemaWithDirtySupport(Schema originalSchema, Map<Schema, Schema> queue) throws IOException {
        List schemaTypes = originalSchema.getTypes();
        ArrayList<Schema> newTypeSchemas = new ArrayList<Schema>();
        for (int i = 0; i < schemaTypes.size(); ++i) {
            Schema currentTypeSchema = (Schema)schemaTypes.get(i);
            newTypeSchemas.add(GoraCompiler.getSchemaWithDirtySupport(currentTypeSchema, queue));
        }
        return Schema.createUnion(newTypeSchemas);
    }

    private static Schema getRecordSchemaWithDirtySupport(Schema originalSchema, Map<Schema, Schema> queue) throws IOException {
        if (originalSchema.getType() != Schema.Type.RECORD) {
            throw new IOException("Gora only supports record schemas.");
        }
        List originalFields = originalSchema.getFields();
        for (Schema.Field field : originalFields) {
            if (!GORA_RESERVED_NAMES.contains(field.name())) continue;
            throw new IOException("Gora schemas cannot contain the field name " + field.name());
        }
        Schema newSchema = Schema.createRecord((String)originalSchema.getName(), (String)originalSchema.getDoc(), (String)originalSchema.getNamespace(), (boolean)originalSchema.isError());
        queue.put(originalSchema, newSchema);
        ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
        byte[] defaultDirtyBytesValue = new byte[GoraCompiler.getNumberOfBytesNeededForDirtyBits(originalSchema)];
        Arrays.fill(defaultDirtyBytesValue, (byte)0);
        BinaryNode defaultDirtyJsonValue = JsonNodeFactory.instance.binaryNode(defaultDirtyBytesValue);
        Schema.Field dirtyBits = new Schema.Field(DIRTY_BYTES_FIELD_NAME, Schema.create((Schema.Type)Schema.Type.BYTES), "Bytes used to represent weather or not a field is dirty.", (JsonNode)defaultDirtyJsonValue);
        newFields.add(dirtyBits);
        for (Schema.Field originalField : originalFields) {
            Schema.Field newField = new Schema.Field(originalField.name(), GoraCompiler.getSchemaWithDirtySupport(originalField.schema(), queue), originalField.doc(), originalField.defaultValue(), originalField.order());
            newFields.add(newField);
        }
        newSchema.setFields(newFields);
        return newSchema;
    }

    static {
        GORA_RESERVED_NAMES.addAll(Arrays.asList(DIRTY_BYTES_FIELD_NAME));
        GORA_HIDDEN_FIELD_NAMES = new HashSet<String>();
        GORA_HIDDEN_FIELD_NAMES.add(DIRTY_BYTES_FIELD_NAME);
    }
}

