/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.compiler.cli;

import java.io.File;
import java.io.IOException;
import org.apache.gora.compiler.GoraCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoraCompilerCLI {
    private static final Logger LOG = LoggerFactory.getLogger(GoraCompilerCLI.class);

    public static void main(String[] args) {
        File outputDir;
        if (args.length == 1 && (args[0].equals("--help") || args[0].equals("-h"))) {
            GoraCompilerCLI.printHelp();
            System.exit(0);
        }
        if (args.length < 2) {
            LOG.error("Must supply at least one source file and an output directory.");
            GoraCompilerCLI.printHelp();
            System.exit(1);
        }
        if (!(outputDir = new File(args[args.length - 1])).isDirectory()) {
            LOG.error("Must supply a directory for output");
            GoraCompilerCLI.printHelp();
            System.exit(1);
        }
        File[] inputs = new File[args.length - 1];
        for (int i = 0; i < inputs.length; ++i) {
            File inputFile = new File(args[i]);
            if (!inputFile.isFile()) {
                LOG.error("Input must be a file.");
                GoraCompilerCLI.printHelp();
                System.exit(1);
            }
            inputs[i] = inputFile;
        }
        try {
            GoraCompiler.compileSchema((File[])inputs, (File)outputDir);
            LOG.info("Compiler executed SUCCESSFULL.");
        }
        catch (IOException e) {
            LOG.error("Error while compiling schema files. Check that the schemas are properly formatted.");
            GoraCompilerCLI.printHelp();
            throw new RuntimeException(e);
        }
    }

    private static void printHelp() {
        LOG.info("Usage: gora-compiler ( -h | --help ) | (<input> [<input>...] <output>)");
    }
}

