/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.compiler.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.gora.compiler.GoraCompiler;

public class GoraCompilerCLI {
    public static void main(String[] args) {
        File outputDir;
        if (args.length == 1 && (args[0].equals("--help") || args[0].equals("-h"))) {
            GoraCompilerCLI.printHelp();
            System.exit(0);
        }
        if (args.length < 2) {
            System.err.println("Must supply at least one source file and an output directory.");
            GoraCompilerCLI.printHelp();
            System.exit(1);
        }
        if (!(outputDir = new File(args[args.length - 1])).isDirectory()) {
            System.err.println("Must supply a directory for output");
            GoraCompilerCLI.printHelp();
            System.exit(1);
        }
        File[] inputs = new File[args.length - 1];
        for (int i = 0; i < inputs.length; ++i) {
            File inputFile = new File(args[i]);
            if (!inputFile.isFile()) {
                System.err.println("Input must be a file.");
                GoraCompilerCLI.printHelp();
                System.exit(1);
            }
            inputs[i] = inputFile;
        }
        try {
            GoraCompiler.compileSchema((File[])inputs, (File)outputDir);
            System.out.println("Compiler executed SUCCESSFULL.");
        }
        catch (IOException e) {
            System.err.println("Error while compiling schema files. Check that the schemas are properly formatted.");
            GoraCompilerCLI.printHelp();
            e.printStackTrace(System.err);
        }
    }

    private static void printHelp() {
        PrintStream out = System.out;
        out.println("Usage: gora-compiler ( -h | --help ) | (<input> [<input>...] <output>)");
    }
}

