/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.accumulo.encoders;

import org.apache.gora.accumulo.encoders.BinaryEncoder;

public class SignedBinaryEncoder
extends BinaryEncoder {
    @Override
    public byte[] encodeShort(short s, byte[] ret) {
        s = (short)(s & 0xFFFF ^ 0x8000);
        return super.encodeShort(s, ret);
    }

    @Override
    public short decodeShort(byte[] a) {
        short s = super.decodeShort(a);
        s = (short)(s & 0xFFFF ^ 0x8000);
        return s;
    }

    @Override
    public byte[] encodeInt(int i, byte[] ret) {
        return super.encodeInt(i ^= Integer.MIN_VALUE, ret);
    }

    @Override
    public int decodeInt(byte[] a) {
        int i = super.decodeInt(a);
        return i ^= Integer.MIN_VALUE;
    }

    @Override
    public byte[] encodeLong(long l, byte[] ret) {
        return super.encodeLong(l ^= Long.MIN_VALUE, ret);
    }

    @Override
    public long decodeLong(byte[] a) {
        long l = super.decodeLong(a);
        return l ^= Long.MIN_VALUE;
    }

    @Override
    public byte[] encodeDouble(double d, byte[] ret) {
        long l = Double.doubleToRawLongBits(d);
        l = l < 0L ? (l ^= 0xFFFFFFFFFFFFFFFFL) : (l ^= Long.MIN_VALUE);
        return super.encodeLong(l, ret);
    }

    @Override
    public double decodeDouble(byte[] a) {
        long l = super.decodeLong(a);
        l = l < 0L ? (l ^= Long.MIN_VALUE) : (l ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(l);
    }

    @Override
    public byte[] encodeFloat(float f, byte[] ret) {
        int i = Float.floatToRawIntBits(f);
        i = i < 0 ? (i ^= 0xFFFFFFFF) : (i ^= Integer.MIN_VALUE);
        return super.encodeInt(i, ret);
    }

    @Override
    public float decodeFloat(byte[] a) {
        int i = super.decodeInt(a);
        i = i < 0 ? (i ^= Integer.MIN_VALUE) : (i ^= 0xFFFFFFFF);
        return Float.intBitsToFloat(i);
    }
}

