/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.accumulo.encoders;

import org.apache.gora.accumulo.encoders.Encoder;
import org.apache.gora.accumulo.encoders.Utils;

public class HexEncoder
implements Encoder {
    private byte[] chars = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private void encode(byte[] a, long l) {
        for (int i = a.length - 1; i >= 0; --i) {
            a[i] = this.chars[(int)(l & 0xFL)];
            l >>>= 4;
        }
    }

    private int fromChar(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 97 && b <= 102) {
            return b - 97 + 10;
        }
        throw new IllegalArgumentException("Bad char " + b);
    }

    private long decode(byte[] a) {
        long b = 0L;
        for (int i = 0; i < a.length; ++i) {
            b <<= 4;
            b |= (long)this.fromChar(a[i]);
        }
        return b;
    }

    @Override
    public byte[] encodeByte(byte b, byte[] ret) {
        this.encode(ret, 0xFF & b);
        return ret;
    }

    @Override
    public byte[] encodeByte(byte b) {
        return this.encodeByte(b, new byte[2]);
    }

    @Override
    public byte decodeByte(byte[] a) {
        return (byte)this.decode(a);
    }

    @Override
    public byte[] encodeShort(short s) {
        return this.encodeShort(s, new byte[4]);
    }

    @Override
    public byte[] encodeShort(short s, byte[] ret) {
        this.encode(ret, 0xFFFF & s);
        return ret;
    }

    @Override
    public short decodeShort(byte[] a) {
        return (short)this.decode(a);
    }

    @Override
    public byte[] encodeInt(int i) {
        return this.encodeInt(i, new byte[8]);
    }

    @Override
    public byte[] encodeInt(int i, byte[] ret) {
        this.encode(ret, i);
        return ret;
    }

    @Override
    public int decodeInt(byte[] a) {
        return (int)this.decode(a);
    }

    @Override
    public byte[] encodeLong(long l) {
        return this.encodeLong(l, new byte[16]);
    }

    @Override
    public byte[] encodeLong(long l, byte[] ret) {
        this.encode(ret, l);
        return ret;
    }

    @Override
    public long decodeLong(byte[] a) {
        return this.decode(a);
    }

    @Override
    public byte[] encodeDouble(double d) {
        return this.encodeDouble(d, new byte[16]);
    }

    @Override
    public byte[] encodeDouble(double d, byte[] ret) {
        return this.encodeLong(Double.doubleToRawLongBits(d), ret);
    }

    @Override
    public double decodeDouble(byte[] a) {
        return Double.longBitsToDouble(this.decodeLong(a));
    }

    @Override
    public byte[] encodeFloat(float d) {
        return this.encodeFloat(d, new byte[16]);
    }

    @Override
    public byte[] encodeFloat(float d, byte[] ret) {
        return this.encodeInt(Float.floatToRawIntBits(d), ret);
    }

    @Override
    public float decodeFloat(byte[] a) {
        return Float.intBitsToFloat(this.decodeInt(a));
    }

    @Override
    public boolean decodeBoolean(byte[] val) {
        return this.decodeByte(val) == 1;
    }

    @Override
    public byte[] encodeBoolean(boolean b) {
        return this.encodeBoolean(b, new byte[2]);
    }

    @Override
    public byte[] encodeBoolean(boolean b, byte[] ret) {
        if (b) {
            this.encode(ret, 1L);
        } else {
            this.encode(ret, 0L);
        }
        return ret;
    }

    private byte[] toBinary(byte[] hex) {
        byte[] bin = new byte[hex.length / 2 + hex.length % 2];
        int j = 0;
        int i = 0;
        while (i < bin.length) {
            bin[i] = (byte)(this.fromChar(hex[j++]) << 4);
            if (j >= hex.length) break;
            int n = i++;
            bin[n] = (byte)(bin[n] | (byte)this.fromChar(hex[j++]));
        }
        return bin;
    }

    private byte[] fromBinary(byte[] bin) {
        byte[] hex = new byte[bin.length * 2];
        int j = 0;
        for (int i = 0; i < bin.length; ++i) {
            hex[j++] = this.chars[0xF & bin[i] >>> 4];
            hex[j++] = this.chars[0xF & bin[i]];
        }
        return hex;
    }

    @Override
    public byte[] followingKey(int size, byte[] per) {
        return this.fromBinary(Utils.followingKey(size, this.toBinary(per)));
    }

    @Override
    public byte[] lastPossibleKey(int size, byte[] er) {
        return this.fromBinary(Utils.lastPossibleKey(size, this.toBinary(er)));
    }
}

