/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.accumulo.encoders;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.gora.accumulo.encoders.Encoder;
import org.apache.gora.accumulo.encoders.Utils;
import org.apache.gora.accumulo.util.FixedByteArrayOutputStream;

public class BinaryEncoder
implements Encoder {
    @Override
    public byte[] encodeShort(short s) {
        return this.encodeShort(s, new byte[2]);
    }

    @Override
    public byte[] encodeShort(short s, byte[] ret) {
        try {
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            dos.writeShort(s);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public short decodeShort(byte[] a) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
            short s = dis.readShort();
            return s;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] encodeInt(int i) {
        return this.encodeInt(i, new byte[4]);
    }

    @Override
    public byte[] encodeInt(int i, byte[] ret) {
        try {
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            dos.writeInt(i);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public int decodeInt(byte[] a) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
            int i = dis.readInt();
            return i;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] encodeLong(long l) {
        return this.encodeLong(l, new byte[8]);
    }

    @Override
    public byte[] encodeLong(long l, byte[] ret) {
        try {
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            dos.writeLong(l);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public long decodeLong(byte[] a) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
            long l = dis.readLong();
            return l;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] encodeDouble(double d) {
        return this.encodeDouble(d, new byte[8]);
    }

    @Override
    public byte[] encodeDouble(double d, byte[] ret) {
        try {
            long l = Double.doubleToRawLongBits(d);
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            dos.writeLong(l);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public double decodeDouble(byte[] a) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
            long l = dis.readLong();
            return Double.longBitsToDouble(l);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] encodeFloat(float d) {
        return this.encodeFloat(d, new byte[4]);
    }

    @Override
    public byte[] encodeFloat(float f, byte[] ret) {
        try {
            int i = Float.floatToRawIntBits(f);
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            dos.writeInt(i);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public float decodeFloat(byte[] a) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
            int i = dis.readInt();
            return Float.intBitsToFloat(i);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] encodeByte(byte b, byte[] ret) {
        ret[0] = 0;
        return ret;
    }

    @Override
    public byte[] encodeByte(byte b) {
        return this.encodeByte(b, new byte[1]);
    }

    @Override
    public byte decodeByte(byte[] a) {
        return a[0];
    }

    @Override
    public boolean decodeBoolean(byte[] a) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
            return dis.readBoolean();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] encodeBoolean(boolean b) {
        return this.encodeBoolean(b, new byte[1]);
    }

    @Override
    public byte[] encodeBoolean(boolean b, byte[] ret) {
        try {
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            dos.writeBoolean(b);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public byte[] lastPossibleKey(int size, byte[] er) {
        return Utils.lastPossibleKey(size, er);
    }

    @Override
    public byte[] followingKey(int size, byte[] per) {
        return Utils.followingKey(size, per);
    }
}

