/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.accumulo.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mock.MockConnector;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.mock.MockTabletLocator;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.accumulo.core.iterators.user.TimestampFilter;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.thrift.AuthInfo;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.gora.accumulo.query.AccumuloQuery;
import org.apache.gora.accumulo.query.AccumuloResult;
import org.apache.gora.accumulo.store.AccumuloMapping;
import org.apache.gora.persistency.ListGenericArray;
import org.apache.gora.persistency.State;
import org.apache.gora.persistency.StateManager;
import org.apache.gora.persistency.StatefulHashMap;
import org.apache.gora.persistency.StatefulMap;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccumuloStore<K, T extends PersistentBase>
extends DataStoreBase<K, T> {
    protected static final String MOCK_PROPERTY = "accumulo.mock";
    protected static final String INSTANCE_NAME_PROPERTY = "accumulo.instance";
    protected static final String ZOOKEEPERS_NAME_PROPERTY = "accumulo.zookeepers";
    protected static final String USERNAME_PROPERTY = "accumulo.user";
    protected static final String PASSWORD_PROPERTY = "accumulo.password";
    protected static final String DEFAULT_MAPPING_FILE = "gora-accumulo-mapping.xml";
    private Connector conn;
    private BatchWriter batchWriter;
    private AccumuloMapping mapping;
    private AuthInfo authInfo;
    private org.apache.gora.accumulo.encoders.Encoder encoder;
    public static final Logger LOG = LoggerFactory.getLogger(AccumuloStore.class);

    public Object fromBytes(Schema schema, byte[] data) {
        return AccumuloStore.fromBytes(this.encoder, schema, data);
    }

    public static Object fromBytes(org.apache.gora.accumulo.encoders.Encoder encoder, Schema schema, byte[] data) {
        switch (schema.getType()) {
            case BOOLEAN: {
                return encoder.decodeBoolean(data);
            }
            case DOUBLE: {
                return encoder.decodeDouble(data);
            }
            case FLOAT: {
                return Float.valueOf(encoder.decodeFloat(data));
            }
            case INT: {
                return encoder.decodeInt(data);
            }
            case LONG: {
                return encoder.decodeLong(data);
            }
            case STRING: {
                return new Utf8(data);
            }
            case BYTES: {
                return ByteBuffer.wrap(data);
            }
            case ENUM: {
                return AvroUtils.getEnumValue((Schema)schema, (int)encoder.decodeInt(data));
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema.getType());
    }

    public K fromBytes(Class<K> clazz, byte[] val) {
        return AccumuloStore.fromBytes(this.encoder, clazz, val);
    }

    public static <K> K fromBytes(org.apache.gora.accumulo.encoders.Encoder encoder, Class<K> clazz, byte[] val) {
        try {
            if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
                return (K)Byte.valueOf(encoder.decodeByte(val));
            }
            if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
                return (K)Boolean.valueOf(encoder.decodeBoolean(val));
            }
            if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
                return (K)Short.valueOf(encoder.decodeShort(val));
            }
            if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                return (K)Integer.valueOf(encoder.decodeInt(val));
            }
            if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                return (K)Long.valueOf(encoder.decodeLong(val));
            }
            if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                return (K)Float.valueOf(encoder.decodeFloat(val));
            }
            if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
                return (K)Double.valueOf(encoder.decodeDouble(val));
            }
            if (clazz.equals(String.class)) {
                return (K)new String(val, "UTF-8");
            }
            if (clazz.equals(Utf8.class)) {
                return (K)new Utf8(val);
            }
            throw new IllegalArgumentException("Unknown type " + clazz.getName());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static byte[] copyIfNeeded(byte[] b, int offset, int len) {
        if (len != b.length || offset != 0) {
            byte[] copy = new byte[len];
            System.arraycopy(b, offset, copy, 0, copy.length);
            b = copy;
        }
        return b;
    }

    public byte[] toBytes(Object o) {
        return AccumuloStore.toBytes(this.encoder, o);
    }

    public static byte[] toBytes(org.apache.gora.accumulo.encoders.Encoder encoder, Object o) {
        try {
            if (o instanceof String) {
                return ((String)o).getBytes("UTF-8");
            }
            if (o instanceof Utf8) {
                return AccumuloStore.copyIfNeeded(((Utf8)o).getBytes(), 0, ((Utf8)o).getLength());
            }
            if (o instanceof ByteBuffer) {
                return AccumuloStore.copyIfNeeded(((ByteBuffer)o).array(), ((ByteBuffer)o).arrayOffset() + ((ByteBuffer)o).position(), ((ByteBuffer)o).remaining());
            }
            if (o instanceof Long) {
                return encoder.encodeLong((Long)o);
            }
            if (o instanceof Integer) {
                return encoder.encodeInt((Integer)o);
            }
            if (o instanceof Short) {
                return encoder.encodeShort((Short)o);
            }
            if (o instanceof Byte) {
                return encoder.encodeByte((Byte)o);
            }
            if (o instanceof Boolean) {
                return encoder.encodeBoolean((Boolean)o);
            }
            if (o instanceof Float) {
                return encoder.encodeFloat(((Float)o).floatValue());
            }
            if (o instanceof Double) {
                return encoder.encodeDouble((Double)o);
            }
            if (o instanceof Enum) {
                return encoder.encodeInt(((Enum)o).ordinal());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        throw new IllegalArgumentException("Uknown type " + o.getClass().getName());
    }

    private BatchWriter getBatchWriter() throws IOException {
        if (this.batchWriter == null) {
            try {
                this.batchWriter = this.conn.createBatchWriter(this.mapping.tableName, 10000000L, 60000L, 4);
            }
            catch (TableNotFoundException e) {
                throw new IOException(e);
            }
        }
        return this.batchWriter;
    }

    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        try {
            super.initialize(keyClass, persistentClass, properties);
            String mock = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)MOCK_PROPERTY, null);
            String mappingFile = DataStoreFactory.getMappingFile((Properties)properties, (DataStore)this, (String)DEFAULT_MAPPING_FILE);
            String user = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)USERNAME_PROPERTY, null);
            String password = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)PASSWORD_PROPERTY, null);
            this.mapping = this.readMapping(mappingFile);
            if (this.mapping.encoder == null || this.mapping.encoder.equals("")) {
                this.encoder = new org.apache.gora.accumulo.encoders.BinaryEncoder();
            } else {
                try {
                    this.encoder = (org.apache.gora.accumulo.encoders.Encoder)((Object)((Object)this)).getClass().getClassLoader().loadClass(this.mapping.encoder).newInstance();
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            try {
                if (mock == null || !mock.equals("true")) {
                    String instance = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)INSTANCE_NAME_PROPERTY, null);
                    String zookeepers = DataStoreFactory.findProperty((Properties)properties, (DataStore)this, (String)ZOOKEEPERS_NAME_PROPERTY, null);
                    this.conn = new ZooKeeperInstance(instance, zookeepers).getConnector(user, (CharSequence)password);
                    this.authInfo = new AuthInfo(user, ByteBuffer.wrap(password.getBytes()), this.conn.getInstance().getInstanceID());
                } else {
                    this.conn = new MockInstance().getConnector(user, (CharSequence)password);
                }
                if (this.autoCreateSchema) {
                    this.createSchema();
                }
            }
            catch (AccumuloException e) {
                throw new IOException(e);
            }
            catch (AccumuloSecurityException e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    protected AccumuloMapping readMapping(String filename) throws IOException {
        try {
            int j;
            int i;
            AccumuloMapping mapping = new AccumuloMapping();
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = db.parse(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename));
            Element root = dom.getDocumentElement();
            NodeList nl = root.getElementsByTagName("class");
            for (i = 0; i < nl.getLength(); ++i) {
                Element classElement = (Element)nl.item(i);
                if (!classElement.getAttribute("keyClass").equals(this.keyClass.getCanonicalName()) || !classElement.getAttribute("name").equals(this.persistentClass.getCanonicalName())) continue;
                mapping.tableName = this.getSchemaName(classElement.getAttribute("table"), this.persistentClass);
                mapping.encoder = classElement.getAttribute("encoder");
                NodeList fields = classElement.getElementsByTagName("field");
                for (j = 0; j < fields.getLength(); ++j) {
                    Element fieldElement = (Element)fields.item(j);
                    String name = fieldElement.getAttribute("name");
                    String family = fieldElement.getAttribute("family");
                    String qualifier = fieldElement.getAttribute("qualifier");
                    if (qualifier.equals("")) {
                        qualifier = null;
                    }
                    Pair col = new Pair((Object)new Text(family), (Object)(qualifier == null ? null : new Text(qualifier)));
                    mapping.fieldMap.put(name, (Pair<Text, Text>)col);
                    mapping.columnMap.put((Pair<Text, Text>)col, name);
                }
            }
            nl = root.getElementsByTagName("table");
            for (i = 0; i < nl.getLength(); ++i) {
                Element tableElement = (Element)nl.item(i);
                if (!tableElement.getAttribute("name").equals(mapping.tableName)) continue;
                NodeList configs = tableElement.getElementsByTagName("config");
                for (j = 0; j < configs.getLength(); ++j) {
                    Element configElement = (Element)configs.item(j);
                    String key = configElement.getAttribute("key");
                    String val = configElement.getAttribute("value");
                    mapping.tableConfig.put(key, val);
                }
            }
            return mapping;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String getSchemaName() {
        return this.mapping.tableName;
    }

    public void createSchema() {
        try {
            this.conn.tableOperations().create(this.mapping.tableName);
            Set<Map.Entry<String, String>> es = this.mapping.tableConfig.entrySet();
            for (Map.Entry<String, String> entry : es) {
                this.conn.tableOperations().setProperty(this.mapping.tableName, entry.getKey(), entry.getValue());
            }
        }
        catch (AccumuloException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
        catch (AccumuloSecurityException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
        catch (TableExistsException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public void deleteSchema() {
        try {
            if (this.batchWriter != null) {
                this.batchWriter.close();
            }
            this.batchWriter = null;
            this.conn.tableOperations().delete(this.mapping.tableName);
        }
        catch (AccumuloException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
        catch (AccumuloSecurityException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
        catch (TableNotFoundException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public boolean schemaExists() {
        return this.conn.tableOperations().exists(this.mapping.tableName);
    }

    public ByteSequence populate(Iterator<Map.Entry<Key, Value>> iter, T persistent) throws IOException {
        ByteSequence row = null;
        Map currentMap = null;
        ArrayList<Object> currentArray = null;
        Text currentFam = null;
        int currentPos = 0;
        Schema currentSchema = null;
        Schema.Field currentField = null;
        block5: while (iter.hasNext()) {
            String fieldName;
            Map.Entry<Key, Value> entry = iter.next();
            if (currentMap != null) {
                if (currentFam.equals((Object)entry.getKey().getColumnFamily())) {
                    currentMap.put(new Utf8(entry.getKey().getColumnQualifierData().toArray()), this.fromBytes(currentSchema, entry.getValue().get()));
                    continue;
                }
                persistent.put(currentPos, currentMap);
                currentMap = null;
            } else if (currentArray != null) {
                if (currentFam.equals((Object)entry.getKey().getColumnFamily())) {
                    currentArray.add(this.fromBytes(currentSchema, entry.getValue().get()));
                    continue;
                }
                persistent.put(currentPos, (Object)new ListGenericArray(currentField.schema(), currentArray));
                currentArray = null;
            }
            if (row == null) {
                row = entry.getKey().getRowData();
            }
            if ((fieldName = this.mapping.columnMap.get(new Pair((Object)entry.getKey().getColumnFamily(), (Object)entry.getKey().getColumnQualifier()))) == null) {
                fieldName = this.mapping.columnMap.get(new Pair((Object)entry.getKey().getColumnFamily(), null));
            }
            Schema.Field field = (Schema.Field)this.fieldMap.get(fieldName);
            switch (field.schema().getType()) {
                case MAP: {
                    currentMap = new StatefulHashMap();
                    currentPos = field.pos();
                    currentFam = entry.getKey().getColumnFamily();
                    currentSchema = field.schema().getValueType();
                    currentMap.put(new Utf8(entry.getKey().getColumnQualifierData().toArray()), this.fromBytes(currentSchema, entry.getValue().get()));
                    continue block5;
                }
                case ARRAY: {
                    currentArray = new ArrayList<Object>();
                    currentPos = field.pos();
                    currentFam = entry.getKey().getColumnFamily();
                    currentSchema = field.schema().getElementType();
                    currentField = field;
                    currentArray.add(this.fromBytes(currentSchema, entry.getValue().get()));
                    continue block5;
                }
                case RECORD: {
                    SpecificDatumReader reader = new SpecificDatumReader(field.schema());
                    byte[] val = entry.getValue().get();
                    BinaryDecoder decoder = DecoderFactory.defaultFactory().createBinaryDecoder(val, null);
                    persistent.put(field.pos(), reader.read(null, (Decoder)decoder));
                    continue block5;
                }
            }
            persistent.put(field.pos(), this.fromBytes(field.schema(), entry.getValue().get()));
        }
        if (currentMap != null) {
            persistent.put(currentPos, currentMap);
        } else if (currentArray != null) {
            persistent.put(currentPos, (Object)new ListGenericArray(currentField.schema(), currentArray));
        }
        persistent.clearDirty();
        return row;
    }

    private void setFetchColumns(Scanner scanner, String[] fields) {
        for (String field : fields = this.getFieldsToQuery(fields)) {
            Pair<Text, Text> col = this.mapping.fieldMap.get(field);
            if (col.getSecond() == null) {
                scanner.fetchColumnFamily((Text)col.getFirst());
                continue;
            }
            scanner.fetchColumn((Text)col.getFirst(), (Text)col.getSecond());
        }
    }

    public T get(K key, String[] fields) {
        try {
            IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.mapping.tableName, Constants.NO_AUTHS));
            Range rowRange = new Range(new Text(this.toBytes(key)));
            scanner.setRange(rowRange);
            this.setFetchColumns((Scanner)scanner, fields);
            PersistentBase persistent = this.newPersistent();
            ByteSequence row = this.populate(scanner.iterator(), persistent);
            if (row == null) {
                return null;
            }
            return (T)persistent;
        }
        catch (TableNotFoundException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
            return null;
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
            return null;
        }
    }

    public void put(K key, T val) {
        try {
            Mutation m = new Mutation(new Text(this.toBytes(key)));
            Schema schema = val.getSchema();
            StateManager stateManager = val.getStateManager();
            Iterator iter = schema.getFields().iterator();
            int count = 0;
            int i = 0;
            while (iter.hasNext()) {
                Schema.Field field = (Schema.Field)iter.next();
                if (stateManager.isDirty(val, i)) {
                    Object o = val.get(i);
                    Pair<Text, Text> col = this.mapping.fieldMap.get(field.name());
                    switch (field.schema().getType()) {
                        case MAP: {
                            Object mapKey;
                            Object map;
                            if (o instanceof StatefulMap) {
                                map = (StatefulMap)o;
                                Set es = map.states().entrySet();
                                for (Map.Entry entry : es) {
                                    mapKey = entry.getKey();
                                    State state = (State)entry.getValue();
                                    switch (state) {
                                        case NEW: 
                                        case DIRTY: {
                                            m.put((Text)col.getFirst(), new Text(this.toBytes(mapKey)), new Value(this.toBytes(map.get(mapKey))));
                                            ++count;
                                            break;
                                        }
                                        case DELETED: {
                                            m.putDelete((Text)col.getFirst(), new Text(this.toBytes(mapKey)));
                                            ++count;
                                        }
                                    }
                                }
                            } else {
                                map = (Map)o;
                                Set es = map.entrySet();
                                for (Map.Entry entry : es) {
                                    mapKey = entry.getKey();
                                    Object mapVal = entry.getValue();
                                    m.put((Text)col.getFirst(), new Text(this.toBytes(mapKey)), new Value(this.toBytes(mapVal)));
                                    ++count;
                                }
                            }
                            break;
                        }
                        case ARRAY: {
                            GenericArray array = (GenericArray)o;
                            int j = 0;
                            for (Map.Entry item : array) {
                                m.put((Text)col.getFirst(), new Text(this.toBytes(j++)), new Value(this.toBytes(item)));
                                ++count;
                            }
                            break;
                        }
                        case RECORD: {
                            SpecificDatumWriter writer = new SpecificDatumWriter(field.schema());
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            BinaryEncoder encoder = new BinaryEncoder((OutputStream)os);
                            writer.write(o, (Encoder)encoder);
                            encoder.flush();
                            m.put((Text)col.getFirst(), (Text)col.getSecond(), new Value(os.toByteArray()));
                            break;
                        }
                        default: {
                            m.put((Text)col.getFirst(), (Text)col.getSecond(), new Value(this.toBytes(o)));
                            ++count;
                        }
                    }
                }
                ++i;
            }
            if (count > 0) {
                try {
                    this.getBatchWriter().addMutation(m);
                }
                catch (MutationsRejectedException e) {
                    LOG.error(e.getMessage());
                    LOG.error(e.getStackTrace().toString());
                }
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public boolean delete(K key) {
        Query<K, T> q = this.newQuery();
        q.setKey(key);
        return this.deleteByQuery(q) > 0L;
    }

    public long deleteByQuery(Query<K, T> query) {
        try {
            Scanner scanner = this.createScanner(query);
            scanner.addScanIterator(new IteratorSetting(Integer.MAX_VALUE, SortedKeyIterator.class));
            RowIterator iterator = new RowIterator(scanner.iterator());
            long count = 0L;
            while (iterator.hasNext()) {
                Iterator row = iterator.next();
                Mutation m = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key key = (Key)entry.getKey();
                    if (m == null) {
                        m = new Mutation(key.getRow());
                    }
                    m.putDelete(key.getColumnFamily(), key.getColumnQualifier(), new ColumnVisibility(key.getColumnVisibility()), key.getTimestamp());
                }
                this.getBatchWriter().addMutation(m);
                ++count;
            }
            return count;
        }
        catch (TableNotFoundException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
            return 0L;
        }
        catch (MutationsRejectedException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
            return 0L;
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
            return 0L;
        }
    }

    private Range createRange(Query<K, T> query) {
        Text startRow = null;
        Text endRow = null;
        if (query.getStartKey() != null) {
            startRow = new Text(this.toBytes(query.getStartKey()));
        }
        if (query.getEndKey() != null) {
            endRow = new Text(this.toBytes(query.getEndKey()));
        }
        return new Range(startRow, true, endRow, true);
    }

    private Scanner createScanner(Query<K, T> query) throws TableNotFoundException {
        IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.mapping.tableName, Constants.NO_AUTHS));
        this.setFetchColumns((Scanner)scanner, query.getFields());
        scanner.setRange(this.createRange(query));
        if (query.getStartTime() != -1L || query.getEndTime() != -1L) {
            IteratorSetting is = new IteratorSetting(30, TimestampFilter.class);
            if (query.getStartTime() != -1L) {
                TimestampFilter.setStart((IteratorSetting)is, (long)query.getStartTime(), (boolean)true);
            }
            if (query.getEndTime() != -1L) {
                TimestampFilter.setEnd((IteratorSetting)is, (long)query.getEndTime(), (boolean)true);
            }
            scanner.addScanIterator(is);
        }
        return scanner;
    }

    public Result<K, T> execute(Query<K, T> query) {
        try {
            Scanner scanner = this.createScanner(query);
            return new AccumuloResult<K, T>(this, query, scanner);
        }
        catch (TableNotFoundException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
            return null;
        }
    }

    public Query<K, T> newQuery() {
        return new AccumuloQuery(this);
    }

    Text pad(Text key, int bytes) {
        if (key.getLength() < bytes) {
            key = new Text(key);
        }
        while (key.getLength() < bytes) {
            key.append(new byte[]{0}, 0, 1);
        }
        return key;
    }

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        try {
            Object tl = this.conn instanceof MockConnector ? new MockTabletLocator() : TabletLocator.getInstance((Instance)this.conn.getInstance(), (AuthInfo)this.authInfo, (Text)new Text(Tables.getTableId((Instance)this.conn.getInstance(), (String)this.mapping.tableName)));
            HashMap binnedRanges = new HashMap();
            tl.invalidateCache();
            while (tl.binRanges(Collections.singletonList(this.createRange(query)), binnedRanges).size() > 0) {
                if (!Tables.exists((Instance)this.conn.getInstance(), (String)Tables.getTableId((Instance)this.conn.getInstance(), (String)this.mapping.tableName))) {
                    throw new TableDeletedException(Tables.getTableId((Instance)this.conn.getInstance(), (String)this.mapping.tableName));
                }
                if (Tables.getTableState((Instance)this.conn.getInstance(), (String)Tables.getTableId((Instance)this.conn.getInstance(), (String)this.mapping.tableName)) == TableState.OFFLINE) {
                    throw new TableOfflineException(this.conn.getInstance(), Tables.getTableId((Instance)this.conn.getInstance(), (String)this.mapping.tableName));
                }
                UtilWaitThread.sleep((long)100L);
                tl.invalidateCache();
            }
            ArrayList<PartitionQuery<K, T>> ret = new ArrayList<PartitionQuery<K, T>>();
            Text startRow = null;
            Text endRow = null;
            if (query.getStartKey() != null) {
                startRow = new Text(this.toBytes(query.getStartKey()));
            }
            if (query.getEndKey() != null) {
                endRow = new Text(this.toBytes(query.getEndKey()));
            }
            HashMap<String, String> hostNameCache = new HashMap<String, String>();
            for (Map.Entry entry : binnedRanges.entrySet()) {
                String ip = ((String)entry.getKey()).split(":", 2)[0];
                String location = (String)hostNameCache.get(ip);
                if (location == null) {
                    InetAddress inetAddress = InetAddress.getByName(ip);
                    location = inetAddress.getHostName();
                    hostNameCache.put(ip, location);
                }
                Map tablets = (Map)entry.getValue();
                for (KeyExtent ke : tablets.keySet()) {
                    Object startKey = null;
                    if (startRow == null || !ke.contains((BinaryComparable)startRow)) {
                        if (ke.getPrevEndRow() != null) {
                            startKey = AccumuloStore.followingKey(this.encoder, this.getKeyClass(), TextUtil.getBytes((Text)ke.getPrevEndRow()));
                        }
                    } else {
                        startKey = this.fromBytes(this.getKeyClass(), TextUtil.getBytes((Text)startRow));
                    }
                    Object endKey = null;
                    if (endRow == null || !ke.contains((BinaryComparable)endRow)) {
                        if (ke.getEndRow() != null) {
                            endKey = AccumuloStore.lastPossibleKey(this.encoder, this.getKeyClass(), TextUtil.getBytes((Text)ke.getEndRow()));
                        }
                    } else {
                        endKey = this.fromBytes(this.getKeyClass(), TextUtil.getBytes((Text)endRow));
                    }
                    PartitionQueryImpl pqi = new PartitionQueryImpl(query, startKey, endKey, new String[]{location});
                    ret.add((PartitionQuery<K, T>)pqi);
                }
            }
            return ret;
        }
        catch (TableNotFoundException e) {
            throw new IOException(e);
        }
        catch (AccumuloException e) {
            throw new IOException(e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    static <K> K lastPossibleKey(org.apache.gora.accumulo.encoders.Encoder encoder, Class<K> clazz, byte[] er) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            throw new UnsupportedOperationException();
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            throw new UnsupportedOperationException();
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.lastPossibleKey(2, er));
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.lastPossibleKey(4, er));
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.lastPossibleKey(8, er));
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.lastPossibleKey(4, er));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.lastPossibleKey(8, er));
        }
        if (clazz.equals(String.class)) {
            throw new UnsupportedOperationException();
        }
        if (clazz.equals(Utf8.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, er);
        }
        throw new IllegalArgumentException("Unknown type " + clazz.getName());
    }

    static <K> K followingKey(org.apache.gora.accumulo.encoders.Encoder encoder, Class<K> clazz, byte[] per) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return (K)Byte.valueOf(encoder.followingKey(1, per)[0]);
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            throw new UnsupportedOperationException();
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.followingKey(2, per));
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.followingKey(4, per));
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.followingKey(8, per));
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.followingKey(4, per));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, encoder.followingKey(8, per));
        }
        if (clazz.equals(String.class)) {
            throw new UnsupportedOperationException();
        }
        if (clazz.equals(Utf8.class)) {
            return AccumuloStore.fromBytes(encoder, clazz, Arrays.copyOf(per, per.length + 1));
        }
        throw new IllegalArgumentException("Unknown type " + clazz.getName());
    }

    public void flush() {
        try {
            if (this.batchWriter != null) {
                this.batchWriter.flush();
            }
        }
        catch (MutationsRejectedException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public void close() {
        try {
            if (this.batchWriter != null) {
                this.batchWriter.close();
                this.batchWriter = null;
            }
        }
        catch (MutationsRejectedException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }
}

