/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.security;

import javax.servlet.ServletContext;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component(value="securityService")
public class RestSecurityService
implements ServletContextAware {
    private SecurityService securityService;

    public boolean authorize(String resource, String operation) {
        return this.authorize(resource, operation, null, null);
    }

    public boolean authorize(String resource, String operation, String region) {
        return this.authorize(resource, operation, region, null);
    }

    public void authorize(ResourcePermission permission) {
        this.securityService.authorize(permission);
    }

    public boolean authorize(String resource, String operation, String region, String key) {
        this.securityService.authorize(ResourcePermission.Resource.valueOf((String)resource), ResourcePermission.Operation.valueOf((String)operation), region, (Object)key);
        return true;
    }

    public boolean authorize(String operation, String region, String[] keys) {
        boolean authorized = false;
        for (String key : keys) {
            authorized = this.authorize("DATA", operation, region, key);
            if (authorized) continue;
            return false;
        }
        return true;
    }

    public Object postProcess(String regionPath, Object key, Object value, boolean valueIsSerialized) {
        return this.securityService.postProcess(regionPath, key, value, valueIsSerialized);
    }

    public void setServletContext(ServletContext servletContext) {
        this.securityService = (SecurityService)servletContext.getAttribute("org.apache.geode.securityService");
    }
}

