/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import java.util.Optional;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.internal.ClusterManagementOperationStatusResult;
import org.apache.geode.management.internal.operation.TaggedWithOperator;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.operation.RebalanceOperation;
import org.apache.geode.management.runtime.RebalanceResult;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="rebalanceOperation")
@RequestMapping(value={"/experimental"})
public class RebalanceOperationController
extends AbstractManagementController {
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/operations/rebalances"})
    public ResponseEntity<ClusterManagementOperationResult<RebalanceResult>> startRebalance(@RequestBody RebalanceOperation operation) {
        ClusterManagementOperationResult result;
        return new ResponseEntity((Object)result, (result = this.clusterManagementService.start((ClusterManagementOperation)new RebalanceOperationWithOperator(operation))).isSuccessful() ? HttpStatus.ACCEPTED : HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/operations/rebalances"})
    @ResponseBody
    public ClusterManagementListOperationsResult<RebalanceResult> listRebalances() {
        return this.clusterManagementService.list((ClusterManagementOperation)new RebalanceOperation());
    }

    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/operations/rebalances/{id}"})
    @ResponseBody
    public ResponseEntity<ClusterManagementOperationStatusResult<RebalanceResult>> checkRebalanceStatus(@PathVariable String id) {
        ClusterManagementOperationStatusResult result = this.clusterManagementService.checkStatus(id);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Retry-After", "30");
        return new ResponseEntity((Object)result, (MultiValueMap)headers, HttpStatus.OK);
    }

    private class RebalanceOperationWithOperator
    extends RebalanceOperation
    implements TaggedWithOperator {
        private String operator;

        public RebalanceOperationWithOperator(RebalanceOperation other) {
            super(other);
            this.operator = Optional.ofNullable(RebalanceOperationController.this.securityService).map(SecurityService::getSubject).map(Object::toString).orElse(null);
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

