/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementRealizationException;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ManagementControllerAdvice {
    private static final Logger logger = LogService.getLogger();

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ClusterManagementResult> internalError(Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, this.cleanup(e.getMessage())), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private String cleanup(String message) {
        if (message == null) {
            return "";
        }
        return message.replace("java.lang.Exception: ", "").replace("java.lang.RuntimeException: ", "").replace("java.util.concurrent.ExecutionException: ", "");
    }

    @ExceptionHandler(value={ClusterManagementException.class})
    public ResponseEntity<ClusterManagementResult> clusterManagementException(Exception e) {
        ClusterManagementResult result = ((ClusterManagementException)e).getResult();
        return new ResponseEntity((Object)result, this.mapToHttpStatus(result.getStatusCode()));
    }

    @ExceptionHandler(value={ClusterManagementRealizationException.class})
    public ResponseEntity<ClusterManagementRealizationResult> clusterManagementRealizationException(Exception e) {
        ClusterManagementRealizationResult result = (ClusterManagementRealizationResult)((ClusterManagementException)e).getResult();
        return new ResponseEntity((Object)result, this.mapToHttpStatus(result.getStatusCode()));
    }

    private HttpStatus mapToHttpStatus(ClusterManagementResult.StatusCode statusCode) {
        switch (statusCode) {
            case ENTITY_EXISTS: {
                return HttpStatus.CONFLICT;
            }
            case ENTITY_NOT_FOUND: {
                return HttpStatus.NOT_FOUND;
            }
            case ILLEGAL_ARGUMENT: {
                return HttpStatus.BAD_REQUEST;
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    @ExceptionHandler(value={AuthenticationFailedException.class, AuthenticationException.class})
    public ResponseEntity<ClusterManagementResult> unauthorized(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHENTICATED, e.getMessage()), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={NotAuthorizedException.class, SecurityException.class})
    public ResponseEntity<ClusterManagementResult> forbidden(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHORIZED, e.getMessage()), HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, HttpMessageNotReadableException.class})
    public ResponseEntity<ClusterManagementResult> badRequest(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e.getMessage()), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ClusterManagementResult> handleException(AccessDeniedException cause) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHORIZED, cause.getMessage()), HttpStatus.FORBIDDEN);
    }
}

