/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator.wan;

import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import org.apache.geode.cache.client.internal.locator.wan.LocatorDiscovery;
import org.apache.geode.cache.client.internal.locator.wan.LocatorHelper;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.logging.log4j.Logger;

public class WanLocatorDiscovererImpl
implements WanLocatorDiscoverer {
    private static final Logger logger = LogService.getLogger();
    private volatile boolean stopped = false;
    private ExecutorService _executor;

    public void discover(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener, String hostnameForClients) {
        this._executor = LoggingExecutors.newCachedThreadPool((String)"WAN Locator Discovery Thread", (boolean)true);
        this.exchangeLocalLocators(port, config, locatorListener, hostnameForClients);
        this.exchangeRemoteLocators(port, config, locatorListener, hostnameForClients);
        this._executor.shutdown();
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void exchangeLocalLocators(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener, String hostnameForClients) {
        String localLocator = config.getStartLocator();
        DistributionLocatorId locatorId = null;
        locatorId = localLocator.equals("") ? new DistributionLocatorId(port, config.getBindAddress(), hostnameForClients) : new DistributionLocatorId(localLocator);
        LocatorHelper.addLocator(config.getDistributedSystemId(), locatorId, locatorListener, null);
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(port, config, hostnameForClients);
        StringTokenizer locatorsOnThisVM = new StringTokenizer(config.getLocators(), ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            DistributionLocatorId localLocatorId = new DistributionLocatorId(locatorsOnThisVM.nextToken());
            if (locatorId.equals((Object)localLocatorId)) continue;
            LocatorDiscovery localDiscovery = new LocatorDiscovery(this, localLocatorId, request, locatorListener);
            LocatorDiscovery.LocalLocatorDiscovery localLocatorDiscovery = new LocatorDiscovery.LocalLocatorDiscovery(localDiscovery);
            this._executor.execute(localLocatorDiscovery);
        }
    }

    private void exchangeRemoteLocators(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener, String hostnameForClients) {
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(port, config, hostnameForClients);
        String remoteDistributedSystems = config.getRemoteLocators();
        if (remoteDistributedSystems.length() > 0) {
            StringTokenizer remoteLocators = new StringTokenizer(remoteDistributedSystems, ",");
            while (remoteLocators.hasMoreTokens()) {
                DistributionLocatorId remoteLocatorId = new DistributionLocatorId(remoteLocators.nextToken());
                LocatorDiscovery localDiscovery = new LocatorDiscovery(this, remoteLocatorId, request, locatorListener);
                LocatorDiscovery.RemoteLocatorDiscovery remoteLocatorDiscovery = new LocatorDiscovery.RemoteLocatorDiscovery(localDiscovery);
                this._executor.execute(remoteLocatorDiscovery);
            }
        }
    }

    private RemoteLocatorJoinRequest buildRemoteDSJoinRequest(int port, DistributionConfigImpl config, String hostnameForClients) {
        String localLocator = config.getStartLocator();
        DistributionLocatorId locatorId = null;
        locatorId = localLocator.equals("") ? new DistributionLocatorId(port, config.getBindAddress(), hostnameForClients) : new DistributionLocatorId(localLocator);
        RemoteLocatorJoinRequest request = new RemoteLocatorJoinRequest(config.getDistributedSystemId(), locatorId, "");
        return request;
    }
}

