/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.PulseConstants;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.TimeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterSelectedRegion")
@Scope(value="singleton")
public class ClusterSelectedRegionService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LogManager.getLogger();
    private final String ENTRY_SIZE = "entrySize";
    private static Comparator<Cluster.Member> memberCurrentHeapUsageComparator = (m1, m2) -> {
        long m2HeapUsage;
        long m1HeapUsage = m1.getCurrentHeapSize();
        if (m1HeapUsage < (m2HeapUsage = m2.getCurrentHeapSize())) {
            return -1;
        }
        if (m1HeapUsage > m2HeapUsage) {
            return 1;
        }
        return 0;
    };

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        String userName = request.getUserPrincipal().getName();
        String pulseData = request.getParameter("pulseData");
        JsonNode parameterMap = this.mapper.readTree(pulseData);
        String selectedRegionFullPath = parameterMap.get("ClusterSelectedRegion").get("regionFullPath").textValue();
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        responseJSON.put("clusterName", cluster.getServerName());
        responseJSON.put("userName", userName);
        responseJSON.put("selectedRegion", (JsonNode)this.getSelectedRegionJson(cluster, selectedRegionFullPath));
        return responseJSON;
    }

    private ObjectNode getSelectedRegionJson(Cluster cluster, String selectedRegionFullPath) {
        Long totalHeapSize = cluster.getTotalHeapSize();
        Long totalDiskUsage = cluster.getTotalBytesOnDisk();
        Cluster.Region reg = cluster.getClusterRegion(selectedRegionFullPath);
        if (reg != null) {
            ObjectNode regionJSON = this.mapper.createObjectNode();
            regionJSON.put("name", reg.getName());
            regionJSON.put("path", reg.getFullPath());
            regionJSON.put("totalMemory", totalHeapSize);
            regionJSON.put("systemRegionEntryCount", reg.getSystemRegionEntryCount());
            regionJSON.put("memberCount", reg.getMemberCount());
            String regionType = reg.getRegionType();
            regionJSON.put("type", regionType);
            regionJSON.put("getsRate", reg.getGetsRate());
            regionJSON.put("putsRate", reg.getPutsRate());
            regionJSON.put("lruEvictionRate", reg.getLruEvictionRate());
            Cluster.Member[] clusterMembersList = cluster.getMembers();
            ArrayList<Cluster.Member> clusterMembersL = new ArrayList<Cluster.Member>();
            for (String string : reg.getMemberName()) {
                for (Cluster.Member member : clusterMembersList) {
                    String name = member.getName();
                    name = name.replace(":", "-");
                    String id = member.getId();
                    if (!string.equals(id = id.replace(":", "-")) && !string.equals(name)) continue;
                    clusterMembersL.add(member);
                }
            }
            Collections.sort(clusterMembersL, memberCurrentHeapUsageComparator);
            ArrayNode memberArray = this.mapper.createArrayNode();
            for (Cluster.Member member : clusterMembersL) {
                ObjectNode regionMember = this.mapper.createObjectNode();
                regionMember.put("memberId", member.getId());
                regionMember.put("name", member.getName());
                regionMember.put("host", member.getHost());
                long usedHeapSize = cluster.getUsedHeapSize();
                long currentHeap = member.getCurrentHeapSize();
                if (usedHeapSize > 0L) {
                    double heapUsage = (double)currentHeap / (double)usedHeapSize * 100.0;
                    regionMember.put("heapUsage", PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(heapUsage));
                } else {
                    regionMember.put("heapUsage", 0);
                }
                double currentCPUUsage = member.getCpuUsage();
                double loadAvg = member.getLoadAverage();
                regionMember.put("cpuUsage", PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(currentCPUUsage));
                regionMember.put("currentHeapUsage", member.getCurrentHeapSize());
                regionMember.put("isManager", member.isManager());
                regionMember.put("uptime", TimeUtils.convertTimeSecondsToHMS(member.getUptime()));
                regionMember.put("loadAvg", PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(loadAvg));
                regionMember.put("sockets", member.getTotalFileDescriptorOpen());
                regionMember.put("threads", member.getNumThreads());
                regionMember.put("clients", member.getMemberClientsHMap().size());
                regionMember.put("queues", member.getQueueBacklog());
                memberArray.add((JsonNode)regionMember);
            }
            regionJSON.put("members", (JsonNode)memberArray);
            regionJSON.put("entryCount", reg.getSystemRegionEntryCount());
            regionJSON.put("persistence", reg.getPersistentEnabled() ? "ON" : "OFF");
            regionJSON.put("isEnableOffHeapMemory", reg.isEnableOffHeapMemory() ? "ON" : "OFF");
            String string = reg.getCompressionCodec();
            if (StringUtils.isNotBlank((String)string)) {
                regionJSON.put("compressionCodec", reg.getCompressionCodec());
            } else {
                regionJSON.put("compressionCodec", "NA");
            }
            regionJSON.put("regionPath", reg.getFullPath());
            regionJSON.put("memoryReadsTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(0)));
            regionJSON.put("memoryWritesTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(1)));
            regionJSON.put("diskReadsTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(3)));
            regionJSON.put("diskWritesTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(4)));
            regionJSON.put("emptyNodes", reg.getEmptyNode());
            Long entrySize = reg.getEntrySize();
            String entrySizeInMB = PulseConstants.FOUR_PLACE_DECIMAL_FORMAT.format((float)entrySize.longValue() / 1048576.0f);
            if (entrySize < 0L) {
                regionJSON.put(this.ENTRY_SIZE, "NA");
            } else {
                regionJSON.put(this.ENTRY_SIZE, entrySizeInMB);
            }
            regionJSON.put("dataUsage", reg.getDiskUsage());
            regionJSON.put("wanEnabled", reg.getWanEnabled());
            regionJSON.put("totalDataUsage", totalDiskUsage);
            regionJSON.put("memoryUsage", entrySizeInMB);
            logger.debug("calling getSelectedRegionJson :: regionJSON = {}", (Object)regionJSON);
            return regionJSON;
        }
        ObjectNode responseJSON = this.mapper.createObjectNode();
        responseJSON.put("errorOnRegion", "Region [" + selectedRegionFullPath + "] is not available");
        return responseJSON;
    }
}

