/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="QueryStatistics")
@Scope(value="singleton")
public class QueryStatisticsService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        Cluster.Statement[] stmts = cluster.getStatements();
        ArrayNode queryListJson = this.mapper.createArrayNode();
        for (int i = 0; i < stmts.length; ++i) {
            ObjectNode queryJSON = this.mapper.createObjectNode();
            queryJSON.put("Query", stmts[i].getQueryDefinition());
            queryJSON.put("NumTimesCompiled", this.mapper.valueToTree(stmts[i].getNumTimesCompiled() < 0L ? "NA" : Long.valueOf(stmts[i].getNumTimesCompiled())));
            queryJSON.put("NumExecution", this.mapper.valueToTree(stmts[i].getNumExecution() < 0L ? "NA" : Long.valueOf(stmts[i].getNumExecution())));
            queryJSON.put("NumExecutionsInProgress", this.mapper.valueToTree(stmts[i].getNumExecutionsInProgress() < 0L ? "NA" : Long.valueOf(stmts[i].getNumExecutionsInProgress())));
            queryJSON.put("NumTimesGlobalIndexLookup", this.mapper.valueToTree(stmts[i].getNumTimesGlobalIndexLookup() < 0L ? "NA" : Long.valueOf(stmts[i].getNumTimesGlobalIndexLookup())));
            queryJSON.put("NumRowsModified", this.mapper.valueToTree(stmts[i].getNumRowsModified() < 0L ? "NA" : Long.valueOf(stmts[i].getNumRowsModified())));
            queryJSON.put("ParseTime", this.mapper.valueToTree(stmts[i].getParseTime() < 0L ? "NA" : Long.valueOf(stmts[i].getParseTime())));
            queryJSON.put("BindTime", this.mapper.valueToTree(stmts[i].getBindTime() < 0L ? "NA" : Long.valueOf(stmts[i].getBindTime())));
            queryJSON.put("OptimizeTime", this.mapper.valueToTree(stmts[i].getOptimizeTime() < 0L ? "NA" : Long.valueOf(stmts[i].getOptimizeTime())));
            queryJSON.put("RoutingInfoTime", this.mapper.valueToTree(stmts[i].getRoutingInfoTime() < 0L ? "NA" : Long.valueOf(stmts[i].getRoutingInfoTime())));
            queryJSON.put("GenerateTime", this.mapper.valueToTree(stmts[i].getGenerateTime() < 1L ? "NA" : Long.valueOf(stmts[i].getGenerateTime())));
            queryJSON.put("TotalCompilationTime", this.mapper.valueToTree(stmts[i].getTotalCompilationTime() < 0L ? "NA" : Long.valueOf(stmts[i].getTotalCompilationTime())));
            queryJSON.put("ExecutionTime", this.mapper.valueToTree(stmts[i].getExecutionTime() < 0L ? "NA" : Long.valueOf(stmts[i].getExecutionTime())));
            queryJSON.put("ProjectionTime", this.mapper.valueToTree(stmts[i].getProjectionTime() < 0L ? "NA" : Long.valueOf(stmts[i].getProjectionTime())));
            queryJSON.put("TotalExecutionTime", this.mapper.valueToTree(stmts[i].getTotalExecutionTime() < 0L ? "NA" : Long.valueOf(stmts[i].getTotalExecutionTime())));
            queryJSON.put("RowsModificationTime", this.mapper.valueToTree(stmts[i].getRowsModificationTime() < 0L ? "NA" : Long.valueOf(stmts[i].getRowsModificationTime())));
            queryJSON.put("QNNumRowsSeen", this.mapper.valueToTree(stmts[i].getqNNumRowsSeen() < 0L ? "NA" : Long.valueOf(stmts[i].getqNNumRowsSeen())));
            queryJSON.put("QNMsgSendTime", this.mapper.valueToTree(stmts[i].getqNMsgSendTime() < 0L ? "NA" : Long.valueOf(stmts[i].getqNMsgSendTime())));
            queryJSON.put("QNMsgSerTime", this.mapper.valueToTree(stmts[i].getqNMsgSerTime() < 0L ? "NA" : Long.valueOf(stmts[i].getqNMsgSerTime())));
            queryJSON.put("QNRespDeSerTime", this.mapper.valueToTree(stmts[i].getqNRespDeSerTime() < 0L ? "NA" : Long.valueOf(stmts[i].getqNRespDeSerTime())));
            queryListJson.add((JsonNode)queryJSON);
        }
        responseJSON.put("queriesList", (JsonNode)queryListJson);
        responseJSON.put("connectedFlag", cluster.isConnectedFlag());
        responseJSON.put("connectedErrorMsg", cluster.getConnectionErrorMsg());
        return responseJSON;
    }
}

